/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.cms.action.schedule.ingest;

import com.tandbergtv.watchpoint.cms.util.schedule.ingest.FileType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InsertCDATAAnotation
implements ActionHandler {
    private static final long serialVersionUID = 2459714285651253195L;
    private static String CONVERTED_TEMP_FILE_PATH = "convertedTempFilepath";
    private static String FILE_TYPE = "type";
    private static String XPATH_PLANNER_ASSET = "/planners/planner/titles/title/asset";
    private static String XPATH_PROGRAM_LIST_ASSET = "/titles/title/asset";
    private static Logger logger = Logger.getLogger(InsertCDATAAnotation.class);

    public void execute(ExecutionContext context) throws Exception {
        String outputFilepath = (String)context.getVariable(CONVERTED_TEMP_FILE_PATH);
        String fileType = (String)context.getVariable(FILE_TYPE);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        Document doc = docBuilder.parse(new File(outputFilepath));
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList assetsSet = null;
        logger.debug((Object)("fileType=" + fileType));
        logger.debug((Object)("FileType.PLANNER.getValue()=" + FileType.PLANNER.getValue()));
        assetsSet = fileType.equals(FileType.PLANNER.getValue()) ? (NodeList)xPath.evaluate(XPATH_PLANNER_ASSET, doc, XPathConstants.NODESET) : (NodeList)xPath.evaluate(XPATH_PROGRAM_LIST_ASSET, doc, XPathConstants.NODESET);
        if (assetsSet != null) {
            for (int i = 0; i < assetsSet.getLength(); ++i) {
                Node assetNode = assetsSet.item(i);
                Node metadataContentNode = assetNode.getFirstChild();
                String metadataContent = this.convertToString(metadataContentNode);
                CDATASection wrappedMetadataContent = doc.createCDATASection(metadataContent);
                assetNode.removeChild(metadataContentNode);
                assetNode.appendChild(wrappedMetadataContent);
            }
            this.print(doc, outputFilepath);
        }
    }

    private void print(Document doc, String outputFile) {
        FileOutputStream fs = null;
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            fs = new FileOutputStream(outputFile);
            StreamResult result = new StreamResult(fs);
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            logger.error((Object)"Error while printing output doc: ", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            logger.error((Object)"Error while printing output doc: ", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            logger.error((Object)"Error while printing output doc: ", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"Error while printing output doc: ", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (IOException e) {
                    logger.error((Object)"Error while closing the stream: ", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private String convertToString(Node node) throws Exception {
        Document document;
        StringWriter w = new StringWriter();
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        Document document2 = document = node instanceof Document ? (Document)Document.class.cast(node) : node.getOwnerDocument();
        if (document.getXmlEncoding() != null) {
            transformer.setOutputProperty("encoding", document.getXmlEncoding());
        }
        transformer.transform(new DOMSource(node), new StreamResult(w));
        return w.getBuffer().toString();
    }
}

