/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.cms.action.schedule.ingest.converter;

import com.tandbergtv.watchpoint.cms.action.schedule.ingest.converter.IScheduleConverter;
import com.tandbergtv.watchpoint.cms.util.schedule.ingest.ConversionResult;
import com.tandbergtv.watchpoint.cms.util.schedule.ingest.FileType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DefaultProgramListConverter
implements IScheduleConverter {
    private static String FILE_NAME_EXTN_SEPARATOR = ".";
    private static final String VALID_FILE_EXTN = "xml";
    String XPATH_SPEC = "/titles/spec";

    @Override
    public boolean canConvert(String inputFilename) {
        int index = inputFilename.lastIndexOf(FILE_NAME_EXTN_SEPARATOR);
        String xtn = inputFilename.substring(index + 1);
        return xtn.equals(VALID_FILE_EXTN);
    }

    @Override
    public ConversionResult convert(String inputFilepath, String outputPath) {
        ConversionResult result = new ConversionResult();
        result.setFileType(FileType.PROGRAM_LIST);
        try {
            this.copyFile(inputFilepath, outputPath);
            String spec = this.getSpec(inputFilepath);
            result.setSpec(spec);
        }
        catch (RuntimeException e) {
            result.setErrorMsg(e.getMessage());
        }
        catch (ParserConfigurationException e) {
            result.setErrorMsg(e.getMessage());
        }
        catch (SAXException e) {
            result.setErrorMsg(e.getMessage());
        }
        catch (IOException e) {
            result.setErrorMsg(e.getMessage());
        }
        catch (XPathExpressionException e) {
            result.setErrorMsg(e.getMessage());
        }
        return result;
    }

    private String getSpec(String inputFilepath) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        String spec = "";
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        Document doc = docBuilder.parse(new File(inputFilepath));
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList specSet = (NodeList)xPath.evaluate(this.XPATH_SPEC, doc, XPathConstants.NODESET);
        if (specSet != null) {
            spec = specSet.item(0).getTextContent();
        }
        return spec;
    }

    private void copyFile(String inputFilepath, String outputPath) {
        File input = new File(inputFilepath);
        File output = new File(outputPath);
        try {
            FileChannel inChannel = new FileInputStream(input).getChannel();
            FileChannel outChannel = new FileOutputStream(output).getChannel();
            try {
                inChannel.transferTo(0L, inChannel.size(), outChannel);
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                if (inChannel != null) {
                    inChannel.close();
                }
                if (outChannel != null) {
                    outChannel.close();
                }
            }
        }
        catch (FileNotFoundException e) {
            String errorMsg = "File: " + inputFilepath + " not found.";
            throw new RuntimeException(errorMsg, e);
        }
        catch (IOException e) {
            String errorMsg = "IOException while copying input file: " + inputFilepath;
            throw new RuntimeException(errorMsg, e);
        }
    }
}

