/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.cms.action;

import java.io.File;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class DeleteAllFilesAction
implements ActionHandler {
    private static final String ERROR_MESSAGE = "error-message";
    private static final String ALL_FILES_DELETED = "allFilesDeleted";
    private static final String UNDELETED_FILES_PATHS = "undeletedFilesPaths";
    private static final long serialVersionUID = -7693456999179074230L;
    private static final String LIST_OF_FILES = "listOfFiles";
    protected final Logger logger = Logger.getLogger(this.getClass());

    public void execute(ExecutionContext context) throws Exception {
        String listOfFiles = this.getStringValue(context, LIST_OF_FILES);
        String[] fileArray = listOfFiles.split(",");
        String undeletedFilesPaths = "";
        if (fileArray != null) {
            for (String url : fileArray) {
                if (url.equals("")) continue;
                String undeletedFile = "";
                File physicalFile = new File(url);
                File physicalDirectory = physicalFile.getParentFile();
                try {
                    if (!physicalFile.delete()) {
                        undeletedFile = url;
                        this.logger.error((Object)("Could not delete file: " + url));
                    }
                    this.logger.debug((Object)("Successfully deleted file: " + url));
                }
                catch (Throwable t) {
                    undeletedFile = url;
                }
                try {
                    if (physicalDirectory.isDirectory() && physicalDirectory.listFiles().length == 0) {
                        physicalDirectory.delete();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (undeletedFile.equals("")) continue;
                undeletedFilesPaths = undeletedFilesPaths + undeletedFile + ",";
            }
        }
        if (undeletedFilesPaths.equals("")) {
            context.setVariable(ALL_FILES_DELETED, (Object)true);
        } else {
            context.setVariable(ALL_FILES_DELETED, (Object)false);
            context.setVariable(UNDELETED_FILES_PATHS, (Object)undeletedFilesPaths);
            context.setVariable(ERROR_MESSAGE, (Object)"Some files could not be deleted.");
        }
    }

    private String getStringValue(ExecutionContext context, String variableName) {
        Object value = context.getVariable(variableName);
        return value == null ? "" : value.toString();
    }
}

