/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.cms.action.content.distribution;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class ReadMetadata
implements ActionHandler {
    private static final long serialVersionUID = 6510675565655967893L;
    private static final Logger logger = Logger.getLogger(ReadMetadata.class);
    public static String ASSET_PROCESSING_PROPERTIES = "/cms-template-actions/contentProcessing.properties";
    private static final String GROUP_ASSET_ID_SPEC_XPATH = "//*[local-name()='Group'][@type='PACKAGE']/*[local-name()='Fields']/*[local-name()='TTVId']/*[local-name()='Id']";
    private static final String TITLE_BRIEF_XPATH = "//*[local-name()='Fields']/*[local-name()='Title']/*[local-name()='ShortTitle']";
    public static final String LICENSING_WINDOW_START_XPATH = "//*[local-name()='Fields']/*[local-name()='Rights']/*[local-name()='LicensingWindowStart']";
    public static final String LICENSING_WINDOW_END_XPATH = "//*[local-name()='Fields']/*[local-name()='Rights']/*[local-name()='LicensingWindowEnd']";

    public void execute(ExecutionContext context) throws Exception {
        String fileName = this.getStringValue(context, "outputMetadataFilePathInternalSpec");
        logger.debug((Object)("outputMetadataFilePathInternalSpec=" + fileName));
        Document doc = this.getDocument(fileName, context);
        NodeList nodes = this.getNodes(GROUP_ASSET_ID_SPEC_XPATH, doc);
        String groupAssetId = "";
        if (nodes != null && nodes.item(0) != null) {
            groupAssetId = nodes.item(0).getTextContent();
            context.setVariable("groupAssetId", (Object)groupAssetId);
        }
        if ((nodes = this.getNodes(TITLE_BRIEF_XPATH, doc)) != null && nodes.item(0) != null) {
            String titleBrief = nodes.item(0).getTextContent();
            context.setVariable("titleBrief", (Object)titleBrief);
        }
        if ((nodes = this.getNodes(LICENSING_WINDOW_START_XPATH, doc)) != null && nodes.item(0) != null) {
            String licStart = nodes.item(0).getTextContent();
            context.setVariable("licensingWindowStart", (Object)licStart);
        }
        if ((nodes = this.getNodes(LICENSING_WINDOW_END_XPATH, doc)) != null && nodes.item(0) != null) {
            String licEnd = nodes.item(0).getTextContent();
            context.setVariable("licensingWindowEnd", (Object)licEnd);
        }
    }

    private NodeList getNodes(String xpathStr, Document doc) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList nodes = (NodeList)xpath.evaluate(xpathStr, doc, XPathConstants.NODESET);
        return nodes;
    }

    private String getStringValue(ExecutionContext context, String variableName) {
        Object value = context.getVariable(variableName);
        return value == null ? null : value.toString();
    }

    private Document getDocument(String path, ExecutionContext context) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            return docBuilder.parse(new File(path));
        }
        catch (Exception e) {
            String msg = "Exception occurred while trying to read file: " + path + " - " + e.getMessage();
            context.setVariable("error-message", (Object)msg);
            throw new RuntimeException(msg, e);
        }
    }
}

