/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.cms.action.content.ingest;

import com.tandbergtv.watchpoint.cms.util.DateUtility;
import com.tandbergtv.watchpoint.cms.util.PathProperties;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class DemoAssetIngestInitializeVariables
implements ActionHandler {
    private static final long serialVersionUID = -5476552838428097292L;
    private static final Logger logger = Logger.getLogger(DemoAssetIngestInitializeVariables.class);
    private static final String FOLDER_DATE_FORMAT = "folder.date.format";
    private static final String METADATA_FILE_EXTENSION = ".xml";

    public void execute(ExecutionContext context) throws Exception {
        long tokenId = context.getToken().getId();
        long processId = context.getProcessInstance().getId();
        context.setVariable("sourceId", (Object)(Long.toString(processId) + "|" + Long.toString(tokenId)));
        this.makeOriginalFileDirectory(context);
        this.setFilePaths(context);
    }

    public void setFilePaths(ExecutionContext context) throws Exception {
        String contentPath = this.getStringValue(context, "extractFilePath");
        String inputFilePath = this.getStringValue(context, "filePath");
        File inputFile = new File(inputFilePath);
        if (!inputFile.exists()) {
            throw new IOException("Unable to get the input file: " + inputFile);
        }
        String fileName = inputFile.getName();
        if (this.isMetadataFile(fileName)) {
            String metadataFilePath = contentPath + File.separator + fileName;
            context.setVariable("isMetadataFile", (Object)true);
            context.setVariable("metadataFilePath", (Object)metadataFilePath);
        } else {
            String assetFilePath = contentPath + File.separator + fileName;
            context.setVariable("mapFilePath", (Object)assetFilePath);
            context.setVariable("isMetadataFile", (Object)false);
        }
        context.setVariable("filename", (Object)fileName);
        int lastDotIndex = fileName.lastIndexOf(".");
        if (lastDotIndex != -1) {
            String fileExtension = fileName.substring(lastDotIndex).toLowerCase();
            context.setVariable("inputFileExtension", (Object)fileExtension);
        }
    }

    private boolean isMetadataFile(String fileName) {
        if (fileName == null) {
            return false;
        }
        return fileName.toLowerCase().endsWith(METADATA_FILE_EXTENSION);
    }

    private void makeOriginalFileDirectory(ExecutionContext context) throws Exception {
        String filePath = this.getStringValue(context, "filePath");
        File file = new File(filePath);
        String providerId = this.getStringValue(context, "providerId");
        String providerPath = PathProperties.getProviderPath(providerId);
        String date = DateUtility.formatDate(new Date(), FOLDER_DATE_FORMAT);
        String assetPath = PathProperties.getProperty("provider.original.asset");
        String originalAssetDirPath = providerPath + File.separator + date + File.separator + assetPath;
        File originalAssetDir = new File(originalAssetDirPath);
        String originalFileDirName = file.getName() + "_" + System.currentTimeMillis();
        File originalFileDir = new File(originalAssetDir, originalFileDirName);
        context.setVariable("extractFilePath", (Object)originalFileDir.getAbsolutePath());
    }

    private String getStringValue(ExecutionContext context, String variableName) {
        Object value = context.getVariable(variableName);
        return value != null ? value.toString() : null;
    }
}

