/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.cms.action.content.ingest;

import com.tandbergtv.watchpoint.cms.util.PathConverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class UpdateLoopVariables
implements ActionHandler {
    private static final long serialVersionUID = 4860895485280005433L;
    private static final String MAPPED_ASSET_FILES = "mappedAssetFiles:";
    private static final Logger logger = Logger.getLogger(UpdateLoopVariables.class);

    public void execute(ExecutionContext context) throws IOException {
        List<String> filePathList;
        String mapFilePaths = this.getStringValue(context, "mapFilePaths");
        logger.debug((Object)("mapFilePaths=" + mapFilePaths));
        if (mapFilePaths != null) {
            filePathList = this.convertCommaSepListtoList(mapFilePaths);
        } else {
            int vertBarInd;
            filePathList = new ArrayList<String>();
            String mappedTitles = this.getStringValue(context, "titlesMapped");
            int mappedFilesInd = mappedTitles.indexOf(MAPPED_ASSET_FILES);
            if (mappedFilesInd != -1 && (vertBarInd = mappedTitles.indexOf("|", mappedFilesInd)) != -1) {
                String[] pairs;
                String mappedFiles = mappedTitles.substring(mappedFilesInd + MAPPED_ASSET_FILES.length(), vertBarInd - 1);
                for (String s : pairs = mappedFiles.split(",")) {
                    if (s == null || s.equals("")) continue;
                    logger.debug((Object)("pair=" + s));
                    int equalsInd = s.indexOf("=");
                    if (equalsInd == -1) continue;
                    String filePath = s.substring(0, equalsInd);
                    filePathList.add(filePath.trim());
                }
            }
            context.setVariable("mapFilePaths", (Object)this.convertListToCommaSepList(filePathList));
            logger.debug((Object)("filePathList [" + filePathList + "] converted to mapFilePaths"));
        }
        int loopIndex = this.getIntegerValue(context, "mapFileIndex", -1) + 1;
        String filePath = filePathList.get(loopIndex).trim();
        boolean hasMoreFiles = loopIndex + 1 < filePathList.size();
        int lastDotIndex = filePath.lastIndexOf(".");
        String fileExtension = "";
        if (lastDotIndex != -1) {
            fileExtension = filePath.substring(lastDotIndex).toLowerCase();
        }
        logger.debug((Object)("filePath=" + filePath + "."));
        context.setVariable("mapFilePath", (Object)filePath);
        context.setVariable("mapFilePathUNC", (Object)PathConverter.getInstance().convertUnixToUNC(filePath));
        context.setVariable("hasMoreMapFiles", (Object)hasMoreFiles);
        context.setVariable("mapFileIndex", (Object)loopIndex);
        context.setVariable("mapFileCount", (Object)new Integer(filePathList.size()));
        context.setVariable("inputFileExtension", (Object)fileExtension);
    }

    private String convertListToCommaSepList(List<String> list) {
        StringBuffer commaSepListSB = new StringBuffer();
        boolean firstTime = true;
        for (String s : list) {
            if (firstTime) {
                firstTime = false;
            } else {
                commaSepListSB.append(",");
            }
            commaSepListSB.append(s);
        }
        return commaSepListSB.toString();
    }

    private List<String> convertCommaSepListtoList(String commaSepList) {
        return Arrays.asList(commaSepList.split(","));
    }

    private String getStringValue(ExecutionContext context, String variableName) {
        Object value = context.getVariable(variableName);
        return value != null ? value.toString() : null;
    }

    private int getIntegerValue(ExecutionContext context, String variableName, int defaultValue) {
        int intValue = defaultValue;
        Object value = context.getVariable(variableName);
        if (value == null) {
            intValue = defaultValue;
        } else if (value instanceof Integer) {
            intValue = (Integer)value;
        } else {
            try {
                intValue = Integer.parseInt(value.toString());
            }
            catch (NumberFormatException e) {
                logger.warn((Object)("Failed to parse value: " + value + " to an integer when getting Asset Mapping Loop Index, " + "using default value: " + defaultValue), (Throwable)e);
            }
        }
        return intValue;
    }
}

