/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.cms.action.content.processing;

import com.tandbergtv.watchpoint.cms.action.content.processing.EncoderProfileCriteria;
import com.tandbergtv.watchpoint.cms.action.content.processing.EncoderProfileCriteriaLoader;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class ProfileSelectorAction
implements ActionHandler {
    private static final Logger logger = Logger.getLogger(ProfileSelectorAction.class);
    private static final String ENCODING_PROFILE = "EncodingProfile";
    private static final long serialVersionUID = 6646783291083554257L;

    public void execute(ExecutionContext executionContext) throws Exception {
        Object obj = executionContext.getVariable(ENCODING_PROFILE);
        if (obj != null && obj.toString().length() > 0) {
            return;
        }
        String profileName = this.findProfile(executionContext);
        logger.debug((Object)("Profile Selected:" + profileName));
        executionContext.setVariable(ENCODING_PROFILE, (Object)profileName);
    }

    private String findProfile(ExecutionContext executionContext) {
        List<EncoderProfileCriteria> profiles = EncoderProfileCriteriaLoader.getInstance().getProfiles();
        for (EncoderProfileCriteria profile : profiles) {
            boolean profileMatch = true;
            HashMap<String, String> criteria = profile.getCriteria();
            for (String key : criteria.keySet()) {
                String name = key.toString();
                String value = criteria.get(key);
                Object processVar = executionContext.getVariable(name);
                if (processVar != null && processVar.toString().equals(value)) continue;
                profileMatch = false;
                break;
            }
            if (!profileMatch) continue;
            return profile.getName();
        }
        return EncoderProfileCriteriaLoader.getInstance().getDefaultProfileName();
    }
}

