/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.cms.action.content.processing;

import com.tandbergtv.watchpoint.cms.util.PathConverter;
import java.io.File;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class SetReencodeVariablesAction
implements ActionHandler {
    private static final Logger logger = Logger.getLogger(SetReencodeVariablesAction.class);
    private static final long serialVersionUID = 6510671693435967893L;
    public static String ASSET_PROCESSING_PROPERTIES = "/cms-template-actions/contentProcessing.properties";

    public void execute(ExecutionContext context) throws Exception {
        InputStream stream = this.getClass().getResourceAsStream(ASSET_PROCESSING_PROPERTIES);
        Properties config = new Properties();
        config.load(stream);
        long tokenId = context.getToken().getId();
        long processId = context.getProcessInstance().getId();
        String pureFileName = this.extractFileName(context.getVariable("movieFilePath").toString());
        String extension = config.getProperty("reencode.default");
        String profileName = this.getStringValue(context, "EncodingProfile");
        int dotIndex = profileName.lastIndexOf(".");
        if (dotIndex != -1) {
            profileName = profileName.substring(0, dotIndex);
        }
        String reencodeOutputFileName = pureFileName + "_" + profileName + "_" + Long.toString(processId) + "_" + Long.toString(tokenId) + extension;
        context.setVariable("reencodeOutputFileName", (Object)reencodeOutputFileName);
        String reencodeOutputFilePath = context.getVariable("outputDirectory").toString() + File.separator + reencodeOutputFileName;
        context.setVariable("reencodeOutputFile", (Object)reencodeOutputFilePath);
        context.setVariable("reencodeOutputFileUNC", (Object)PathConverter.getInstance().convertUnixToUNC(reencodeOutputFilePath));
        logger.debug((Object)("reencodeOutputFile=" + reencodeOutputFilePath));
    }

    private String extractFileName(String filePath) {
        File f = new File(filePath);
        String fileName = f.getName();
        int dotIndex = fileName.lastIndexOf(".");
        if (dotIndex != -1) {
            return fileName.substring(0, dotIndex);
        }
        return fileName;
    }

    private String getStringValue(ExecutionContext context, String variableName) {
        Object value = context.getVariable(variableName);
        return value == null ? null : value.toString();
    }
}

