/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.cms.action.content.processing;

import com.tandbergtv.watchpoint.cms.util.ActionException;
import com.tandbergtv.watchpoint.cms.util.PathConverter;
import java.io.File;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class SetTranscodeVariablesAction
implements ActionHandler {
    private static final Logger logger = Logger.getLogger(SetTranscodeVariablesAction.class);
    private static final long serialVersionUID = 6510671693435967893L;
    public static String ASSET_PROCESSING_PROPERTIES = "/cms-template-actions/contentProcessing.properties";

    public void execute(ExecutionContext context) throws Exception {
        InputStream stream = this.getClass().getResourceAsStream(ASSET_PROCESSING_PROPERTIES);
        Properties config = new Properties();
        config.load(stream);
        String pureFileName = this.extractFileName(context.getVariable("movieFilePath").toString());
        context.setVariable("transcodeOutputDirectory", context.getVariable("outputDirectory"));
        context.setVariable("transcodeOutputDirectoryUNC", (Object)PathConverter.getInstance().convertUnixToUNC(context.getVariable("outputDirectory").toString()));
        String transcodedOutputFileName = "";
        String transcodedOutputFile = "";
        String extension = "";
        String transcodeFormat = this.getStringValue(context, "transcodeFormat");
        logger.debug((Object)("transcodeFormat=" + transcodeFormat));
        if (transcodeFormat != null) {
            if (config.getProperty("transcode." + transcodeFormat.toLowerCase()) == null) {
                String errorMessage = "Transcode format " + transcodeFormat + " is not specified in the 'contentProcessing.properties' configuration file";
                context.setVariable("error-message", (Object)errorMessage);
                logger.error((Object)errorMessage);
                throw new ActionException(errorMessage);
            }
            extension = config.getProperty("transcode." + transcodeFormat.toLowerCase());
            String profileName = this.getStringValue(context, "transcodeProfile");
            int dotIndex = profileName.lastIndexOf(".");
            if (dotIndex != -1) {
                profileName = profileName.substring(0, dotIndex);
            }
            long tokenId = context.getToken().getId();
            long processId = context.getProcessInstance().getId();
            transcodedOutputFileName = pureFileName + "_" + profileName + "_" + Long.toString(processId) + "_" + Long.toString(tokenId) + extension;
            context.setVariable("transcodeOutputFileName", (Object)transcodedOutputFileName);
            transcodedOutputFile = context.getVariable("outputDirectory").toString() + File.separator + transcodedOutputFileName;
            context.setVariable("transcodedOutputFile", (Object)transcodedOutputFile);
            String transcodedOutputFileNameUNC = PathConverter.getInstance().convertUnixToUNC(transcodedOutputFile);
            context.setVariable("transcodedOutputFileNameUNC", (Object)transcodedOutputFileNameUNC);
            logger.debug((Object)("transcodedOutputFileName=" + transcodedOutputFileName));
        }
    }

    private String extractFileName(String filePath) {
        File f = new File(filePath);
        String fileName = f.getName();
        int dotIndex = fileName.lastIndexOf(".");
        if (dotIndex != -1) {
            return fileName.substring(0, dotIndex);
        }
        return fileName;
    }

    private String getStringValue(ExecutionContext context, String variableName) {
        Object value = context.getVariable(variableName);
        return value == null ? null : value.toString();
    }
}

