/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.cms.action.schedule.ingest;

import com.tandbergtv.watchpoint.cms.util.TemplateProperties;
import com.tandbergtv.watchpoint.cms.util.schedule.ingest.FileType;
import com.tandbergtv.watchpoint.cms.util.schedule.ingest.PlannerConstants;
import com.tandbergtv.watchpoint.cms.util.schedule.ingest.ProgramListConstants;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SetTitleStatsAction
implements ActionHandler {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(SetTitleStatsAction.class);
    private static String TITLE_STATS = "titleStats";
    private static String CONVERTED_FILE_PATH = "convertedFilepath";
    private static String PMM_DATETIME_FORMAT = "PMM.date.time.format";
    private static String ADI_DATE_FORMAT = "ADI.date.format";
    private static String STATS_DELIMITER = ",";
    private static String FILE_TYPE = "type";

    public void execute(ExecutionContext context) throws Exception {
        String convertedFilepath = (String)context.getVariable(CONVERTED_FILE_PATH);
        FileType type = FileType.getFileType((String)context.getVariable(FILE_TYPE));
        String stats = "";
        if (type == FileType.PLANNER) {
            stats = this.getPlannerTitleStatistics(convertedFilepath);
        } else if (type == FileType.PROGRAM_LIST) {
            stats = this.getPLTitleStatistics(convertedFilepath);
        }
        context.setVariable(TITLE_STATS, (Object)stats);
    }

    private String getPLTitleStatistics(String inputFilepath) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            Document doc = docBuilder.parse(new File(inputFilepath));
            XPath xPath = XPathFactory.newInstance().newXPath();
            NodeList titles = (NodeList)xPath.evaluate(ProgramListConstants.PROGRAMLIST_TITLE_XPATH, doc, XPathConstants.NODESET);
            return titles.getLength() + " TITLE(S)";
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getPlannerTitleStatistics(String inputFilepath) {
        StringBuilder sb = new StringBuilder();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            Document doc = docBuilder.parse(new File(inputFilepath));
            NodeList planners = doc.getElementsByTagName(PlannerConstants.PLANNER_ELEMENT);
            for (int i = 0; i < planners.getLength(); ++i) {
                Element planner = (Element)planners.item(i);
                String date = planner.getElementsByTagName(PlannerConstants.PLANNER_DATE_ELEMENT).item(0).getTextContent();
                int titleCount = 0;
                XPathFactory xpathFactory = XPathFactory.newInstance();
                XPath xpath = xpathFactory.newXPath();
                try {
                    XPathExpression expr = xpath.compile(PlannerConstants.PLANNER_TITLE_XPATH);
                    NodeList result = (NodeList)expr.evaluate(planner, XPathConstants.NODESET);
                    titleCount = result.getLength();
                }
                catch (XPathExpressionException e) {
                    logger.error((Object)("Error while getting title elements from the planner for date: " + date + " : " + e.getMessage()));
                }
                if (sb.length() > 0) {
                    sb.append(STATS_DELIMITER);
                }
                sb.append(this.convert(date) + ":" + titleCount + " TITLE(S)");
            }
        }
        catch (DOMException e) {
            throw new RuntimeException("Error while getting title stats for: " + inputFilepath, e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Error while parsing: " + inputFilepath, e);
        }
        catch (SAXException e) {
        }
        catch (IOException e) {
            throw new RuntimeException("Error while getting title stats for: " + inputFilepath, e);
        }
        return sb.toString();
    }

    private String convert(String date) {
        if (date == null || date.length() == 0) {
            return "";
        }
        try {
            String adiDateFormat = TemplateProperties.getString(ADI_DATE_FORMAT);
            String pmmTimeFormat = TemplateProperties.getString(PMM_DATETIME_FORMAT);
            SimpleDateFormat from = new SimpleDateFormat(pmmTimeFormat);
            SimpleDateFormat to = new SimpleDateFormat(adiDateFormat);
            return to.format(from.parse(date));
        }
        catch (ParseException e) {
            String errorMsg = "Error parsing date: " + date + " : " + e.toString();
            logger.error((Object)errorMsg);
            return "";
        }
    }
}

