/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.cms.action.schedule.ingest.converter;

import com.tandbergtv.watchpoint.cms.action.schedule.ingest.converter.IScheduleConverter;
import com.tandbergtv.watchpoint.cms.util.TemplateProperties;
import com.tandbergtv.watchpoint.cms.util.schedule.ingest.ADIConstants;
import com.tandbergtv.watchpoint.cms.util.schedule.ingest.ConversionPropertyReader;
import com.tandbergtv.watchpoint.cms.util.schedule.ingest.ConversionResult;
import com.tandbergtv.watchpoint.cms.util.schedule.ingest.FileType;
import com.tandbergtv.watchpoint.cms.util.schedule.ingest.PlannerConstants;
import com.tandbergtv.watchpoint.cms.util.schedule.ingest.TVNConstants;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TVNToCMSScheduleConverter
implements IScheduleConverter {
    private static final Logger logger = Logger.getLogger(TVNToCMSScheduleConverter.class);
    private static final String VALID_FILE_EXTN = "xls";
    private static String FILE_NAME_EXTN_SEPARATOR = ".";
    private static String PROVIDER_TIME_FORMAT = "MM/dd/yy";
    private static String PMM_DATETIME_FORMAT = TemplateProperties.getString("PMM.date.time.format");
    private static String ADI_DATE_FORMAT = TemplateProperties.getString("ADI.date.format");
    private static String CREATION_DATE_FORMAT = "MM/dd/yy";
    private static String LICENSING_DATE_FORMAT = "yyyy/MM/dd";
    private String providerID = null;

    @Override
    public ConversionResult convert(String xlsFilepath, String outputPath) {
        ConversionResult result = new ConversionResult();
        try {
            Workbook workbook = Workbook.getWorkbook((File)new File(xlsFilepath));
            Sheet sheet = workbook.getSheet(TVNConstants.METADATA_WORKSHEET_NAME);
            if (sheet == null) {
                result.setErrorMsg("No 'Metadata' work sheet found in input file: " + xlsFilepath);
                return result;
            }
            int rowCount = sheet.getRows();
            int dataRowStart = this.findActiveDataRow(sheet);
            logger.debug((Object)("Active data row: " + dataRowStart + ", outputPath=" + outputPath));
            if (dataRowStart == TVNConstants.INVALID_ROW) {
                String errorMsg = "No row with marker: 'the active line' found in xls";
                result.setErrorMsg(errorMsg);
                return result;
            }
            Document doc = this.createDocument();
            if (doc != null) {
                result.setFileType(FileType.PLANNER);
                result.setSpec(PlannerConstants.CABLELABS_VOD_SPEC);
                for (int rowIndex = dataRowStart; rowIndex < rowCount; ++rowIndex) {
                    try {
                        this.processRow(sheet, rowIndex, doc, result);
                        continue;
                    }
                    catch (RuntimeException e) {
                        result.setErrorMsg("Error while processing row " + (rowIndex + 1) + " - " + e.getMessage());
                        String titleName = this.getContent(sheet, rowIndex, TVNConstants.TITLE_ASSET_NAME);
                        result.setFailedTitle(titleName);
                        return result;
                    }
                }
                this.removeEmptyPlanners(doc);
                this.print(doc, outputPath, this.providerID);
                return result;
            }
        }
        catch (BiffException e) {
            String errorMsg = "Error while converting file: " + xlsFilepath + " : " + e.getMessage();
            result.setErrorMsg(errorMsg);
            return result;
        }
        catch (IOException e) {
            String errorMsg = "Error while converting file: " + xlsFilepath + " : " + e.getMessage();
            result.setErrorMsg(errorMsg);
            return result;
        }
        return result;
    }

    private void processRow(Sheet sheet, int rowIndex, Document doc, ConversionResult result) {
        String actionDate = this.getContent(sheet, rowIndex, TVNConstants.ACTION_DATE);
        if (actionDate == null || actionDate.trim().length() == 0) {
            if (this.rowHasData(sheet, rowIndex)) {
                String errorMsg = "Action date not specified.";
                throw new RuntimeException(errorMsg);
            }
            return;
        }
        String currRowDate = this.getContent(sheet, rowIndex, TVNConstants.ACTION_DATE);
        if (this.providerID == null) {
            this.providerID = this.getContent(sheet, rowIndex, TVNConstants.PROVIDER_ID);
        }
        String spec = PlannerConstants.CABLELABS_VOD_SPEC;
        logger.debug((Object)("currRowDate=" + currRowDate));
        Element titlesElement = this.getTitlesElementForPlanner(doc, this.formatDate(currRowDate, PROVIDER_TIME_FORMAT, PMM_DATETIME_FORMAT), this.providerID, spec);
        Element titleElement = doc.createElement(PlannerConstants.TITLE_ELEMENT);
        titlesElement.appendChild(titleElement);
        Element assetElement = doc.createElement(PlannerConstants.ASSET_ELEMENT);
        titleElement.appendChild(assetElement);
        Element adiElement = doc.createElement(ADIConstants.ADI_ELEMENT);
        assetElement.appendChild(adiElement);
        Element packageMetadata = this.preparePackageMetadata(sheet, rowIndex, doc);
        adiElement.appendChild(packageMetadata);
        Element asset = this.prepareAsset(sheet, rowIndex, doc);
        adiElement.appendChild(asset);
    }

    private Element prepareAsset(Sheet sheet, int rowIndex, Document doc) {
        Element boxCoverAsset;
        Element posterAsset;
        Element previewAsset;
        Element asset = doc.createElement(ADIConstants.ASSET_ELEMENT);
        Element metadataTitleAsset = this.prepareMetadataTitleAsset(sheet, rowIndex, doc);
        asset.appendChild(metadataTitleAsset);
        Element movieAsset = this.prepareMovieAsset(sheet, rowIndex, doc);
        if (movieAsset != null) {
            asset.appendChild(movieAsset);
        }
        if ((previewAsset = this.preparePreviewAsset(sheet, rowIndex, doc)) != null) {
            asset.appendChild(previewAsset);
        }
        if ((posterAsset = this.preparePosterAsset(sheet, rowIndex, doc)) != null) {
            asset.appendChild(posterAsset);
        }
        if ((boxCoverAsset = this.prepareBoxCoverAsset(sheet, rowIndex, doc)) != null) {
            asset.appendChild(boxCoverAsset);
        }
        return asset;
    }

    private Element prepareMetadataTitleAsset(Sheet sheet, int rowIndex, Document doc) {
        Element metadata = doc.createElement(ADIConstants.METADATA_ELEMENT);
        String assetClass = "title";
        String assetId = this.getContent(sheet, rowIndex, TVNConstants.TITLE_ASSET_ID);
        String assetName = this.getContent(sheet, rowIndex, TVNConstants.TITLE_ASSET_NAME);
        logger.debug((Object)("title=" + assetClass + assetId + assetName));
        Element ams = this.createAMSElement(sheet, rowIndex, doc, assetClass, assetId, assetName);
        metadata.appendChild(ams);
        String app = this.getContent(sheet, rowIndex, TVNConstants.PRODUCT);
        Element appData = this.createAppDataElement(doc, app, ADIConstants.TITLE, this.getContent(sheet, rowIndex, TVNConstants.TITLE));
        metadata.appendChild(appData);
        appData = this.createAppDataElement(doc, app, ADIConstants.SUMMARY_SHORT, this.getContent(sheet, rowIndex, TVNConstants.SUMMARY_SHORT));
        metadata.appendChild(appData);
        appData = this.createAppDataElement(doc, app, ADIConstants.SUMMARY_MEDIUM, this.getContent(sheet, rowIndex, TVNConstants.SUMMARY_MEDIUM));
        metadata.appendChild(appData);
        appData = this.createAppDataElement(doc, app, ADIConstants.DISPLAY_RUN_TIME, this.getContent(sheet, rowIndex, TVNConstants.DISPLAY_RUNTIME));
        metadata.appendChild(appData);
        appData = this.createAppDataElement(doc, app, ADIConstants.RUN_TIME, this.getContent(sheet, rowIndex, TVNConstants.MOVIE_RUNTIME));
        metadata.appendChild(appData);
        appData = this.createAppDataElement(doc, app, ADIConstants.RATING, this.getContent(sheet, rowIndex, TVNConstants.RATING));
        metadata.appendChild(appData);
        appData = this.createAppDataElement(doc, app, ADIConstants.BILLING_ID, this.getContent(sheet, rowIndex, TVNConstants.BILLING_ID));
        metadata.appendChild(appData);
        String licStart = this.getContent(sheet, rowIndex, TVNConstants.LISC_START_WINDOW);
        licStart = this.formatDate(licStart, LICENSING_DATE_FORMAT, ADI_DATE_FORMAT);
        appData = this.createAppDataElement(doc, app, ADIConstants.LICENSE_WINDOW_START, licStart);
        metadata.appendChild(appData);
        String licEnd = this.getContent(sheet, rowIndex, TVNConstants.LISC_END_WINDOW);
        licEnd = this.formatDate(licEnd, LICENSING_DATE_FORMAT, ADI_DATE_FORMAT);
        appData = this.createAppDataElement(doc, app, ADIConstants.LICENSE_WINDOW_END, licEnd);
        metadata.appendChild(appData);
        appData = this.createAppDataElement(doc, app, ADIConstants.TITLE_BRIEF, this.getContent(sheet, rowIndex, TVNConstants.TITLE_BRIEF));
        metadata.appendChild(appData);
        appData = this.createAppDataElement(doc, app, ADIConstants.PREVIEW_PERIOD, this.getContent(sheet, rowIndex, TVNConstants.TITLE_PREVIEW_PERIOD));
        metadata.appendChild(appData);
        appData = this.createAppDataElement(doc, app, ADIConstants.PROVIDER_QA_CONTACT, this.getContent(sheet, rowIndex, TVNConstants.PROVIDER_QA_CONTACT));
        metadata.appendChild(appData);
        appData = this.createAppDataElement(doc, app, ADIConstants.CATEGORY, this.getContent(sheet, rowIndex, TVNConstants.CATEGORY));
        metadata.appendChild(appData);
        appData = this.createAppDataElement(doc, app, ADIConstants.GENRE, this.getContent(sheet, rowIndex, TVNConstants.GENRE));
        metadata.appendChild(appData);
        appData = this.createAppDataElement(doc, app, ADIConstants.TITLE_CONTRACT_NAME, this.getContent(sheet, rowIndex, TVNConstants.TITLE_CONTRACT_NAME));
        metadata.appendChild(appData);
        appData = this.createAppDataElement(doc, app, ADIConstants.TITLE_SUGGESTED_PRICE, this.getContent(sheet, rowIndex, TVNConstants.TITLE_SUGGESTED_PRICE));
        metadata.appendChild(appData);
        appData = this.createAppDataElement(doc, app, ADIConstants.TITLE_B0X_OFFICE, this.getContent(sheet, rowIndex, TVNConstants.TITLE_B0X_OFFICE));
        metadata.appendChild(appData);
        appData = this.createAppDataElement(doc, app, ADIConstants.TITLE_STUDIO, this.getContent(sheet, rowIndex, TVNConstants.TITLE_STUDIO));
        metadata.appendChild(appData);
        appData = this.createAppDataElement(doc, app, ADIConstants.TITLE_EPISODE_NAME, this.getContent(sheet, rowIndex, TVNConstants.TITLE_EPISODE_NAME));
        metadata.appendChild(appData);
        appData = this.createAppDataElement(doc, app, "Episode_ID", this.getContent(sheet, rowIndex, "Episode_ID"));
        metadata.appendChild(appData);
        appData = this.createAppDataElement(doc, app, ADIConstants.TITLE_SORT_NAME, this.getContent(sheet, rowIndex, TVNConstants.TITLE_SORT_NAME));
        metadata.appendChild(appData);
        appData = this.createAppDataElement(doc, app, ADIConstants.TITLE_SUMMARY_LONG, this.getContent(sheet, rowIndex, TVNConstants.TITLE_SUMMARY_LONG));
        metadata.appendChild(appData);
        return metadata;
    }

    private Element prepareMovieAsset(Sheet sheet, int rowIndex, Document doc) {
        String movieAssetId = this.getContent(sheet, rowIndex, TVNConstants.MOVIE_ASSET_ID);
        if (movieAssetId == null || movieAssetId.trim().length() <= 0) {
            return null;
        }
        Element movieAssetElement = doc.createElement(ADIConstants.ASSET_ELEMENT);
        Element metadataElement = doc.createElement(ADIConstants.METADATA_ELEMENT);
        movieAssetElement.appendChild(metadataElement);
        String assetClass = "movie";
        String assetName = this.getContent(sheet, rowIndex, TVNConstants.MOVIE_ASSET_NAME);
        Element ams = this.createAMSElement(sheet, rowIndex, doc, assetClass, movieAssetId, assetName);
        metadataElement.appendChild(ams);
        String app = this.getContent(sheet, rowIndex, TVNConstants.PRODUCT);
        Element appData = this.createAppDataElement(doc, app, ADIConstants.HDCONTENT, this.getContent(sheet, rowIndex, TVNConstants.HDCONTENT));
        metadataElement.appendChild(appData);
        appData = this.createAppDataElement(doc, app, ADIConstants.CONTENT_CHECKSUM, this.getContent(sheet, rowIndex, TVNConstants.MOVIE_CONTENT_CHECKSUM));
        metadataElement.appendChild(appData);
        appData = this.createAppDataElement(doc, app, ADIConstants.CONTENT_FILESIZE, this.getContent(sheet, rowIndex, TVNConstants.MOVIE_FILE_SIZE));
        metadataElement.appendChild(appData);
        appData = this.createAppDataElement(doc, app, ADIConstants.AUDIO_TYPE, this.getContent(sheet, rowIndex, TVNConstants.AUDIO_TYPE));
        metadataElement.appendChild(appData);
        Element contentElement = this.prepareContent(doc, this.getContent(sheet, rowIndex, TVNConstants.MOVIE_CONTENT_FILE_NAME));
        movieAssetElement.appendChild(contentElement);
        return movieAssetElement;
    }

    private Element preparePreviewAsset(Sheet sheet, int rowIndex, Document doc) {
        String previewAssetId = this.getContent(sheet, rowIndex, TVNConstants.PREVIEW_ASSET_ID);
        if (previewAssetId == null || previewAssetId.trim().length() <= 0) {
            return null;
        }
        Element previewAssetElement = doc.createElement(ADIConstants.ASSET_ELEMENT);
        Element metadataElement = doc.createElement(ADIConstants.METADATA_ELEMENT);
        previewAssetElement.appendChild(metadataElement);
        String assetClass = "preview";
        String assetName = this.getContent(sheet, rowIndex, TVNConstants.PREVIEW_ASSET_NAME);
        Element ams = this.createAMSElement(sheet, rowIndex, doc, assetClass, previewAssetId, assetName);
        metadataElement.appendChild(ams);
        String app = this.getContent(sheet, rowIndex, TVNConstants.PRODUCT);
        Element appData = this.createAppDataElement(doc, app, ADIConstants.CONTENT_CHECKSUM, this.getContent(sheet, rowIndex, TVNConstants.PREVIEW_CONTENT_CHECKSUM));
        metadataElement.appendChild(appData);
        appData = this.createAppDataElement(doc, app, ADIConstants.CONTENT_FILESIZE, this.getContent(sheet, rowIndex, TVNConstants.PREVIEW_FILE_SIZE));
        metadataElement.appendChild(appData);
        appData = this.createAppDataElement(doc, app, ADIConstants.AUDIO_TYPE, this.getContent(sheet, rowIndex, TVNConstants.AUDIO_TYPE));
        metadataElement.appendChild(appData);
        appData = this.createAppDataElement(doc, app, ADIConstants.RATING, this.getContent(sheet, rowIndex, TVNConstants.RATING));
        metadataElement.appendChild(appData);
        appData = this.createAppDataElement(doc, app, ADIConstants.RUN_TIME, this.getContent(sheet, rowIndex, TVNConstants.PREVIEW_RUNTIME));
        metadataElement.appendChild(appData);
        Element contentElement = this.prepareContent(doc, this.getContent(sheet, rowIndex, TVNConstants.PREVIEW_FILE_NAME));
        previewAssetElement.appendChild(contentElement);
        return previewAssetElement;
    }

    private Element preparePosterAsset(Sheet sheet, int rowIndex, Document doc) {
        String posterAssetId = this.getContent(sheet, rowIndex, TVNConstants.POSTER_ASSET_ID);
        if (posterAssetId == null || posterAssetId.trim().length() <= 0) {
            return null;
        }
        Element posterAssetElement = doc.createElement(ADIConstants.ASSET_ELEMENT);
        Element metadataElement = doc.createElement(ADIConstants.METADATA_ELEMENT);
        posterAssetElement.appendChild(metadataElement);
        String assetClass = "poster";
        String assetName = this.getContent(sheet, rowIndex, TVNConstants.POSTER_ASSET_NAME);
        Element ams = this.createAMSElement(sheet, rowIndex, doc, assetClass, posterAssetId, assetName);
        metadataElement.appendChild(ams);
        String app = this.getContent(sheet, rowIndex, TVNConstants.PRODUCT);
        Element appData = this.createAppDataElement(doc, app, ADIConstants.CONTENT_CHECKSUM, this.getContent(sheet, rowIndex, TVNConstants.POSTER_CHECKSUM));
        metadataElement.appendChild(appData);
        appData = this.createAppDataElement(doc, app, ADIConstants.CONTENT_FILESIZE, this.getContent(sheet, rowIndex, TVNConstants.POSTER_FILE_SIZE));
        metadataElement.appendChild(appData);
        Element contentElement = this.prepareContent(doc, this.getContent(sheet, rowIndex, TVNConstants.POSTER_FILENAME));
        posterAssetElement.appendChild(contentElement);
        return posterAssetElement;
    }

    private Element prepareBoxCoverAsset(Sheet sheet, int rowIndex, Document doc) {
        String boxCoverAssetId = this.getContent(sheet, rowIndex, TVNConstants.BOX_COVER_ASSET_ID);
        if (boxCoverAssetId == null || boxCoverAssetId.trim().length() <= 0) {
            return null;
        }
        Element boxcoverAssetElement = doc.createElement(ADIConstants.ASSET_ELEMENT);
        Element metadataElement = doc.createElement(ADIConstants.METADATA_ELEMENT);
        boxcoverAssetElement.appendChild(metadataElement);
        String assetClass = "boxcover";
        String assetName = this.getContent(sheet, rowIndex, TVNConstants.BOX_COVER_ASSET_NAME);
        Element ams = this.createAMSElement(sheet, rowIndex, doc, assetClass, boxCoverAssetId, assetName);
        metadataElement.appendChild(ams);
        String app = this.getContent(sheet, rowIndex, TVNConstants.PRODUCT);
        Element appData = this.createAppDataElement(doc, app, ADIConstants.CONTENT_CHECKSUM, this.getContent(sheet, rowIndex, TVNConstants.BOX_COVER_CONTENT_CHECKSUM));
        metadataElement.appendChild(appData);
        appData = this.createAppDataElement(doc, app, ADIConstants.CONTENT_FILESIZE, this.getContent(sheet, rowIndex, TVNConstants.BOX_COVER_FILE_SIZE));
        metadataElement.appendChild(appData);
        Element contentElement = this.prepareContent(doc, this.getContent(sheet, rowIndex, TVNConstants.BOX_COVER_FILE_NAME));
        boxcoverAssetElement.appendChild(contentElement);
        return boxcoverAssetElement;
    }

    private boolean rowHasData(Sheet sheet, int rowIndex) {
        Cell[] cells;
        for (Cell c : cells = sheet.getRow(rowIndex)) {
            if (c.getContents() == null || c.getContents().trim().length() <= 0) continue;
            return true;
        }
        return false;
    }

    private void removeEmptyPlanners(Document doc) {
        Element planners = (Element)doc.getElementsByTagName(PlannerConstants.PLANNERS_ELEMENT).item(0);
        NodeList plannerList = doc.getElementsByTagName(PlannerConstants.PLANNER_ELEMENT);
        ArrayList<Element> plannersToDelete = new ArrayList<Element>();
        for (int i = 0; i < plannerList.getLength(); ++i) {
            Element planner = (Element)plannerList.item(i);
            if (planner.getElementsByTagName(PlannerConstants.PLANNER_TITLE_ELEMENT).getLength() != 0) continue;
            plannersToDelete.add(planner);
        }
        for (Element planner : plannersToDelete) {
            planners.removeChild(planner);
        }
    }

    private Element getTitlesElementForPlanner(Document doc, String currRowDate, String providerID, String spec) {
        NodeList plannerList = doc.getElementsByTagName(PlannerConstants.PLANNER_ELEMENT);
        for (int i = 0; i < plannerList.getLength(); ++i) {
            Element currPlanner = (Element)plannerList.item(i);
            NodeList dateElements = currPlanner.getElementsByTagName(PlannerConstants.PLANNER_DATE_ELEMENT);
            if (!dateElements.item(0).getTextContent().equals(currRowDate)) continue;
            Element titlesElement = (Element)currPlanner.getElementsByTagName(PlannerConstants.TITLES_ELEMENT).item(0);
            return titlesElement;
        }
        Element plannerElement = this.createPlannerElement(doc);
        NodeList dateElements = plannerElement.getElementsByTagName(PlannerConstants.PLANNER_DATE_ELEMENT);
        dateElements.item(0).setTextContent(currRowDate);
        NodeList providerIDElements = plannerElement.getElementsByTagName(PlannerConstants.PROVIDERID_ELEMENT);
        providerIDElements.item(0).setTextContent(providerID);
        NodeList titlesElements = plannerElement.getElementsByTagName(PlannerConstants.TITLES_ELEMENT);
        NodeList specElements = ((Element)titlesElements.item(0)).getElementsByTagName(PlannerConstants.PLANNER_SPEC_ELEMENT);
        specElements.item(0).setTextContent(spec);
        doc.getElementsByTagName(PlannerConstants.PLANNERS_ELEMENT).item(0).appendChild(plannerElement);
        return (Element)titlesElements.item(0);
    }

    private String formatDate(String dateToFormat, String fromFormat, String toFormat) {
        if (dateToFormat.trim().length() > 0) {
            try {
                SimpleDateFormat from = new SimpleDateFormat(fromFormat);
                SimpleDateFormat to = new SimpleDateFormat(toFormat);
                return to.format(from.parse(dateToFormat));
            }
            catch (ParseException e) {
                String errorMsg = "Error parsing date: " + dateToFormat;
                throw new RuntimeException(errorMsg, e);
            }
        }
        return dateToFormat;
    }

    private String getContent(Sheet sheet, int row, String searchContent) {
        Cell contentCell;
        int col = TVNConstants.INVALID_COLUMN;
        try {
            contentCell = sheet.findCell(searchContent);
            col = contentCell.getColumn();
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Could not find column '" + searchContent + "'");
        }
        if (contentCell.getRow() == TVNConstants.TVN_HEADER_ROW_INDEX) {
            try {
                return sheet.getCell(col, row).getContents();
            }
            catch (RuntimeException e) {
                String errorMsg = "Could not get content for column '" + searchContent + "' in row " + row;
                throw new RuntimeException(errorMsg);
            }
        }
        throw new RuntimeException("Could not find column '" + searchContent + "'");
    }

    private Element preparePackageMetadata(Sheet sheet, int rowIndex, Document doc) {
        Element metadata = doc.createElement(ADIConstants.METADATA_ELEMENT);
        String assetClass = "package";
        String assetId = this.getContent(sheet, rowIndex, TVNConstants.PACKAGE_ASSET_ID);
        String assetName = this.getContent(sheet, rowIndex, TVNConstants.PACKAGE_ASSET_NAME);
        logger.debug((Object)("package=" + assetClass + assetId + assetName));
        Element ams = this.createAMSElement(sheet, rowIndex, doc, assetClass, assetId, assetName);
        metadata.appendChild(ams);
        String app = this.getContent(sheet, rowIndex, TVNConstants.PRODUCT);
        String name = ADIConstants.SPECIFICATION_VERSION;
        String value = PlannerConstants.CABLELABS_VOD;
        Element appData = this.createAppDataElement(doc, app, name, value);
        metadata.appendChild(appData);
        return metadata;
    }

    private int findActiveDataRow(Sheet sheet) {
        int rowCount = sheet.getRows();
        for (int i = 0; i < rowCount; ++i) {
            Cell c = sheet.getCell(TVNConstants.ACTIVE_LINE_COLUMN, i);
            if (!c.getContents().equalsIgnoreCase(TVNConstants.ACTIVE_LINE)) continue;
            return i;
        }
        return TVNConstants.INVALID_ROW;
    }

    private Document createDocument() {
        try {
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
            Document doc = domBuilder.newDocument();
            Element plannersElement = doc.createElement(PlannerConstants.PLANNERS_ELEMENT);
            doc.appendChild(plannersElement);
            return doc;
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)("Error" + e.toString()));
            return null;
        }
    }

    private Element createPlannerElement(Document doc) {
        Element plannerElement = doc.createElement(PlannerConstants.PLANNER_ELEMENT);
        Element partnerElement = doc.createElement(PlannerConstants.PROVIDERID_ELEMENT);
        plannerElement.appendChild(partnerElement);
        Element dateElement = doc.createElement(PlannerConstants.PLANNER_DATE_ELEMENT);
        plannerElement.appendChild(dateElement);
        Element titlesElement = doc.createElement(PlannerConstants.TITLES_ELEMENT);
        plannerElement.appendChild(titlesElement);
        Element specElement = doc.createElement(PlannerConstants.PLANNER_SPEC_ELEMENT);
        titlesElement.appendChild(specElement);
        return plannerElement;
    }

    private void print(Document doc, String outputFile, String providerId) {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            String encodingKey = ConversionPropertyReader.getEncodingKey(providerId);
            String encoding = ConversionPropertyReader.hasProperty(encodingKey) ? ConversionPropertyReader.getProperty(encodingKey) : ConversionPropertyReader.getProperty(ConversionPropertyReader.DEFAULT_ENCODING);
            transformer.setOutputProperty("encoding", encoding);
            DOMSource source = new DOMSource(doc);
            FileOutputStream fs = new FileOutputStream(outputFile);
            StreamResult result = new StreamResult(fs);
            transformer.transform(source, result);
            fs.close();
        }
        catch (TransformerConfigurationException e) {
            logger.error((Object)"Error while printing output doc: ", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            logger.error((Object)"Error while printing output doc: ", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            logger.error((Object)"Error while printing output doc: ", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"Error while printing output doc: ", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            logger.error((Object)"Error while printing output doc: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean canConvert(String inputFilename) {
        int index = inputFilename.lastIndexOf(FILE_NAME_EXTN_SEPARATOR);
        String xtn = inputFilename.substring(index + 1);
        return xtn.equals(VALID_FILE_EXTN);
    }

    private Element createAMSElement(Sheet sheet, int rowIndex, Document doc, String assetClass, String assetId, String assetName) {
        Element ams = doc.createElement(ADIConstants.AMS_ELEMENT);
        ams.setAttribute(ADIConstants.AMS_ASSET_CLASS_ATTR, assetClass);
        ams.setAttribute(ADIConstants.AMS_ASSET_ID_ATTR, assetId);
        ams.setAttribute(ADIConstants.AMS_ASSET_NAME_ATTR, assetName);
        String creationDate = this.getContent(sheet, rowIndex, TVNConstants.CREATION_DATE);
        creationDate = this.formatDate(creationDate, CREATION_DATE_FORMAT, ADI_DATE_FORMAT);
        ams.setAttribute(ADIConstants.CREATION_DATE_ATTR, creationDate);
        String description = this.getContent(sheet, rowIndex, TVNConstants.DESCRIPTION);
        ams.setAttribute(ADIConstants.AMS_ASSET_DESCRIPTION_ATTR, description);
        String product = this.getContent(sheet, rowIndex, TVNConstants.PRODUCT);
        ams.setAttribute(ADIConstants.AMS_PRODUCT_ATTR, product);
        String provider = this.getContent(sheet, rowIndex, TVNConstants.PROVIDER);
        ams.setAttribute(ADIConstants.AMS_PROVIDER_ATTR, provider);
        String providerId = this.getContent(sheet, rowIndex, TVNConstants.PROVIDER_ID);
        ams.setAttribute(ADIConstants.AMS_PROVIDERID_ATTR, providerId);
        String majorVersion = this.getContent(sheet, rowIndex, TVNConstants.VERSION_MAJOR);
        ams.setAttribute(ADIConstants.AMS_VERSION_MAJOR_ATTR, majorVersion);
        String minorVersion = this.getContent(sheet, rowIndex, TVNConstants.VERSION_MINOR);
        ams.setAttribute(ADIConstants.AMS_VERSION_MINOR_ATTR, minorVersion);
        ams.setAttribute(ADIConstants.AMS_VERB_ATTR, "");
        return ams;
    }

    private Element createAppDataElement(Document doc, String app, String name, String value) {
        Element appData = doc.createElement(ADIConstants.APP_DATA_ELEMENT);
        appData.setAttribute(ADIConstants.APPDATA_APP_ATTR, app);
        appData.setAttribute(ADIConstants.APPDATA_NAME_ATTR, name);
        appData.setAttribute(ADIConstants.APPDATA_VALUE_ATTR, value);
        return appData;
    }

    private Element prepareContent(Document doc, String value) {
        Element content = doc.createElement(ADIConstants.CONTENT_ELEMENT);
        content.setAttribute(ADIConstants.CONTENT_VALUE_ATTR, value);
        return content;
    }
}

