/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.cms.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public final class PathConverter {
    private static final String UNC_PATH_SEPARATOR_PATTERN = "\\\\";
    private static final String UNIX_PATH_SEPARATOR_PATTERN = "/";
    private static PathConverter INSTANCE = null;
    private Map<String, String> uncPathMap = new HashMap<String, String>();
    private Map<String, String> mountMap = new HashMap<String, String>();
    private static final String RESOURCE_PATH = "/cms-template-actions/pathConversion.properties";

    private PathConverter() {
        this.loadPathConfiguration();
    }

    private synchronized void loadPathConfiguration() {
        this.mountMap.clear();
        this.uncPathMap.clear();
        try {
            InputStream stream = this.getClass().getResourceAsStream(RESOURCE_PATH);
            Properties config = new Properties();
            config.load(stream);
            for (Object keyObject : config.keySet()) {
                String mountPath = ((String)keyObject).trim();
                String uncPath = config.getProperty(mountPath).trim();
                this.mountMap.put(mountPath, uncPath);
                this.uncPathMap.put(uncPath, mountPath);
            }
        }
        catch (IOException e) {
            String msg = "Failed to load the Path configuration file: /cms-template-actions/pathConversion.properties";
            throw new RuntimeException(msg, e);
        }
    }

    public static synchronized PathConverter getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PathConverter();
        }
        return INSTANCE;
    }

    public String convertUNCToUnix(String uncPath) {
        if (uncPath == null) {
            return null;
        }
        String unixPath = this.replacePath(uncPath, true);
        return unixPath.replaceAll(UNC_PATH_SEPARATOR_PATTERN, UNIX_PATH_SEPARATOR_PATTERN);
    }

    public String convertUnixToUNC(String unixPath) {
        if (unixPath == null) {
            return null;
        }
        String uncPath = this.replacePath(unixPath, false);
        return uncPath.replaceAll(UNIX_PATH_SEPARATOR_PATTERN, UNC_PATH_SEPARATOR_PATTERN);
    }

    private String replacePath(String path, boolean isUNCPath) {
        String convertedPath = path.trim();
        Map<String, String> pathMap = isUNCPath ? this.uncPathMap : this.mountMap;
        for (String mappedPath : pathMap.keySet()) {
            if (!convertedPath.startsWith(mappedPath)) continue;
            convertedPath = pathMap.get(mappedPath) + convertedPath.substring(mappedPath.length());
            break;
        }
        return convertedPath;
    }
}

