/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.cms.util;

import java.io.File;
import java.util.ResourceBundle;

public final class PathProperties {
    private static final String BUNDLE_NAME = "cms-template-actions.path";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("cms-template-actions.path");
    public static final String CONTENT_PATH = "contentPath";
    public static final String UNMAPPED_CONTENT_PATH = "unmappedContentPath";
    public static final String TEMP_CONTENT_PATH = "tempContentPath";
    public static final String ORIGINAL_CONTENT_PATH = "provider.original";
    public static final String ORIGINAL_ASSET_PATH = "provider.original.asset";
    public static final String ORIGINAL_PLANNER_PATH = "provider.original.planner";
    public static final String ORIGINAL_PITCH_SCHEDULE_PATH = "provider.original.pitchSchedule";
    public static final String ORIGINAL_PROGRAM_LIST_PATH = "provider.original.programList";
    public static final String INGEST_CONTENT_PATH = "provider.ingest";
    public static final String INGEST_ASSET_PATH = "provider.ingest.asset";
    public static final String INGEST_PLANNER_PATH = "provider.ingest.planner";
    public static final String INGEST_PITCH_SCHEDULE_PATH = "provider.ingest.pitchSchedule";
    public static final String INGEST_PROGRAM_LIST_PATH = "provider.original.programList";
    public static final String PROCESSED_CONTENT_PATH = "provider.processed";
    public static final String PROCESSED_TITLES_PATH = "provider.processed.title";
    public static final String PROCESSED_PLANNER_PATH = "provider.processed.planner";
    public static final String PROCESSED_PROGRAM_LIST_PATH = "provider.processed.programList";
    public static final String PROCESSED_PITCH_SCHEDULE_PATH = "provider.processed.pitchSchedule";
    public static final String PROCESSED_TITLE_PACKAGE = "title.processed.package";
    public static final String PROCESSED_TITLE_ASSET = "title.processed.asset";

    private PathProperties() {
    }

    public static String getProperty(String propertyName) {
        return RESOURCE_BUNDLE.getString(propertyName);
    }

    public static String getProviderPath(String providerId) {
        return PathProperties.getProviderFolder(providerId).getAbsolutePath();
    }

    public static String getProviderPath(String providerId, String key) {
        File providerFolder = PathProperties.getProviderFolder(providerId);
        String relativePath = PathProperties.getProperty(key);
        return new File(providerFolder, relativePath).getAbsolutePath();
    }

    public static String getTitlePath(String providerId, String titleId) {
        return PathProperties.getTitleFolder(providerId, titleId).getAbsolutePath();
    }

    public static String getTitlePath(String providerId, String titleId, String key) {
        File titleFolder = PathProperties.getTitleFolder(providerId, titleId);
        String relativePath = PathProperties.getProperty(key);
        return new File(titleFolder, relativePath).getAbsolutePath();
    }

    public static final File getUnmappedProviderFolder(String providerId) {
        String unmappedContentPath = PathProperties.getProperty(UNMAPPED_CONTENT_PATH);
        return new File(unmappedContentPath, providerId);
    }

    private static File getProviderFolder(String providerId) {
        String contentPath = PathProperties.getProperty(CONTENT_PATH);
        return new File(contentPath, providerId);
    }

    private static File getTitleFolder(String providerId, String titleId) {
        String titlesPath = PathProperties.getProviderPath(providerId, PROCESSED_TITLES_PATH);
        return new File(titlesPath, titleId);
    }
}

