/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.cms.util.schedule.ingest;

import com.tandbergtv.watchpoint.cms.util.DateUtility;
import com.tandbergtv.watchpoint.cms.util.PathProperties;
import com.tandbergtv.watchpoint.cms.util.schedule.ingest.FileType;
import java.io.File;
import java.util.Date;

public class ConversionHelper {
    private static String FILE_NAME_EXTN_SEPARATOR = ".";
    private static String OUTPUT_FILE_SUFFIX = ".xml";
    private static final String FOLDER_DATE_FORMAT = "folder.date.format";

    public static String getOutputPath(String providerId, FileType type) {
        String contentPath = PathProperties.getProperty("contentPath");
        String archivePath = "";
        if (type == FileType.PLANNER) {
            archivePath = PathProperties.getProperty("provider.processed.planner");
        } else if (type == FileType.PROGRAM_LIST) {
            archivePath = PathProperties.getProperty("provider.processed.programList");
        }
        String date = DateUtility.formatDate(new Date(), FOLDER_DATE_FORMAT);
        String outputPath = contentPath + File.separator + providerId + File.separator + date + File.separator + archivePath;
        File outputPathDir = new File(outputPath);
        if (!outputPathDir.exists()) {
            outputPathDir.mkdir();
        }
        return outputPath;
    }

    public static String getFilename(String name) {
        File file = new File(name);
        String filename = file.getName();
        int index = filename.lastIndexOf(FILE_NAME_EXTN_SEPARATOR);
        if (index != -1) {
            return filename.substring(0, index);
        }
        return name;
    }

    public static String generateFileName(String folder, String filename) {
        return folder + File.separator + filename + OUTPUT_FILE_SUFFIX;
    }
}

