/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.scheduler.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.calendar.BusinessCalendar;
import org.jbpm.calendar.Duration;
import org.jbpm.db.SchedulerSession;
import org.jbpm.scheduler.exe.Timer;
import org.jbpm.scheduler.impl.SchedulerListener;

public class SchedulerThread
extends Thread {
    static BusinessCalendar businessCalendar = new BusinessCalendar();
    JbpmConfiguration jbpmConfiguration = null;
    String jbpmContextName = null;
    List listeners = new ArrayList();
    boolean keepRunning = true;
    long interval = 5000L;
    private static final Log log = LogFactory.getLog((Class)SchedulerThread.class);

    public SchedulerThread() {
        this(JbpmConfiguration.getInstance(), "default.jbpm.context");
    }

    public SchedulerThread(JbpmConfiguration jbpmConfiguration) {
        this(jbpmConfiguration, "default.jbpm.context");
    }

    public SchedulerThread(String jbpmContextName) {
        this(JbpmConfiguration.getInstance(), jbpmContextName);
    }

    public SchedulerThread(JbpmConfiguration jbpmConfiguration, String jbpmContextName) {
        super("JbpmScheduler");
        this.jbpmConfiguration = jbpmConfiguration;
        this.jbpmContextName = jbpmContextName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.keepRunning) {
            long millisToWait = this.interval;
            try {
                millisToWait = this.executeTimers();
                if (millisToWait < 0L) {
                    millisToWait = this.interval;
                }
                millisToWait = Math.min(millisToWait, this.interval);
            }
            catch (RuntimeException e) {
                log.info((Object)"runtime exception while executing timers", (Throwable)e);
            }
            finally {
                try {
                    Thread.sleep(millisToWait);
                }
                catch (InterruptedException e) {
                    log.info((Object)"waiting for timers got interuppted");
                }
            }
        }
        log.info((Object)"ending scheduler thread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long executeTimers() {
        long millisTillNextTimerIsDue = -1L;
        boolean isDueDateInPast = true;
        JbpmContext jbpmContext = this.jbpmConfiguration.createJbpmContext(this.jbpmContextName);
        try {
            SchedulerSession schedulerSession = jbpmContext.getSchedulerSession();
            log.debug((Object)"checking for timers");
            Iterator iter = schedulerSession.findTimersByDueDate();
            while (iter.hasNext() && isDueDateInPast) {
                Timer timer = (Timer)iter.next();
                log.debug((Object)("found timer " + timer));
                if (timer.isDue()) {
                    log.debug((Object)("executing timer '" + timer + "'"));
                    timer.execute();
                    jbpmContext.save(timer.getProcessInstance());
                    this.notifyListeners(timer);
                    if (timer.getException() != null) {
                        schedulerSession.saveTimer(timer);
                        continue;
                    }
                    if (timer.getRepeat() != null) {
                        Date dueDate = timer.getDueDate();
                        while (dueDate.getTime() <= System.currentTimeMillis()) {
                            dueDate = businessCalendar.add(dueDate, new Duration(timer.getRepeat()));
                        }
                        timer.setDueDate(dueDate);
                        log.debug((Object)("saving updated timer for repetition '" + timer + "' in '" + (dueDate.getTime() - System.currentTimeMillis()) + "' millis"));
                        schedulerSession.saveTimer(timer);
                        continue;
                    }
                    log.debug((Object)("deleting timer '" + timer + "'"));
                    schedulerSession.deleteTimer(timer);
                    continue;
                }
                isDueDateInPast = false;
                millisTillNextTimerIsDue = timer.getDueDate().getTime() - System.currentTimeMillis();
            }
        }
        finally {
            jbpmContext.close();
        }
        return millisTillNextTimerIsDue;
    }

    public void addListener(SchedulerListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    public void removeListener(SchedulerListener listener) {
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    void notifyListeners(Timer timer) {
        if (this.listeners != null) {
            Date now = new Date();
            Iterator iter = new ArrayList(this.listeners).iterator();
            while (iter.hasNext()) {
                SchedulerListener timerRunnerListener = (SchedulerListener)iter.next();
                timerRunnerListener.timerExecuted(now, timer);
            }
        }
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }
}

