/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.jndi.ns;

import org.objectweb.carol.cmi.ClusterRegistryImpl;
import org.objectweb.carol.cmi.ClusterRegistryKiller;
import org.objectweb.carol.cmi.DistributedEquiv;
import org.objectweb.carol.jndi.ns.AbsRegistry;
import org.objectweb.carol.jndi.ns.NameService;
import org.objectweb.carol.jndi.ns.NameServiceException;
import org.objectweb.carol.util.configuration.TraceCarol;

public class CmiRegistry
extends AbsRegistry
implements NameService {
    private DistributedEquiv de = null;
    private ClusterRegistryKiller cregk = null;

    public CmiRegistry() {
        super(12341);
    }

    public void start() throws NameServiceException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("CmiRegistry.start() on port:" + this.getPort());
        }
        try {
            if (!this.isStarted()) {
                if (this.getPort() >= 0) {
                    this.de = DistributedEquiv.start();
                    this.cregk = ClusterRegistryImpl.start((int)this.getPort());
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        public void run() {
                            try {
                                CmiRegistry.this.stop();
                            }
                            catch (Exception e) {
                                TraceCarol.error("CmiRegistry ShutdownHook problem", e);
                            }
                        }
                    });
                } else if (TraceCarol.isDebugJndiCarol()) {
                    TraceCarol.debugJndiCarol("Can't start CmiRegistry, port=" + this.getPort() + " is < 0");
                }
            } else if (TraceCarol.isDebugJndiCarol()) {
                TraceCarol.debugJndiCarol("CmiRegistry is already start on port:" + this.getPort());
            }
        }
        catch (Exception e) {
            String msg = "can not start cluster registry: " + e;
            TraceCarol.error(msg);
            throw new NameServiceException(msg);
        }
    }

    public void stop() throws NameServiceException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("CmiRegistry.stop()");
        }
        try {
            if (this.cregk != null) {
                this.cregk.stop();
                this.de.stop();
                this.cregk = null;
            }
        }
        catch (Exception e) {
            throw new NameServiceException("can not stop cluster registry: " + e);
        }
    }

    public boolean isStarted() {
        return this.cregk != null;
    }
}

