/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.jndi.spi;

import java.rmi.Remote;
import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.objectweb.carol.jndi.wrapping.JNDIRemoteResource;
import org.objectweb.carol.rmi.exception.NamingExceptionHelper;
import org.objectweb.carol.util.configuration.ConfigurationRepository;

public abstract class AbsContext
implements Context {
    private Context wrappedContext = null;
    private Hashtable exportedObjects = new Hashtable();

    protected AbsContext(Context ctx) {
        this.wrappedContext = ctx;
    }

    protected abstract Object unwrapObject(Object var1, Name var2) throws NamingException;

    protected abstract Object wrapObject(Object var1, Name var2, boolean var3) throws NamingException;

    protected Object defaultUnwrapObject(Object o, Name name) throws NamingException {
        try {
            if (o instanceof JNDIRemoteResource) {
                return ((JNDIRemoteResource)o).getResource();
            }
            return o;
        }
        catch (Exception e) {
            throw NamingExceptionHelper.create("Cannot unwrap object '" + o + "' with name '" + name + "' :" + e.getMessage(), e);
        }
    }

    protected int getObjectPort() {
        return 0;
    }

    public Object lookup(Name name) throws NamingException {
        if (name.isEmpty()) {
            return this;
        }
        return this.unwrapObject(this.wrappedContext.lookup(this.encode(name)), name);
    }

    public Object lookup(String name) throws NamingException {
        return this.lookup(new CompositeName(name));
    }

    public void bind(Name name, Object obj) throws NamingException {
        if (name.isEmpty()) {
            throw new NamingException("Cannot bind empty name");
        }
        this.wrappedContext.bind(this.encode(name), this.wrapObject(obj, name, false));
    }

    public void bind(String name, Object obj) throws NamingException {
        this.bind(new CompositeName(name), obj);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        if (name.isEmpty()) {
            throw new NamingException("Cannot rebind empty name");
        }
        this.wrappedContext.rebind(this.encode(name), this.wrapObject(obj, name, true));
    }

    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(new CompositeName(name), obj);
    }

    public void unbind(Name name) throws NamingException {
        if (name.isEmpty()) {
            throw new NamingException("Cannot unbind empty name");
        }
        try {
            this.wrappedContext.unbind(this.encode(name));
            if (this.exportedObjects.containsKey(name)) {
                ConfigurationRepository.getCurrentConfiguration().getProtocol().getPortableRemoteObject().unexportObject((Remote)this.exportedObjects.remove(name));
            }
        }
        catch (Exception e) {
            throw NamingExceptionHelper.create("Cannot unbind name '" + name + "' : " + e.getMessage(), e);
        }
    }

    public void unbind(String name) throws NamingException {
        this.unbind(new CompositeName(name));
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        if (this.exportedObjects.containsKey(oldName)) {
            this.exportedObjects.put(newName, this.exportedObjects.remove(oldName));
        }
        this.wrappedContext.rename(this.encode(oldName), this.encode(newName));
    }

    public void rename(String oldName, String newName) throws NamingException {
        this.rename(new CompositeName(oldName), new CompositeName(newName));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return new WrappedEnumeration(this.wrappedContext.list(this.encode(name)));
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(new CompositeName(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return new WrappedEnumeration(this.wrappedContext.listBindings(this.encode(name)));
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(new CompositeName(name));
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.wrappedContext.destroySubcontext(this.encode(name));
    }

    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(new CompositeName(name));
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.wrappedContext.createSubcontext(this.encode(name));
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(new CompositeName(name));
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.wrappedContext.lookupLink(this.encode(name));
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookupLink(new CompositeName(name));
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.wrappedContext.getNameParser(this.encode(name));
    }

    public NameParser getNameParser(String name) throws NamingException {
        return this.getNameParser(new CompositeName(name));
    }

    public String composeName(String name, String prefix) throws NamingException {
        return name;
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        return (Name)name.clone();
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.wrappedContext.addToEnvironment(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.wrappedContext.removeFromEnvironment(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.wrappedContext.getEnvironment();
    }

    public void close() throws NamingException {
    }

    public String getNameInNamespace() throws NamingException {
        return this.wrappedContext.getNameInNamespace();
    }

    protected Object addToExported(Name name, Object o) {
        return this.exportedObjects.put(name, o);
    }

    protected Context getWrappedContext() {
        return this.wrappedContext;
    }

    protected Name encode(Name initialName) {
        String name = initialName.toString();
        if (name.length() < 1) {
            return initialName;
        }
        StringBuffer newname = new StringBuffer(name);
        for (int i = 0; i < newname.length(); ++i) {
            char c = newname.charAt(i);
            if (c != '/' && c != '\\') continue;
            newname.insert(i, '\\');
            ++i;
        }
        if (newname.charAt(0) == '\"' || newname.charAt(0) == '\'') {
            newname.insert(0, '\\');
        }
        try {
            return new CompositeName(newname.toString());
        }
        catch (InvalidNameException e) {
            return initialName;
        }
    }

    protected String decode(String name) {
        StringBuffer newname = new StringBuffer(name);
        if (newname.length() >= 2 && (newname.charAt(0) == '\"' || newname.charAt(0) == '\'') && newname.charAt(0) == newname.charAt(newname.length() - 1)) {
            newname.deleteCharAt(0);
            newname.deleteCharAt(newname.length() - 1);
        }
        if (name.indexOf(92) < 0) {
            return newname.toString();
        }
        int i = 0;
        while (i < newname.length()) {
            if (newname.charAt(i) == '\\') {
                newname.deleteCharAt(i);
                ++i;
                continue;
            }
            ++i;
        }
        return newname.toString();
    }

    protected class WrappedEnumeration
    implements NamingEnumeration {
        private NamingEnumeration wrappedEnumeration;

        WrappedEnumeration(NamingEnumeration wrappedEnumeration) {
            this.wrappedEnumeration = wrappedEnumeration;
        }

        public boolean hasMoreElements() {
            return this.wrappedEnumeration.hasMoreElements();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object nextElement() {
            NameClassPair ncp = (NameClassPair)this.wrappedEnumeration.nextElement();
            ncp.setName(AbsContext.this.decode(ncp.getName()));
            return ncp;
        }

        public Object next() {
            return this.nextElement();
        }

        public void close() throws NamingException {
            this.wrappedEnumeration = null;
        }
    }
}

