/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.boot;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.ObjectFactory;
import org.java.plugin.Plugin;
import org.java.plugin.PluginManager;
import org.java.plugin.boot.Application;
import org.java.plugin.boot.ApplicationInitializer;
import org.java.plugin.boot.ApplicationPlugin;
import org.java.plugin.boot.BootErrorHandler;
import org.java.plugin.boot.DefaultPluginsCollector;
import org.java.plugin.boot.PluginsCollector;
import org.java.plugin.registry.IntegrityCheckReport;
import org.java.plugin.registry.ManifestInfo;
import org.java.plugin.registry.ManifestProcessingException;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.util.ExtendedProperties;
import org.java.plugin.util.IoUtil;
import org.java.plugin.util.ResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultApplicationInitializer
implements ApplicationInitializer {
    protected static final String PARAM_APPLICATION_PLUGIN = "org.java.plugin.boot.applicationPlugin";
    protected static final String PARAM_INTEGRITY_CHECK_MODE = "org.java.plugin.boot.integrityCheckMode";
    protected static final String PARAM_PLUGINS_COLLECTOR = "org.java.plugin.boot.pluginsCollector";
    protected static final String PARAM_PLUGINS_WHITE_LIST = "org.java.plugin.boot.pluginsWhiteList";
    protected static final String PARAM_PLUGINS_BLACK_LIST = "org.java.plugin.boot.pluginsBlackList";
    private Log log;
    private ExtendedProperties config;
    private String integrityCheckMode;
    private PluginsCollector collector;
    private Set<String> whiteList;
    private Set<String> blackList;

    @Override
    public void configure(ExtendedProperties extendedProperties) throws Exception {
        String string = "log4j.configuration";
        if (System.getProperty(string) == null) {
            if (extendedProperties.containsKey((Object)string)) {
                System.setProperty(string, extendedProperties.getProperty(string));
            } else {
                File file = new File(extendedProperties.getProperty("applicationRoot") + File.separator + "log4j.properties");
                if (!file.isFile()) {
                    file = new File(extendedProperties.getProperty("applicationRoot") + File.separator + "log4j.xml");
                }
                if (file.isFile()) {
                    try {
                        System.setProperty(string, IoUtil.file2url((File)file).toExternalForm());
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
        }
        this.log = LogFactory.getLog(this.getClass());
        this.log.info((Object)"logging system initialized");
        this.log.info((Object)("application root is " + extendedProperties.getProperty("applicationRoot")));
        this.config = extendedProperties;
        this.integrityCheckMode = extendedProperties.getProperty(PARAM_INTEGRITY_CHECK_MODE, "full");
        this.collector = this.getCollectorInstance(extendedProperties.getProperty(PARAM_PLUGINS_COLLECTOR));
        this.collector.configure(extendedProperties);
        this.log.debug((Object)("plug-ins collector is " + this.collector));
        try {
            this.whiteList = this.loadList(extendedProperties.getProperty(PARAM_PLUGINS_WHITE_LIST, null));
        }
        catch (IOException iOException) {
            this.log.warn((Object)"failed loading white list", (Throwable)iOException);
        }
        if (this.whiteList != null) {
            this.log.debug((Object)"white list loaded");
        }
        try {
            this.blackList = this.loadList(extendedProperties.getProperty(PARAM_PLUGINS_BLACK_LIST, null));
        }
        catch (IOException iOException) {
            this.log.warn((Object)"failed loading black list", (Throwable)iOException);
        }
        if (this.blackList != null) {
            this.log.debug((Object)"black list loaded");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> loadList(String string) throws IOException {
        if (string == null) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8"));
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                if ((string2 = string2.trim()).length() <= 0) continue;
                hashSet.add(string2);
            }
        }
        finally {
            bufferedReader.close();
        }
        this.log.debug((Object)("read " + hashSet.size() + " list items from " + string));
        return hashSet;
    }

    private PluginsCollector getCollectorInstance(String string) {
        if (string != null) {
            try {
                return (PluginsCollector)Class.forName(string).newInstance();
            }
            catch (InstantiationException instantiationException) {
                this.log.warn((Object)("failed instantiating plug-ins collector " + string), (Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.log.warn((Object)("failed instantiating plug-ins collector " + string), (Throwable)illegalAccessException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.log.warn((Object)("failed instantiating plug-ins collector " + string), (Throwable)classNotFoundException);
            }
        }
        return new DefaultPluginsCollector();
    }

    @Override
    public Application initApplication(BootErrorHandler bootErrorHandler, String[] stringArray) throws Exception {
        String string;
        this.log.debug((Object)"collecting plug-in locations");
        Collection<PluginManager.PluginLocation> collection = this.collector.collectPluginLocations();
        this.log.debug((Object)("collected " + collection.size() + " plug-in locations, instantiating plug-in manager"));
        PluginManager pluginManager = ObjectFactory.newInstance((ExtendedProperties)this.config).createManager();
        collection = this.filterPluginLocations(pluginManager.getRegistry(), collection);
        this.log.debug((Object)(collection.size() + " plug-in locations remain after " + "applying filters, publishing plug-ins"));
        pluginManager.publishPlugins(collection.toArray(new PluginManager.PluginLocation[collection.size()]));
        if (!"off".equalsIgnoreCase(this.integrityCheckMode)) {
            this.log.debug((Object)"checking plug-ins set integrity");
            string = pluginManager.getRegistry().checkIntegrity("light".equalsIgnoreCase(this.integrityCheckMode) ? null : pluginManager.getPathResolver());
            this.log.info((Object)("integrity check done: errors - " + string.countErrors() + ", warnings - " + string.countWarnings()));
            if (string.countErrors() != 0) {
                this.log.info((Object)this.integrityCheckReport2str((IntegrityCheckReport)string));
                if (!bootErrorHandler.handleError(ResourceManager.getMessage((String)"org.java.plugin.boot", (String)"integrityCheckFailed"), (IntegrityCheckReport)string)) {
                    return null;
                }
            } else if (this.log.isDebugEnabled() && (string.countErrors() > 0 || string.countWarnings() > 0)) {
                this.log.debug((Object)this.integrityCheckReport2str((IntegrityCheckReport)string));
            }
        }
        string = this.config.getProperty(PARAM_APPLICATION_PLUGIN);
        this.log.info((Object)("application plug-in is " + string));
        Plugin plugin = pluginManager.getPlugin(string);
        this.log.debug((Object)("got application plug-in " + plugin + ", initializing application"));
        if (!(plugin instanceof ApplicationPlugin)) {
            this.log.error((Object)("application plug-in class " + plugin.getClass().getName() + " doesn't assignable with " + ApplicationPlugin.class.getName()));
            throw new ClassCastException(plugin.getClass().getName());
        }
        return ((ApplicationPlugin)plugin).initApplication(this.config.getSubset(string + "."), stringArray);
    }

    protected String integrityCheckReport2str(IntegrityCheckReport integrityCheckReport) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("integrity check report:\r\n");
        stringBuilder.append("-------------- REPORT BEGIN -----------------\r\n");
        for (IntegrityCheckReport.ReportItem reportItem : integrityCheckReport.getItems()) {
            stringBuilder.append("\tseverity=").append(reportItem.getSeverity()).append("; code=").append(reportItem.getCode()).append("; message=").append(reportItem.getMessage()).append("; source=").append(reportItem.getSource()).append("\r\n");
        }
        stringBuilder.append("-------------- REPORT END -----------------");
        return stringBuilder.toString();
    }

    protected Collection<PluginManager.PluginLocation> filterPluginLocations(PluginRegistry pluginRegistry, Collection<PluginManager.PluginLocation> collection) throws ManifestProcessingException {
        if (this.whiteList == null && this.blackList == null) {
            return collection;
        }
        LinkedList<PluginManager.PluginLocation> linkedList = new LinkedList<PluginManager.PluginLocation>();
        for (PluginManager.PluginLocation pluginLocation : collection) {
            ManifestInfo manifestInfo = pluginRegistry.readManifestInfo(pluginLocation.getManifestLocation());
            if (this.whiteList != null) {
                if (!this.isPluginInList(pluginRegistry, manifestInfo, this.whiteList)) continue;
                linkedList.add(pluginLocation);
                continue;
            }
            if (this.isPluginInList(pluginRegistry, manifestInfo, this.blackList)) continue;
            linkedList.add(pluginLocation);
        }
        return linkedList;
    }

    private boolean isPluginInList(PluginRegistry pluginRegistry, ManifestInfo manifestInfo, Set<String> set) {
        if (set.contains(manifestInfo.getId())) {
            return true;
        }
        return set.contains(pluginRegistry.makeUniqueId(manifestInfo.getId(), manifestInfo.getVersion()));
    }
}

