/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.boot;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.PluginManager;
import org.java.plugin.boot.PluginsCollector;
import org.java.plugin.standard.StandardPluginLocation;
import org.java.plugin.util.ExtendedProperties;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPluginsCollector
implements PluginsCollector {
    protected static final String PARAM_PLUGINS_REPOSITORIES = "org.java.plugin.boot.pluginsRepositories";
    protected static final String PARAM_PLUGINS_LOCATIONS_DESCRIPTORS = "org.java.plugin.boot.pluginsLocationsDescriptors";
    protected Log log = LogFactory.getLog(this.getClass());
    private List<File> repositories;
    private List<URL> descriptors;

    @Override
    public void configure(ExtendedProperties extendedProperties) throws Exception {
        String string;
        this.repositories = new LinkedList<File>();
        StringTokenizer stringTokenizer = new StringTokenizer(extendedProperties.getProperty(PARAM_PLUGINS_REPOSITORIES, '.' + File.separator + "plugins"), ",", false);
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken().trim();
            if (string.length() == 0) continue;
            this.repositories.add(new File(string).getCanonicalFile());
        }
        this.log.debug((Object)("found " + this.repositories.size() + " local plug-ins repositories"));
        this.descriptors = new LinkedList<URL>();
        stringTokenizer = new StringTokenizer(extendedProperties.getProperty(PARAM_PLUGINS_LOCATIONS_DESCRIPTORS, ""), ",", false);
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken().trim();
            if (string.length() == 0) continue;
            this.descriptors.add(new URL(string));
        }
        this.log.debug((Object)("found " + this.descriptors.size() + " plug-ins locations descriptors"));
    }

    @Override
    public Collection<PluginManager.PluginLocation> collectPluginLocations() {
        LinkedList<PluginManager.PluginLocation> linkedList = new LinkedList<PluginManager.PluginLocation>();
        for (File serializable : this.repositories) {
            if (serializable.isDirectory()) {
                this.processFolder(serializable, linkedList);
                continue;
            }
            if (serializable.isFile()) {
                this.processFile(serializable, linkedList);
                continue;
            }
            this.log.warn((Object)("unknown repository location " + serializable));
        }
        for (URL uRL : this.descriptors) {
            this.processDescriptor(uRL, linkedList);
        }
        return linkedList;
    }

    protected void processFolder(File file, List<PluginManager.PluginLocation> list) {
        File[] fileArray;
        this.log.debug((Object)("processing folder - " + file));
        try {
            fileArray = StandardPluginLocation.create((File)file);
            if (fileArray != null) {
                list.add((PluginManager.PluginLocation)fileArray);
                return;
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.log.warn((Object)("failed collecting plug-in folder " + file + ", ignoring it"), (Throwable)malformedURLException);
            return;
        }
        fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                this.processFolder(file2, list);
                continue;
            }
            if (!file2.isFile()) continue;
            this.processFile(file2, list);
        }
    }

    protected void processFile(File file, List<PluginManager.PluginLocation> list) {
        this.log.debug((Object)("processing file - " + file));
        try {
            PluginManager.PluginLocation pluginLocation = StandardPluginLocation.create((File)file);
            if (pluginLocation != null) {
                list.add(pluginLocation);
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.log.warn((Object)("failed collecting plug-in file " + file + ", ignoring it"), (Throwable)malformedURLException);
        }
    }

    private void processDescriptor(URL uRL, List<PluginManager.PluginLocation> list) {
        this.log.debug((Object)("processing plug-ins locations descriptor, URL=" + uRL));
        try {
            SAXParserFactory.newInstance().newSAXParser().parse(uRL.toExternalForm(), (DefaultHandler)new LocationsDescriptorHandler(list));
        }
        catch (Exception exception) {
            this.log.warn((Object)("failed processing plug-ins locations descriptor, URL=" + uRL), (Throwable)exception);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class LocationsDescriptorHandler
    extends DefaultHandler {
        private final List<PluginManager.PluginLocation> resultData;

        LocationsDescriptorHandler(List<PluginManager.PluginLocation> list) {
            this.resultData = list;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            URL uRL;
            URL uRL2;
            if (!"plugin".equals(string3)) {
                return;
            }
            String string4 = attributes.getValue("manifest");
            if (string4 == null) {
                DefaultPluginsCollector.this.log.warn((Object)"manifest attribute missing");
                return;
            }
            try {
                uRL2 = new URL(string4);
            }
            catch (MalformedURLException malformedURLException) {
                DefaultPluginsCollector.this.log.warn((Object)("invalid manifest URL - " + string4), (Throwable)malformedURLException);
                return;
            }
            String string5 = attributes.getValue("context");
            if (string5 == null) {
                DefaultPluginsCollector.this.log.warn((Object)"context attribute missing");
                return;
            }
            try {
                uRL = new URL(string5);
            }
            catch (MalformedURLException malformedURLException) {
                DefaultPluginsCollector.this.log.warn((Object)("invalid context URL - " + string5), (Throwable)malformedURLException);
                return;
            }
            this.resultData.add((PluginManager.PluginLocation)new StandardPluginLocation(uRL, uRL2));
            DefaultPluginsCollector.this.log.debug((Object)("got plug-in location from descriptor, manifestUrl=" + uRL2 + ", contextURL=" + uRL));
        }
    }
}

