/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.contentmgmt.communication.handlers;

import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.pmm.communication.MessageHandler;
import com.tandbergtv.watchpoint.pmm.communication.MessageHandlerException;
import com.tandbergtv.watchpoint.pmm.util.RulesEngineFacade;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.WorkflowMessage;
import org.apache.log4j.Logger;

public class SendTitleIngestedEventToRulesEngine
implements MessageHandler {
    private static String TITLE_ID = "titleId";
    private static final Logger logger = Logger.getLogger(SendTitleIngestedEventToRulesEngine.class);

    @Override
    public WorkflowMessage handleMessage(WorkflowMessage message) throws Exception {
        Util.validateRequired(message, TITLE_ID);
        long titleId = Util.getLongValue(message, TITLE_ID);
        try {
            RulesEngineFacade.sendIngestedEvent(titleId);
        }
        catch (Throwable t) {
            logger.error((Object)"Error while sending title ingested event to RulesEngine: ", t);
            throw new MessageHandlerException("ERR-001", t.getLocalizedMessage());
        }
        IMessageUID uid = message.getMessageUID();
        IMessageKey key = message.getKey();
        return new WorkflowMessage(uid, key, WorkflowMessage.MessageType.ack);
    }
}

