/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.communication.handlers;

import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.pmm.communication.MessageHandler;
import com.tandbergtv.watchpoint.pmm.communication.MessageHandlerException;
import com.tandbergtv.watchpoint.pmm.entities.ContainerProperty;
import com.tandbergtv.watchpoint.pmm.entities.Context;
import com.tandbergtv.watchpoint.pmm.util.ContextManager;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.WorkflowMessage;

public class GetNamedContainerProperty
implements MessageHandler {
    private String CONTEXT_ID = "contextId";
    private String PROPERTY_NAME = "name";
    private String PROPERTY_VALUE = "value";
    private String CONTEXT_NOT_FOUND = "Entity associated with the given context does not exist.";
    private String PROPERTY_NOT_FOUND = "Named property does not not exist for the given context.";

    @Override
    public WorkflowMessage handleMessage(WorkflowMessage message) throws Exception {
        Util.validateRequired(message, this.CONTEXT_ID, this.PROPERTY_NAME);
        Long contextId = Util.getLongValue(message, this.CONTEXT_ID);
        String propertyName = Util.getStringValueTrimmed(message, this.PROPERTY_NAME);
        Context context = ContextManager.getInstance().getContext(contextId.longValue());
        if (context == null) {
            throw new MessageHandlerException("ERR-003", this.CONTEXT_NOT_FOUND);
        }
        ContainerProperty property = context.propertyExists(propertyName);
        if (property == null) {
            throw new MessageHandlerException("ERR-003", this.PROPERTY_NOT_FOUND);
        }
        IMessageUID uid = message.getMessageUID();
        IMessageKey key = message.getKey();
        WorkflowMessage response = new WorkflowMessage(uid, key, WorkflowMessage.MessageType.ack);
        response.putValue(this.PROPERTY_VALUE, property.getValue());
        return response;
    }
}

