/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.communication.handlers;

import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.pmm.communication.MessageHandler;
import com.tandbergtv.watchpoint.pmm.core.IPMMService;
import com.tandbergtv.watchpoint.pmm.core.TitleMapInfo;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MapPackageMessageHandler
implements MessageHandler {
    private static final String TITLE_ID = "titleId";
    private static final String METADATA_PATH = "metadataFilePath";
    private static final String ASSET_FILE_NAMES = "assetFileNames";
    private static final String CREATE_IF_NOT_EXIST = "createIfNotExist";
    private static final String SOURCE_COMPONENT_NAME = "sourceComponentName";
    private static final String SOURCE_ENTITY_NAME = "sourceEntityName";
    private static final String SOURCEID = "sourceId";
    private static final String STATUS = "status";
    private static final String MAP_RESPONSE_STATUS_MAPPED = "Map Successful";
    private static final String MAP_RESPONSE_STATUS_NOTMAPPED = "Manual Mapping Required";
    private static final String MAPPED_TITLES = "mappedTitles";

    @Override
    public WorkflowMessage handleMessage(WorkflowMessage message) throws Exception {
        Util.validateRequired(message, METADATA_PATH, ASSET_FILE_NAMES, CREATE_IF_NOT_EXIST, SOURCE_COMPONENT_NAME, SOURCEID);
        String metadataFilePath = Util.getStringValueTrimmed(message, METADATA_PATH);
        String assetFileNames = Util.getStringValueTrimmed(message, ASSET_FILE_NAMES);
        boolean createIfNotExist = Util.getBooleanValue(message, CREATE_IF_NOT_EXIST);
        String componentName = Util.getStringValueTrimmed(message, SOURCE_COMPONENT_NAME);
        String entityName = Util.getStringValueTrimmed(message, SOURCE_ENTITY_NAME);
        String sourceId = Util.getStringValueTrimmed(message, SOURCEID);
        Long titleId = Util.getLongValue(message, TITLE_ID);
        List<String> assetFiles = this.convertCommaSepListtoList(assetFileNames);
        File metadataFile = new File(metadataFilePath);
        String directory = metadataFile.getParent();
        ArrayList<String> assetFilePaths = new ArrayList<String>();
        for (String assetFileName : assetFiles) {
            String assetFilePath = directory + File.separator + assetFileName;
            assetFilePaths.add(assetFilePath);
        }
        IPMMService pmmService = (IPMMService)ServiceRegistry.getDefault().lookup(IPMMService.class);
        TitleMapInfo mapInfo = pmmService.packageArrived(metadataFilePath, assetFilePaths, titleId, createIfNotExist, componentName, entityName, sourceId);
        WorkflowMessage response = new WorkflowMessage(message.getMessageUID(), message.getKey(), WorkflowMessage.MessageType.ack);
        if (mapInfo.getStatus() == TitleMapInfo.Status.TITLES_NOT_FOUND) {
            response.putValue(STATUS, MAP_RESPONSE_STATUS_NOTMAPPED);
        } else {
            response.putValue(STATUS, MAP_RESPONSE_STATUS_MAPPED);
        }
        response.putValue(MAPPED_TITLES, mapInfo.getMappedTitles());
        return response;
    }

    private List<String> convertCommaSepListtoList(String commaSepList) {
        return Arrays.asList(commaSepList.split(","));
    }
}

