/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.core;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.metadatamanager.ITTVDataModelHandler;
import com.tandbergtv.metadatamanager.exception.SearchException;
import com.tandbergtv.metadatamanager.factoryImpl.SpecHandlerFactory;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldName;
import com.tandbergtv.metadatamanager.model.FileType;
import com.tandbergtv.metadatamanager.model.Item;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.metadatamanager.spec.IIdentifier;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.watchpoint.pmm.core.AssetMapInfo;
import com.tandbergtv.watchpoint.pmm.core.AssetsManager;
import com.tandbergtv.watchpoint.pmm.core.IPMMService;
import com.tandbergtv.watchpoint.pmm.core.MapFilesInfo;
import com.tandbergtv.watchpoint.pmm.core.MetadataMapInfo;
import com.tandbergtv.watchpoint.pmm.core.NationalizeTitleInfo;
import com.tandbergtv.watchpoint.pmm.core.PMMException;
import com.tandbergtv.watchpoint.pmm.core.PMMUtil;
import com.tandbergtv.watchpoint.pmm.core.PlannerIngestInfo;
import com.tandbergtv.watchpoint.pmm.core.TitleMapInfo;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.ApplicationContextHelper;
import com.tandbergtv.watchpoint.pmm.entities.IAssetList;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.Planner;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerManagement;
import com.tandbergtv.watchpoint.pmm.partner.PartnerManager;
import com.tandbergtv.watchpoint.pmm.schedule.ISchedulePersistenceService;
import com.tandbergtv.watchpoint.pmm.schedule.search.IScheduleSearchService;
import com.tandbergtv.watchpoint.pmm.title.ITitleService;
import com.tandbergtv.watchpoint.pmm.title.TitleStatusService;
import com.tandbergtv.watchpoint.pmm.title.TitleUtil;
import com.tandbergtv.watchpoint.pmm.util.PMMProperties;
import com.tandbergtv.watchpoint.pmm.util.ProgressStatusHelper;
import com.tandbergtv.watchpoint.pmm.util.RulesEngineFacade;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.springframework.context.ApplicationContext;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class PMMService
implements IPMMService {
    private static final Logger logger = Logger.getLogger(PMMService.class);
    private ITitleService titleService;
    private TitleStatusService statusService;
    private ISchedulePersistenceService schedulePersistenceService;
    private IScheduleSearchService scheduleSearchService;
    private IPartnerManagement partnerManagement;
    private String ASSET_MAP_FILTER_XPATH = "assetMappingFilterField";

    public String getServiceName() {
        return "PMM Service";
    }

    public void start() {
        ServiceRegistry defaultServiceRegistry = ServiceRegistry.getDefault();
        this.titleService = (ITitleService)defaultServiceRegistry.lookup(ITitleService.class);
        this.statusService = new TitleStatusService();
        this.schedulePersistenceService = (ISchedulePersistenceService)defaultServiceRegistry.lookup(ISchedulePersistenceService.class);
        this.scheduleSearchService = (IScheduleSearchService)defaultServiceRegistry.lookup(IScheduleSearchService.class);
        this.partnerManagement = PartnerManager.getInstance();
    }

    public void stop() {
    }

    public synchronized AssetMapInfo assetArrived(String filePath, String filterValue, Long titleId, Long assetId, String sourceComponentName, String sourceEntityName, String sourceId) throws PMMException, TitleValidationException {
        return this.assetArrivedTransactional(filePath, filterValue, titleId, assetId, sourceComponentName, sourceEntityName, sourceId);
    }

    @Transactional
    private AssetMapInfo assetArrivedTransactional(String filePath, String filterValue, Long titleId, Long assetId, String sourceComponentName, String sourceEntityName, String sourceId) throws PMMException, TitleValidationException {
        String string = filePath;
        String string2 = filterValue;
        Long l = titleId;
        Long l2 = assetId;
        String string3 = sourceComponentName;
        String string4 = sourceEntityName;
        String string5 = sourceId;
        return (AssetMapInfo)PMMService.assetArrivedTransactional_aroundBody1$advice(this, string, string2, l, l2, string3, string4, string5, TransactionEnforcer.aspectOf(), PMMService.class.getDeclaredMethod("assetArrivedTransactional", String.class, String.class, Long.class, Long.class, String.class, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    public synchronized MetadataMapInfo metadataArrived(String filePath, Long assetId, boolean createIfNotExist, String sourceComponentName, String sourceEntityName, String sourceId) throws PMMException, TitleValidationException {
        Document document = this.createDocument(filePath);
        ISpecHandler specHandler = SpecHandlerFactory.getInstance((Document)document);
        List identifiers = null;
        try {
            identifiers = specHandler.getIdentifiers(document);
        }
        catch (Exception e) {
            throw new PMMException("Failed to get asset identifiers from the metadata document.", (Throwable)e);
        }
        Title matchingTitle = null;
        for (IIdentifier identifier : identifiers) {
            try {
                Asset rootAsset = identifier.getAsset();
                matchingTitle = this.titleService.getTitleByAssetId(Long.valueOf(rootAsset.getId()));
                break;
            }
            catch (SearchException e) {
                if (createIfNotExist) continue;
                return new MetadataMapInfo(MetadataMapInfo.Status.TITLES_NOT_FOUND);
            }
        }
        if (matchingTitle != null || assetId != null) {
            if (matchingTitle == null) {
                try {
                    ApplicationContext springContext = ApplicationContextHelper.getInstance().getContext();
                    ITTVDataModelHandler ttvSpecHandler = (ITTVDataModelHandler)springContext.getBean("TTVSpecHandler");
                    Asset matchingAsset = ttvSpecHandler.getAsset(assetId);
                    Long rootAssetId = matchingAsset.getRoot() == null ? Long.valueOf(matchingAsset.getId()) : Long.valueOf(matchingAsset.getRoot().getId());
                    assetId = rootAssetId;
                    matchingTitle = this.titleService.getTitleByAssetId(rootAssetId);
                }
                catch (SearchException e) {
                    throw new PMMException(e.getLocalizedMessage(), (Throwable)e);
                }
            }
            return this.updateTitleFromMetadataTransactional(matchingTitle, assetId, specHandler, document, filePath, sourceComponentName, sourceEntityName, sourceId);
        }
        return this.createTitleFromMetadataTransactional(specHandler, document, filePath, sourceComponentName, sourceEntityName, sourceId);
    }

    @Transactional
    private MetadataMapInfo createTitleFromMetadataTransactional(ISpecHandler specHandler, Document document, String filePath, String sourceComponentName, String sourceEntityName, String sourceId) throws PMMException, TitleValidationException {
        ISpecHandler iSpecHandler = specHandler;
        Document document2 = document;
        String string = filePath;
        String string2 = sourceComponentName;
        String string3 = sourceEntityName;
        String string4 = sourceId;
        return (MetadataMapInfo)PMMService.createTitleFromMetadataTransactional_aroundBody3$advice(this, iSpecHandler, document2, string, string2, string3, string4, TransactionEnforcer.aspectOf(), PMMService.class.getDeclaredMethod("createTitleFromMetadataTransactional", ISpecHandler.class, Document.class, String.class, String.class, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    private boolean createTitle(Title assetTitle, Asset mergedAsset, String sourceComponentName, String sourceEntityName, String sourceId) throws TitleValidationException {
        boolean validationSuccess = true;
        assetTitle.setAsset(mergedAsset);
        try {
            this.titleService.create(assetTitle, sourceComponentName, sourceEntityName, sourceId);
        }
        catch (TitleValidationException e) {
            this.titleService.validate(assetTitle, true);
            this.titleService.saveAsDraft(assetTitle);
            this.statusService.sendStatus(assetTitle, ProgressStatusHelper.VALIDATION_FAILURE, e.getMessage(), false, sourceComponentName, sourceEntityName, sourceId);
            validationSuccess = false;
        }
        return validationSuccess;
    }

    @Transactional
    private MetadataMapInfo updateTitleFromMetadataTransactional(Title matchingTitle, Long rootAssetId, ISpecHandler specHandler, Document document, String filePath, String sourceComponentName, String sourceEntityName, String sourceId) throws PMMException, TitleValidationException {
        Title title = matchingTitle;
        Long l = rootAssetId;
        ISpecHandler iSpecHandler = specHandler;
        Document document2 = document;
        String string = filePath;
        String string2 = sourceComponentName;
        String string3 = sourceEntityName;
        String string4 = sourceId;
        return (MetadataMapInfo)PMMService.updateTitleFromMetadataTransactional_aroundBody5$advice(this, title, l, iSpecHandler, document2, string, string2, string3, string4, TransactionEnforcer.aspectOf(), PMMService.class.getDeclaredMethod("updateTitleFromMetadataTransactional", Title.class, Long.class, ISpecHandler.class, Document.class, String.class, String.class, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    private boolean updateTitle(Title matchingTitle, Asset mergedAsset, String sourceComponentName, String sourceEntityName, String sourceId) throws TitleValidationException {
        boolean validationSuccess = true;
        matchingTitle.setAsset(mergedAsset);
        try {
            this.titleService.update(matchingTitle, sourceComponentName, sourceEntityName, sourceId);
        }
        catch (TitleValidationException e) {
            this.titleService.validate(matchingTitle, true);
            this.titleService.saveAsDraft(matchingTitle);
            this.statusService.sendStatus(matchingTitle, ProgressStatusHelper.VALIDATION_FAILURE, e.getMessage(), false, sourceComponentName, sourceEntityName, sourceId);
            validationSuccess = false;
        }
        return validationSuccess;
    }

    private void sendProgressUpdateMetadataArrived(String sourceComponentName, String sourceEntityName, String sourceId, List<Asset> mappedAssets, Title assetTitle) {
        Long plannerId = this.scheduleSearchService.findEarliestUpcomingPlannerId(assetTitle);
        this.statusService.sendMetadataReceivedStatus(assetTitle, plannerId, sourceComponentName, sourceEntityName, sourceId);
        for (Asset asset : mappedAssets) {
            this.statusService.sendAssetReceivedStatus(assetTitle, ((Item)asset).getType(), plannerId, sourceComponentName, sourceEntityName, sourceId);
        }
    }

    private Document createDocument(String filePath) throws PMMException {
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            document = docBuilder.parse(new File(filePath));
        }
        catch (Exception e) {
            throw new PMMException("Unable to parse the metadata file: " + filePath, (Throwable)e);
        }
        return document;
    }

    private MapFilesInfo mapFiles(Asset rootAsset) {
        MapFilesInfo mapFilesResult = new MapFilesInfo();
        String pathFilter = PMMUtil.getPathFilterFieldValue(rootAsset);
        String filter = null;
        if (pathFilter != null && pathFilter.trim().length() > 0) {
            filter = File.separator + pathFilter + File.separator;
        }
        ArrayList<Asset> mappedAssets = new ArrayList<Asset>();
        ArrayList<Asset> duplicateAssets = new ArrayList<Asset>();
        for (Asset asset : rootAsset.getAllDescendantItems(false)) {
            Item item = (Item)asset;
            String fileName = TitleUtil.getFileName(item);
            if (fileName == null) continue;
            List<File> unmappedFiles = null;
            try {
                unmappedFiles = AssetsManager.getThreadLocalInstance().getUnmappedFiles(fileName, filter);
            }
            catch (Exception e) {
                logger.error((Object)("Exception when trying to get unmapped file with name: " + fileName), (Throwable)e);
            }
            if (unmappedFiles == null) continue;
            if (unmappedFiles.size() > 1) {
                mapFilesResult.setManualMappingRequired(true);
                duplicateAssets.add((Asset)item);
                continue;
            }
            if (unmappedFiles.size() != 1) continue;
            File matchingUnmappedFile = unmappedFiles.get(0);
            File movedFile = null;
            try {
                movedFile = AssetsManager.getThreadLocalInstance().moveToMappedFilesDirectory(matchingUnmappedFile);
            }
            catch (Exception e) {
                logger.error((Object)("Unable to move unmapped asset to mapped assets directory. Mapping ignored. Unmapped asset path: " + matchingUnmappedFile.getAbsolutePath()), (Throwable)e);
            }
            if (movedFile == null) continue;
            this.mapFile(movedFile.getAbsolutePath(), (Asset)item);
            mappedAssets.add((Asset)item);
            logger.debug((Object)("Mapped file: " + movedFile.getAbsolutePath() + " to item: " + item));
        }
        mapFilesResult.setMappedAssets(mappedAssets);
        mapFilesResult.setDuplicateAssets(duplicateAssets);
        return mapFilesResult;
    }

    private Map<Asset, com.tandbergtv.metadatamanager.model.File> mapContentFiles(Asset groupAsset, List<String> assetFilePaths) throws PMMException {
        HashMap<Asset, com.tandbergtv.metadatamanager.model.File> mappedAssets = new HashMap<Asset, com.tandbergtv.metadatamanager.model.File>();
        for (String assetFilePath : assetFilePaths) {
            logger.debug((Object)("assetFilePath=" + assetFilePath));
            String assetFileName = new File(assetFilePath).getName();
            List matchingAssets = this.titleService.findAssetsWithFileName(assetFileName, groupAsset);
            if (matchingAssets.size() == 0) {
                logger.debug((Object)("No assets found with assetFilePath=" + assetFilePath));
                continue;
            }
            if (matchingAssets.size() > 1) {
                logger.debug((Object)(matchingAssets.size() + " assets found with assetFilePath=" + assetFilePath));
                throw new PMMException("Multiple matching assets found for file: " + assetFilePath);
            }
            Asset matchingAsset = (Asset)matchingAssets.get(0);
            logger.debug((Object)("single asset found with assetFilePath=" + assetFilePath));
            com.tandbergtv.metadatamanager.model.File file = this.mapFile(assetFilePath, matchingAsset);
            mappedAssets.put(matchingAsset, file);
        }
        return mappedAssets;
    }

    public synchronized TitleMapInfo packageArrived(String metadataFilePath, List<String> assetFilePaths, Long titleId, boolean createIfNotExist, String sourceComponentName, String sourceEntityName, String sourceId) throws PMMException, TitleValidationException {
        Document document = this.createDocument(metadataFilePath);
        ISpecHandler specHandler = SpecHandlerFactory.getInstance((Document)document);
        List identifiers = null;
        try {
            identifiers = specHandler.getIdentifiers(document);
        }
        catch (Exception e) {
            throw new PMMException("Failed to get asset identifiers from the metadata document.", (Throwable)e);
        }
        Title matchingTitle = null;
        for (IIdentifier identifier : identifiers) {
            try {
                Asset rootAsset = identifier.getAsset();
                matchingTitle = this.titleService.getTitleByAssetId(Long.valueOf(rootAsset.getId()));
                break;
            }
            catch (SearchException e) {
                if (createIfNotExist) continue;
                return new TitleMapInfo(TitleMapInfo.Status.TITLES_NOT_FOUND);
            }
        }
        if (matchingTitle != null || titleId != null) {
            if (matchingTitle == null) {
                matchingTitle = this.titleService.getTitle(titleId);
            }
            return this.updateTitleFromPackageTransactional(matchingTitle, titleId, specHandler, document, metadataFilePath, assetFilePaths, sourceComponentName, sourceEntityName, sourceId);
        }
        return this.createTitleFromPackageTransactional(specHandler, document, metadataFilePath, assetFilePaths, sourceComponentName, sourceEntityName, sourceId);
    }

    @Transactional
    private TitleMapInfo createTitleFromPackageTransactional(ISpecHandler specHandler, Document document, String metadataFilePath, List<String> assetFilePaths, String sourceComponentName, String sourceEntityName, String sourceId) throws PMMException, TitleValidationException {
        ISpecHandler iSpecHandler = specHandler;
        Document document2 = document;
        String string = metadataFilePath;
        List<String> list = assetFilePaths;
        String string2 = sourceComponentName;
        String string3 = sourceEntityName;
        String string4 = sourceId;
        return (TitleMapInfo)PMMService.createTitleFromPackageTransactional_aroundBody7$advice(this, iSpecHandler, document2, string, list, string2, string3, string4, TransactionEnforcer.aspectOf(), PMMService.class.getDeclaredMethod("createTitleFromPackageTransactional", ISpecHandler.class, Document.class, String.class, List.class, String.class, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    private void sendProgressUpdatePackageArrived(String sourceComponentName, String sourceEntityName, String sourceId, Map<Asset, com.tandbergtv.metadatamanager.model.File> mappedAssets, Title assetTitle) {
        Long plannerId = this.scheduleSearchService.findEarliestUpcomingPlannerId(assetTitle);
        this.statusService.sendMetadataReceivedStatus(assetTitle, plannerId, sourceComponentName, sourceEntityName, sourceId);
        for (Asset asset : mappedAssets.keySet()) {
            this.statusService.sendAssetReceivedStatus(assetTitle, ((Item)asset).getType(), plannerId, sourceComponentName, sourceEntityName, sourceId);
        }
    }

    @Transactional
    private TitleMapInfo updateTitleFromPackageTransactional(Title matchingTitle, Long titleId, ISpecHandler specHandler, Document document, String metadataFilePath, List<String> assetFilePaths, String sourceComponentName, String sourceEntityName, String sourceId) throws PMMException, TitleValidationException {
        Title title = matchingTitle;
        Long l = titleId;
        ISpecHandler iSpecHandler = specHandler;
        Document document2 = document;
        String string = metadataFilePath;
        List<String> list = assetFilePaths;
        String string2 = sourceComponentName;
        String string3 = sourceEntityName;
        String string4 = sourceId;
        return (TitleMapInfo)PMMService.updateTitleFromPackageTransactional_aroundBody9$advice(this, title, l, iSpecHandler, document2, string, list, string2, string3, string4, TransactionEnforcer.aspectOf(), PMMService.class.getDeclaredMethod("updateTitleFromPackageTransactional", Title.class, Long.class, ISpecHandler.class, Document.class, String.class, List.class, String.class, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    public synchronized PlannerIngestInfo programListArrived(Collection<Title> titles, String sourceComponentName, String sourceEntityName, String sourceId) throws PMMException {
        return this.programListArrivedTransactional(titles, sourceComponentName, sourceEntityName, sourceId);
    }

    @Transactional
    private PlannerIngestInfo programListArrivedTransactional(Collection<Title> titles, String sourceComponentName, String sourceEntityName, String sourceId) throws PMMException {
        Collection<Title> collection = titles;
        String string = sourceComponentName;
        String string2 = sourceEntityName;
        String string3 = sourceId;
        return (PlannerIngestInfo)PMMService.programListArrivedTransactional_aroundBody11$advice(this, collection, string, string2, string3, TransactionEnforcer.aspectOf(), PMMService.class.getDeclaredMethod("programListArrivedTransactional", Collection.class, String.class, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    public synchronized PlannerIngestInfo plannersArrived(Collection<Planner> planners, String sourceComponentName, String sourceEntityName, String sourceId) throws PMMException {
        if (planners == null || planners.isEmpty()) {
            throw new IllegalArgumentException("Planners collection is null or empty");
        }
        Planner[] incomingPlanners = planners.toArray(new Planner[planners.size()]);
        boolean[] completeKeys = new boolean[planners.size()];
        for (int i = 0; i < planners.size(); ++i) {
            completeKeys[i] = this.validatePlanner(incomingPlanners[i]);
        }
        return this.plannersArrivedTransactional(incomingPlanners, completeKeys, sourceComponentName, sourceEntityName, sourceId);
    }

    @Transactional
    private PlannerIngestInfo plannersArrivedTransactional(Planner[] planners, boolean[] completeKeys, String sourceComponentName, String sourceEntityName, String sourceId) throws PMMException {
        Planner[] plannerArray = planners;
        boolean[] blArray = completeKeys;
        String string = sourceComponentName;
        String string2 = sourceEntityName;
        String string3 = sourceId;
        return (PlannerIngestInfo)PMMService.plannersArrivedTransactional_aroundBody13$advice(this, plannerArray, blArray, string, string2, string3, TransactionEnforcer.aspectOf(), PMMService.class.getDeclaredMethod("plannersArrivedTransactional", Planner[].class, boolean[].class, String.class, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    private Planner plannerArrived(Planner planner, boolean firstTitleHasCompleteKey, String sourceComponentName, String sourceEntityName, String sourceId) throws PMMException {
        Planner matchedPlanner;
        Collection matchedPlanners = this.scheduleSearchService.getPlannersByDate(planner.getSourcePartnerID(), planner.getArrivalDate());
        if (matchedPlanners != null && matchedPlanners.size() > 1) {
            throw new PMMException("Multiple planners found for partner [providerid: " + planner.getProviderID() + "] and arrival date [" + planner.getArrivalDate() + "]");
        }
        if (matchedPlanners == null || matchedPlanners.isEmpty()) {
            matchedPlanner = new Planner(planner.getSourcePartnerID(), planner.getArrivalDate());
        } else {
            matchedPlanner = (Planner)matchedPlanners.iterator().next();
            if (!firstTitleHasCompleteKey) {
                throw new PMMException("Planner already exist for [providerid: " + planner.getProviderID() + "] and arrival date [" + planner.getArrivalDate() + "] and this planner contain titles " + "that do not have complete key");
            }
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            ArrayList<Title> newTitles = new ArrayList<Title>();
            for (Title title : planner.getTitles()) {
                String metadataContent = title.getMetadataContent();
                InputSource is = new InputSource(new StringReader(metadataContent));
                Document metadataDoc = docBuilder.parse(is);
                List<Title> persistedTitles = this.createOrUpdateTitles(metadataDoc, sourceComponentName, sourceEntityName, sourceId);
                newTitles.addAll(persistedTitles);
            }
            matchedPlanner.setTitles(newTitles);
        }
        catch (Exception e) {
            throw new PMMException("Adding titles to planner [Provider ID: " + planner.getProviderID() + " | Arrival Date: " + planner.getArrivalDate() + "] failed | Reason: " + e.getMessage(), (Throwable)e);
        }
        this.schedulePersistenceService.save((IAssetList)matchedPlanner);
        logger.debug((Object)("Planner ingested. | Planner: " + matchedPlanner));
        return matchedPlanner;
    }

    private boolean validatePlanner(Planner planner) throws PMMException {
        Partner partner;
        logger.debug((Object)("Ingesting planner. | ProviderID: " + planner.getProviderID() + " Arrival Date: " + planner.getArrivalDate()));
        if (planner.getProviderID() == null || planner.getProviderID().trim().length() == 0) {
            throw new PMMException("Planner Provider ID cannot be null or empty");
        }
        if (planner.getArrivalDate() == null) {
            throw new PMMException("Planner Arrival Date cannot be null");
        }
        if (planner.getTitles() == null || planner.getTitles().isEmpty()) {
            throw new PMMException("Planner does not have any titles");
        }
        Title firstTitle = (Title)planner.getTitles().iterator().next();
        boolean firstTitleHasCompleteKey = this.isTitleWithCompleteKey(firstTitle);
        if (firstTitleHasCompleteKey) {
            this.checkForDuplicateTitles(planner.getTitles());
        }
        if ((partner = this.partnerManagement.getSourcePartner(planner.getProviderID())) == null) {
            throw new PMMException("No source partner found for providerId: " + planner.getProviderID());
        }
        planner.setSourcePartnerID(Long.valueOf(partner.getId()));
        return firstTitleHasCompleteKey;
    }

    private boolean isTitleWithCompleteKey(Title firstTitle) throws PMMException {
        boolean result = true;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            String metadataContent = firstTitle.getMetadataContent();
            InputSource is = new InputSource(new StringReader(metadataContent));
            Document metadataDoc = docBuilder.parse(is);
            ISpecHandler specHandler = SpecHandlerFactory.getInstance((Document)metadataDoc);
            List identifiers = specHandler.getIdentifiers(metadataDoc);
            for (IIdentifier identifier : identifiers) {
                result = result && identifier.isValidIdentifier();
            }
        }
        catch (Exception e) {
            throw new PMMException("Adding titles failed | Reason: " + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void checkForDuplicateTitles(Collection<Title> titles) throws PMMException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            HashSet allSets = new HashSet();
            for (Title title : titles) {
                HashSet<IIdentifier> allKeysForTitle = new HashSet<IIdentifier>();
                String metadataContent = title.getMetadataContent();
                InputSource is = new InputSource(new StringReader(metadataContent));
                Document metadataDoc = docBuilder.parse(is);
                ISpecHandler specHandler = SpecHandlerFactory.getInstance((Document)metadataDoc);
                List identifiers = specHandler.getIdentifiers(metadataDoc);
                for (IIdentifier identifier : identifiers) {
                    if (!identifier.isValidIdentifier()) {
                        throw new PMMException("Cannot check for duplicates. | One or more titles do not have complete key");
                    }
                    logger.debug((Object)("checking identifier: " + identifier.toString() + ", hashCode: " + identifier.hashCode()));
                    allKeysForTitle.add(identifier);
                }
                if (allSets.contains(allKeysForTitle)) {
                    throw new PMMException("Multiple titles have the same key: " + allKeysForTitle);
                }
                allSets.add(allKeysForTitle);
            }
        }
        catch (Exception e) {
            throw new PMMException("Adding titles failed | Reason: " + e.getMessage(), (Throwable)e);
        }
    }

    private List<Title> createOrUpdateTitles(Document metadata, String sourceComponentName, String sourceEntityName, String sourceId) throws PMMException, TitleValidationException {
        ISpecHandler specHandler = SpecHandlerFactory.getInstance((Document)metadata);
        List identifiers = null;
        try {
            identifiers = specHandler.getIdentifiers(metadata);
        }
        catch (Exception e) {
            throw new PMMException("Failed to get asset identifiers from the metadata document.", (Throwable)e);
        }
        Title matchingTitle = null;
        for (IIdentifier identifier : identifiers) {
            try {
                Asset rootAsset = identifier.getAsset();
                matchingTitle = this.titleService.getTitleByAssetId(Long.valueOf(rootAsset.getId()));
                break;
            }
            catch (SearchException e) {
                matchingTitle = null;
            }
        }
        if (matchingTitle != null) {
            matchingTitle = this.titleService.getTitleForUpdate(matchingTitle.getId());
        }
        ArrayList<Title> resultTitles = new ArrayList<Title>();
        List mergedAssets = null;
        try {
            mergedAssets = specHandler.mergeWithoutSave(metadata);
        }
        catch (Exception e) {
            throw new PMMException("Failed to save titles for the metadata document.", (Throwable)e);
        }
        if (mergedAssets != null) {
            logger.debug((Object)("created mergedAssets, size=" + mergedAssets.size()));
            for (Asset mergedAsset : mergedAssets) {
                Title assetTitle = null;
                if (matchingTitle == null) {
                    assetTitle = new Title();
                    this.createTitle(assetTitle, mergedAsset, sourceComponentName, sourceEntityName, sourceId);
                } else {
                    assetTitle = matchingTitle;
                    this.updateTitle(assetTitle, mergedAsset, sourceComponentName, sourceEntityName, sourceId);
                }
                resultTitles.add(assetTitle);
            }
        }
        return resultTitles;
    }

    @Transactional
    public NationalizeTitleInfo nationalizeAndSave(Long titleId, String event, String sourceComponentName, String sourceEntityName, String sourceId) throws TitleValidationException {
        Long l = titleId;
        String string = event;
        String string2 = sourceComponentName;
        String string3 = sourceEntityName;
        String string4 = sourceId;
        return (NationalizeTitleInfo)PMMService.nationalizeAndSave_aroundBody15$advice(this, l, string, string2, string3, string4, TransactionEnforcer.aspectOf(), PMMService.class.getDeclaredMethod("nationalizeAndSave", Long.class, String.class, String.class, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    protected com.tandbergtv.metadatamanager.model.File mapFile(String filePath, Asset asset) {
        List files = asset.getChildrenOfType(com.tandbergtv.metadatamanager.model.File.class);
        if (files != null) {
            for (com.tandbergtv.metadatamanager.model.File file : files) {
                if (!file.isOriginal()) continue;
                file.setFileType(FileType.HISTORICAL);
            }
        }
        com.tandbergtv.metadatamanager.model.File newFile = new com.tandbergtv.metadatamanager.model.File();
        newFile.setFileType(FileType.ORIGINAL);
        newFile.setType(Item.ItemType.FILE);
        newFile.addField(new Field(FieldName.FILE_URL.toString(), filePath));
        String size = new File(filePath).length() + "";
        newFile.addField(new Field(FieldName.FILE_SIZE.toString(), size));
        asset.addChild((Asset)newFile);
        return newFile;
    }

    private static final /* synthetic */ AssetMapInfo assetArrivedTransactional_aroundBody0(PMMService this_, String filePath, String filterValue, Long titleId, Long assetId, String sourceComponentName, String sourceEntityName, String sourceId) {
        String fileName = new File(filePath).getName();
        Asset foundAsset = null;
        Title rootTitle = null;
        boolean validationSuccess = true;
        com.tandbergtv.metadatamanager.model.File mappedFile = null;
        if (assetId == null) {
            String filterXpath = "";
            try {
                filterXpath = PMMProperties.getInstance().getProperty(this_.ASSET_MAP_FILTER_XPATH);
            }
            catch (FileNotFoundException e) {
                logger.error((Object)"Error when reading filter xpath: ", (Throwable)e);
            }
            catch (IOException e) {
                logger.error((Object)"IO Exception when reading filter xpath: ", (Throwable)e);
            }
            Collection foundAssets = this_.titleService.findAssetsWithFileName(fileName, filterXpath, filterValue);
            if (foundAssets == null || foundAssets.isEmpty()) {
                return new AssetMapInfo(AssetMapInfo.Status.NO_MATCH);
            }
            if (foundAssets.size() > 1) {
                return new AssetMapInfo(AssetMapInfo.Status.MULTIPLE_MATCHES);
            }
            foundAsset = (Asset)foundAssets.iterator().next();
            Long rootAssetId = foundAsset.getRoot() == null ? Long.valueOf(foundAsset.getId()) : Long.valueOf(foundAsset.getRoot().getId());
            rootTitle = this_.titleService.getTitleForUpdateByAssetId(rootAssetId);
        } else {
            try {
                rootTitle = this_.titleService.getTitleForUpdate(titleId);
            }
            catch (Exception e) {
                String msg = "Failed to read the Title from the persistence service, error: " + e.getMessage();
                throw new PMMException(msg);
            }
            if (rootTitle == null) {
                String msg = "Did not get a Title from the persistence service.";
                throw new PMMException(msg);
            }
            Asset groupAsset = rootTitle.getAsset();
            for (Asset asset : groupAsset.getAllDescendantItems(false)) {
                if (asset.getId() != assetId.longValue()) continue;
                foundAsset = asset;
                break;
            }
        }
        for (Relation r : rootTitle.getAsset().getRelations()) {
            if (r.getTargetAsset().getId() != foundAsset.getId()) continue;
            mappedFile = this_.mapFile(filePath, r.getTargetAsset());
            break;
        }
        try {
            this_.titleService.update(rootTitle, sourceComponentName, sourceEntityName, sourceId);
        }
        catch (TitleValidationException e) {
            this_.titleService.validate(rootTitle, true);
            this_.titleService.saveAsDraft(rootTitle);
            this_.statusService.sendStatus(rootTitle, ProgressStatusHelper.VALIDATION_FAILURE, e.getMessage(), false, sourceComponentName, sourceEntityName, sourceId);
            validationSuccess = false;
        }
        Long plannerId = this_.scheduleSearchService.findEarliestUpcomingPlannerId(rootTitle);
        this_.statusService.sendAssetReceivedStatus(rootTitle, ((Item)foundAsset).getType(), plannerId, sourceComponentName, sourceEntityName, sourceId);
        AssetMapInfo mapInfo = new AssetMapInfo(AssetMapInfo.Status.MATCHED_TITLE_UPDATED);
        mapInfo.addMappedTitle(rootTitle.getId(), Long.valueOf(mappedFile.getId()), validationSuccess, ((Item)foundAsset).getType());
        return mapInfo;
    }

    private static final /* synthetic */ Object assetArrivedTransactional_aroundBody1$advice(PMMService this_, String filePath, String filterValue, Long titleId, Long assetId, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc_aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional2 = transactional;
            return PMMService.assetArrivedTransactional_aroundBody0(this_, filePath, filterValue, titleId, assetId, sourceComponentName, sourceEntityName, sourceId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional3 = transactional;
            AssetMapInfo object = PMMService.assetArrivedTransactional_aroundBody0(this_, filePath, filterValue, titleId, assetId, sourceComponentName, sourceEntityName, sourceId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final /* synthetic */ MetadataMapInfo createTitleFromMetadataTransactional_aroundBody2(PMMService this_, ISpecHandler specHandler, Document document, String filePath, String sourceComponentName, String sourceEntityName, String sourceId) {
        MetadataMapInfo mapInfo = new MetadataMapInfo(MetadataMapInfo.Status.TITLES_MERGED);
        AssetsManager.getThreadLocalInstance().beginTransaction();
        boolean saveSuccessful = false;
        try {
            List mergedAssets = null;
            try {
                mergedAssets = specHandler.mergeWithoutSave(document);
            }
            catch (Exception e) {
                throw new PMMException("Failed to save the title: " + e.getMessage(), (Throwable)e);
            }
            if (mergedAssets != null) {
                for (Asset mergedAsset : mergedAssets) {
                    this_.mapFile(filePath, mergedAsset);
                    MapFilesInfo mapFilesInfo = this_.mapFiles(mergedAsset);
                    List<Asset> mappedAssets = mapFilesInfo.getMappedAssets();
                    List<Asset> duplicateAssets = mapFilesInfo.getDuplicateAssets();
                    Title assetTitle = new Title();
                    boolean validationSuccess = this_.createTitle(assetTitle, mergedAsset, sourceComponentName, sourceEntityName, sourceId);
                    this_.sendProgressUpdateMetadataArrived(sourceComponentName, sourceEntityName, sourceId, mappedAssets, assetTitle);
                    ArrayList<String> mappedAssetsInfo = new ArrayList<String>();
                    for (Asset asset : mappedAssets) {
                        mappedAssetsInfo.add(((Item)asset).getType() + ":" + ((Item)asset).getId());
                    }
                    mapInfo.addMappedTitle(assetTitle.getId(), validationSuccess, mappedAssetsInfo);
                    ArrayList<String> duplicateAssetNames = new ArrayList<String>();
                    ArrayList<String> duplicateAssetIds = new ArrayList<String>();
                    for (Asset asset : duplicateAssets) {
                        duplicateAssetNames.add(((Item)asset).getType());
                        duplicateAssetIds.add(String.valueOf(asset.getId()));
                    }
                    mapInfo.addDuplicateAssets(assetTitle.getId(), duplicateAssetNames, duplicateAssetIds);
                    if (!mapFilesInfo.isManualMappingRequired()) continue;
                    mapInfo.setStatus(MetadataMapInfo.Status.DUPLICATE_ASSETS_FOUND);
                }
            }
            saveSuccessful = true;
        }
        finally {
            if (saveSuccessful) {
                AssetsManager.getThreadLocalInstance().commitTransaction();
            } else {
                try {
                    AssetsManager.getThreadLocalInstance().rollbackTransaction();
                }
                catch (Exception e) {
                    logger.error((Object)("Rolling back failed. | " + e.getMessage()), (Throwable)e);
                }
            }
        }
        return mapInfo;
    }

    private static final /* synthetic */ Object createTitleFromMetadataTransactional_aroundBody3$advice(PMMService this_, ISpecHandler specHandler, Document document, String filePath, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc_aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional2 = transactional;
            return PMMService.createTitleFromMetadataTransactional_aroundBody2(this_, specHandler, document, filePath, sourceComponentName, sourceEntityName, sourceId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional3 = transactional;
            MetadataMapInfo object = PMMService.createTitleFromMetadataTransactional_aroundBody2(this_, specHandler, document, filePath, sourceComponentName, sourceEntityName, sourceId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final /* synthetic */ MetadataMapInfo updateTitleFromMetadataTransactional_aroundBody4(PMMService this_, Title matchingTitle, Long rootAssetId, ISpecHandler specHandler, Document document, String filePath, String sourceComponentName, String sourceEntityName, String sourceId) {
        MetadataMapInfo mapInfo = new MetadataMapInfo(MetadataMapInfo.Status.TITLES_MERGED);
        matchingTitle = this_.titleService.getTitleForUpdate(matchingTitle.getId());
        AssetsManager.getThreadLocalInstance().beginTransaction();
        boolean saveSuccessful = false;
        try {
            List mergedAssets = null;
            try {
                mergedAssets = rootAssetId == null ? specHandler.mergeWithoutSave(document) : specHandler.mergeWithoutSave(rootAssetId, document);
            }
            catch (Exception e) {
                throw new PMMException("Failed to save the title: " + e.getMessage(), (Throwable)e);
            }
            if (mergedAssets != null) {
                for (Asset mergedAsset : mergedAssets) {
                    this_.mapFile(filePath, mergedAsset);
                    MapFilesInfo mapFilesInfo = this_.mapFiles(mergedAsset);
                    List<Asset> mappedAssets = mapFilesInfo.getMappedAssets();
                    List<Asset> duplicateAssets = mapFilesInfo.getDuplicateAssets();
                    boolean validationSuccess = this_.updateTitle(matchingTitle, mergedAsset, sourceComponentName, sourceEntityName, sourceId);
                    this_.sendProgressUpdateMetadataArrived(sourceComponentName, sourceEntityName, sourceId, mappedAssets, matchingTitle);
                    ArrayList<String> mappedAssetsInfo = new ArrayList<String>();
                    for (Asset asset : mappedAssets) {
                        mappedAssetsInfo.add(((Item)asset).getType() + ":" + ((Item)asset).getId());
                    }
                    mapInfo.addMappedTitle(matchingTitle.getId(), validationSuccess, mappedAssetsInfo);
                    ArrayList<String> duplicateAssetNames = new ArrayList<String>();
                    ArrayList<String> duplicateAssetIds = new ArrayList<String>();
                    for (Asset asset : duplicateAssets) {
                        duplicateAssetNames.add(((Item)asset).getType());
                        duplicateAssetIds.add(String.valueOf(asset.getId()));
                    }
                    mapInfo.addDuplicateAssets(matchingTitle.getId(), duplicateAssetNames, duplicateAssetIds);
                    if (!mapFilesInfo.isManualMappingRequired()) continue;
                    mapInfo.setStatus(MetadataMapInfo.Status.DUPLICATE_ASSETS_FOUND);
                }
            }
            saveSuccessful = true;
        }
        finally {
            if (saveSuccessful) {
                AssetsManager.getThreadLocalInstance().commitTransaction();
            } else {
                try {
                    AssetsManager.getThreadLocalInstance().rollbackTransaction();
                }
                catch (Exception e) {
                    logger.error((Object)("Rolling back failed. | " + e.getMessage()), (Throwable)e);
                }
            }
        }
        return mapInfo;
    }

    private static final /* synthetic */ Object updateTitleFromMetadataTransactional_aroundBody5$advice(PMMService this_, Title matchingTitle, Long rootAssetId, ISpecHandler specHandler, Document document, String filePath, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc_aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional2 = transactional;
            return PMMService.updateTitleFromMetadataTransactional_aroundBody4(this_, matchingTitle, rootAssetId, specHandler, document, filePath, sourceComponentName, sourceEntityName, sourceId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional3 = transactional;
            MetadataMapInfo object = PMMService.updateTitleFromMetadataTransactional_aroundBody4(this_, matchingTitle, rootAssetId, specHandler, document, filePath, sourceComponentName, sourceEntityName, sourceId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final /* synthetic */ TitleMapInfo createTitleFromPackageTransactional_aroundBody6(PMMService this_, ISpecHandler specHandler, Document document, String metadataFilePath, List assetFilePaths, String sourceComponentName, String sourceEntityName, String sourceId) {
        TitleMapInfo mapInfo = new TitleMapInfo(TitleMapInfo.Status.TITLES_MERGED);
        AssetsManager.getThreadLocalInstance().beginTransaction();
        boolean saveSuccessful = false;
        try {
            List mergedAssets = null;
            try {
                mergedAssets = specHandler.mergeWithoutSave(document);
            }
            catch (Exception e) {
                throw new PMMException("Failed to save the title: " + e.getMessage(), (Throwable)e);
            }
            if (mergedAssets != null) {
                for (Asset mergedAsset : mergedAssets) {
                    this_.mapFile(metadataFilePath, mergedAsset);
                    Map<Asset, com.tandbergtv.metadatamanager.model.File> mappedAssets = this_.mapContentFiles(mergedAsset, assetFilePaths);
                    Title assetTitle = new Title();
                    boolean validationSuccess = this_.createTitle(assetTitle, mergedAsset, sourceComponentName, sourceEntityName, sourceId);
                    this_.sendProgressUpdatePackageArrived(sourceComponentName, sourceEntityName, sourceId, mappedAssets, assetTitle);
                    mapInfo.addMappedTitle(assetTitle.getId(), validationSuccess, mappedAssets);
                }
            }
            saveSuccessful = true;
        }
        finally {
            if (saveSuccessful) {
                AssetsManager.getThreadLocalInstance().commitTransaction();
            } else {
                try {
                    AssetsManager.getThreadLocalInstance().rollbackTransaction();
                }
                catch (Exception e) {
                    logger.error((Object)("Rolling back failed. | " + e.getMessage()), (Throwable)e);
                }
            }
        }
        return mapInfo;
    }

    private static final /* synthetic */ Object createTitleFromPackageTransactional_aroundBody7$advice(PMMService this_, ISpecHandler specHandler, Document document, String metadataFilePath, List assetFilePaths, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc_aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional2 = transactional;
            return PMMService.createTitleFromPackageTransactional_aroundBody6(this_, specHandler, document, metadataFilePath, assetFilePaths, sourceComponentName, sourceEntityName, sourceId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional3 = transactional;
            TitleMapInfo object = PMMService.createTitleFromPackageTransactional_aroundBody6(this_, specHandler, document, metadataFilePath, assetFilePaths, sourceComponentName, sourceEntityName, sourceId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final /* synthetic */ TitleMapInfo updateTitleFromPackageTransactional_aroundBody8(PMMService this_, Title matchingTitle, Long titleId, ISpecHandler specHandler, Document document, String metadataFilePath, List assetFilePaths, String sourceComponentName, String sourceEntityName, String sourceId) {
        TitleMapInfo mapInfo = new TitleMapInfo(TitleMapInfo.Status.TITLES_MERGED);
        matchingTitle = titleId != null ? this_.titleService.getTitleForUpdate(titleId) : this_.titleService.getTitleForUpdate(matchingTitle.getId());
        AssetsManager.getThreadLocalInstance().beginTransaction();
        boolean saveSuccessful = false;
        try {
            List mergedAssets = null;
            try {
                if (titleId == null) {
                    mergedAssets = specHandler.mergeWithoutSave(document);
                } else {
                    Long assetId = matchingTitle.getAsset().getId();
                    mergedAssets = specHandler.mergeWithoutSave(assetId, document);
                }
            }
            catch (Exception e) {
                throw new PMMException("Failed to save the title: " + e.getMessage(), (Throwable)e);
            }
            if (mergedAssets != null) {
                for (Asset mergedAsset : mergedAssets) {
                    this_.mapFile(metadataFilePath, mergedAsset);
                    Map<Asset, com.tandbergtv.metadatamanager.model.File> mappedAssets = this_.mapContentFiles(mergedAsset, assetFilePaths);
                    boolean validationSuccess = this_.updateTitle(matchingTitle, mergedAsset, sourceComponentName, sourceEntityName, sourceId);
                    this_.sendProgressUpdatePackageArrived(sourceComponentName, sourceEntityName, sourceId, mappedAssets, matchingTitle);
                    mapInfo.addMappedTitle(matchingTitle.getId(), validationSuccess, mappedAssets);
                }
            }
            saveSuccessful = true;
        }
        finally {
            if (saveSuccessful) {
                AssetsManager.getThreadLocalInstance().commitTransaction();
            } else {
                try {
                    AssetsManager.getThreadLocalInstance().rollbackTransaction();
                }
                catch (Exception e) {
                    logger.error((Object)("Rolling back failed. | " + e.getMessage()), (Throwable)e);
                }
            }
        }
        return mapInfo;
    }

    private static final /* synthetic */ Object updateTitleFromPackageTransactional_aroundBody9$advice(PMMService this_, Title matchingTitle, Long titleId, ISpecHandler specHandler, Document document, String metadataFilePath, List assetFilePaths, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc_aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional2 = transactional;
            return PMMService.updateTitleFromPackageTransactional_aroundBody8(this_, matchingTitle, titleId, specHandler, document, metadataFilePath, assetFilePaths, sourceComponentName, sourceEntityName, sourceId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional3 = transactional;
            TitleMapInfo object = PMMService.updateTitleFromPackageTransactional_aroundBody8(this_, matchingTitle, titleId, specHandler, document, metadataFilePath, assetFilePaths, sourceComponentName, sourceEntityName, sourceId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ PlannerIngestInfo programListArrivedTransactional_aroundBody10(PMMService this_, Collection titles, String sourceComponentName, String sourceEntityName, String sourceId) {
        if (titles == null || titles.isEmpty()) {
            throw new IllegalArgumentException("Titles collection is null or empty");
        }
        Title firstTitle = (Title)titles.iterator().next();
        boolean firstTitleHasCompleteKey = this_.isTitleWithCompleteKey(firstTitle);
        if (firstTitleHasCompleteKey) {
            this_.checkForDuplicateTitles(titles);
        }
        PlannerIngestInfo result = new PlannerIngestInfo();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            for (Title title : titles) {
                String metadataContent = title.getMetadataContent();
                InputSource is = new InputSource(new StringReader(metadataContent));
                Document metadataDoc = docBuilder.parse(is);
                List<Title> persistedTitles = this_.createOrUpdateTitles(metadataDoc, sourceComponentName, sourceEntityName, sourceId);
                for (Title titleIter : persistedTitles) {
                    result.addSavedTitle(titleIter.getId());
                }
            }
        }
        catch (Exception e) {
            throw new PMMException("Saving titles failed | Reason: " + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private static final /* synthetic */ Object programListArrivedTransactional_aroundBody11$advice(PMMService this_, Collection titles, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc_aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional2 = transactional;
            return PMMService.programListArrivedTransactional_aroundBody10(this_, titles, sourceComponentName, sourceEntityName, sourceId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional3 = transactional;
            PlannerIngestInfo object = PMMService.programListArrivedTransactional_aroundBody10(this_, titles, sourceComponentName, sourceEntityName, sourceId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ PlannerIngestInfo plannersArrivedTransactional_aroundBody12(PMMService this_, Planner[] planners, boolean[] completeKeys, String sourceComponentName, String sourceEntityName, String sourceId) {
        PlannerIngestInfo result = new PlannerIngestInfo();
        for (int i = 0; i < planners.length; ++i) {
            try {
                planners[i] = this_.plannerArrived(planners[i], completeKeys[i], sourceComponentName, sourceEntityName, sourceId);
                for (Title title : planners[i].getTitles()) {
                    result.addSavedTitle(title.getId());
                }
                continue;
            }
            catch (PMMException e) {
                throw new PMMException("Ingesting planner [Provider ID: " + planners[i].getProviderID() + " | Arrival Date: " + planners[i].getArrivalDate() + "] failed | Reason: " + e.getMessage(), (Throwable)e);
            }
            catch (RuntimeException e) {
                throw new PMMException("Ingesting planner [Provider ID: " + planners[i].getProviderID() + " | Arrival Date: " + planners[i].getArrivalDate() + "] failed | Reason: " + e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    private static final /* synthetic */ Object plannersArrivedTransactional_aroundBody13$advice(PMMService this_, Planner[] planners, boolean[] completeKeys, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc_aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional2 = transactional;
            return PMMService.plannersArrivedTransactional_aroundBody12(this_, planners, completeKeys, sourceComponentName, sourceEntityName, sourceId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional3 = transactional;
            PlannerIngestInfo object = PMMService.plannersArrivedTransactional_aroundBody12(this_, planners, completeKeys, sourceComponentName, sourceEntityName, sourceId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ NationalizeTitleInfo nationalizeAndSave_aroundBody14(PMMService this_, Long titleId, String event, String sourceComponentName, String sourceEntityName, String sourceId) {
        NationalizeTitleInfo result = new NationalizeTitleInfo(true);
        Title title = this_.titleService.getTitleForUpdate(titleId);
        Title nationalizedTitle = RulesEngineFacade.nationalize(title, event);
        try {
            this_.titleService.validate(title, false);
            this_.titleService.save(title);
            this_.statusService.sendStatus(nationalizedTitle, ProgressStatusHelper.NATIONALIZED, null, true, sourceComponentName, sourceEntityName, sourceId);
            this_.statusService.sendStatus(title, ProgressStatusHelper.VALIDATION_SUCCESS, null, true, sourceComponentName, sourceEntityName, sourceId);
        }
        catch (TitleValidationException e) {
            this_.titleService.validate(nationalizedTitle, true);
            this_.titleService.saveAsDraft(nationalizedTitle);
            this_.statusService.sendStatus(nationalizedTitle, ProgressStatusHelper.NATIONALIZED, null, true, sourceComponentName, sourceEntityName, sourceId);
            this_.statusService.sendStatus(nationalizedTitle, ProgressStatusHelper.VALIDATION_FAILURE, e.getMessage(), false, sourceComponentName, sourceEntityName, sourceId);
            result.setSuccessfulNationalization(false);
            result.setErrorMessage("Title Validation Failed: " + e.getMessage());
        }
        return result;
    }

    private static final /* synthetic */ Object nationalizeAndSave_aroundBody15$advice(PMMService this_, Long titleId, String event, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc_aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional2 = transactional;
            return PMMService.nationalizeAndSave_aroundBody14(this_, titleId, event, sourceComponentName, sourceEntityName, sourceId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional3 = transactional;
            NationalizeTitleInfo object = PMMService.nationalizeAndSave_aroundBody14(this_, titleId, event, sourceComponentName, sourceEntityName, sourceId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }
}

