/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.job;

import com.tandbergtv.cms.rules.service.IRuleService;
import com.tandbergtv.cms.rules.service.RuleServiceStatus;
import com.tandbergtv.watchpoint.pmm.entities.Job;
import com.tandbergtv.watchpoint.pmm.job.JobManager;
import java.util.ArrayList;
import java.util.List;

public class JobRulesetManager
implements IRuleService {
    public RuleServiceStatus canDelete(long ruleSetId) {
        String jobNames = this.getJobNames(ruleSetId);
        if (jobNames == null) {
            return new RuleServiceStatus(true);
        }
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add(String.valueOf(ruleSetId));
        parameters.add(jobNames);
        return new RuleServiceStatus(false, "errJobIsSecheduledCantDelete", parameters);
    }

    public RuleServiceStatus canRemoveSchedulable(long ruleSetId) {
        String jobNames = this.getJobNames(ruleSetId);
        if (jobNames == null) {
            return new RuleServiceStatus(true);
        }
        return new RuleServiceStatus(false, "errJobIsSecheduledNeedSchedulable", jobNames);
    }

    private String getJobNames(long ruleSetId) {
        List jobs = JobManager.getInstance().getAllJobs(String.valueOf(ruleSetId));
        if (jobs == null || jobs.size() == 0) {
            return null;
        }
        StringBuffer result = new StringBuffer("");
        for (Job job : jobs) {
            if (!result.toString().isEmpty()) {
                result.append(", ");
            }
            result.append(job.getName());
        }
        return result.toString();
    }
}

