/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.util.lock;

import com.tandbergtv.watchpoint.pmm.util.lock.ILockService;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class LockService
implements ILockService {
    private static final Logger logger = Logger.getLogger(LockService.class);
    private static final LockService _instance = new LockService();
    private Set<Object> holders = Collections.synchronizedSet(new HashSet());

    private LockService() {
    }

    public static final LockService getInstance() {
        return _instance;
    }

    @Override
    public boolean lock(Object holder) {
        boolean lockAcquired = this.holders.add(holder);
        if (lockAcquired) {
            logger.debug((Object)("Locked on: " + holder));
        } else {
            logger.debug((Object)("Unable to lock on: " + holder));
        }
        return lockAcquired;
    }

    @Override
    public boolean unlock(Object holder) {
        boolean lockReleased = this.holders.remove(holder);
        if (lockReleased) {
            logger.debug((Object)("Lock released on: " + holder));
        } else {
            logger.debug((Object)("No lock found on: " + holder + " to release."));
        }
        return lockReleased;
    }
}

