/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.core;

public class AssetMapInfo {
    private static final String TITLEID_PREFIX = "titleId:";
    private static final String FILE_ASSET_ID_PREFIX = "fileAssetId:";
    private Status status;
    private StringBuffer mappedTitles;

    public AssetMapInfo(Status status) {
        this.status = status;
        this.mappedTitles = new StringBuffer();
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void addMappedTitle(Long titleId, Long fileAssetId, boolean validationSuccess, String titleName) {
        if (this.mappedTitles.length() > 0) {
            this.mappedTitles.append(", ");
        }
        this.mappedTitles.append("[").append(TITLEID_PREFIX).append(titleId).append("|").append(FILE_ASSET_ID_PREFIX).append(fileAssetId).append("|").append("Validation ").append(validationSuccess ? "Success" : "Failure").append("|").append(titleName).append("]");
    }

    public String getMappedTitles() {
        return this.mappedTitles.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Status: ").append((Object)this.status).append(" | ");
        sb.append("Mapped Titles: ").append(this.mappedTitles);
        return sb.toString();
    }

    public static enum Status {
        MATCHED_TITLE_UPDATED,
        NO_MATCH,
        MULTIPLE_MATCHES;

    }
}

