/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.search;

import com.tandbergtv.metadatamanager.search.AssetSearchKey;
import com.tandbergtv.metadatamanager.search.AssetSearchServiceImpl;
import com.tandbergtv.metadatamanager.search.FieldInfo;
import com.tandbergtv.metadatamanager.search.ListFieldInfo;
import com.tandbergtv.metadatamanager.search.MetadataValueFieldInfo;
import com.tandbergtv.metadatamanager.search.NodeFieldInfo;
import com.tandbergtv.metadatamanager.search.RangeFieldInfo;
import com.tandbergtv.metadatamanager.search.SearchInfo;
import com.tandbergtv.metadatamanager.search.SortInfo;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.search.SearchField;
import com.tandbergtv.watchpoint.pmm.title.search.SearchFieldNode;
import com.tandbergtv.watchpoint.pmm.title.search.SearchFieldNodeList;
import com.tandbergtv.watchpoint.pmm.title.search.TitleSearchKey;
import com.tandbergtv.watchpoint.search.Association;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.watchpoint.search.SearchParameter;
import com.tandbergtv.workflow.driver.search.ListParameter;
import com.tandbergtv.workflow.driver.search.RangeParameter;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;

public class TitleSearchCriteriaBuilder {
    private static String ROOT_ENTITY_ALIAS = "rootAsset";
    public static int LATEST_REVISION = -1;

    public static SearchCriteria getCriteria(boolean isInternalSearch, String externalSourceId, String searchProperty, SearchFieldNode searchFields, int startIndex, int maxRecordCount, String sortProperty, SortingOrder order, String sortName) {
        SearchCriteria criteria = new SearchCriteria();
        Entity title = new Entity("title", Title.class, "t");
        if (isInternalSearch) {
            criteria.addParameter((SearchParameterBase)new ValueParameter(TitleSearchKey.TITLE_PROVIDER_ID.toString(), SearchType.STRING, (Object)TitleSearchKey.DEFAULT_SYSTEM_ID));
        } else {
            criteria.addParameter((SearchParameterBase)new ValueParameter(TitleSearchKey.TITLE_PROVIDER_ID.toString(), SearchType.STRING, (Object)TitleSearchCriteriaBuilder.getTitleProviderId(externalSourceId)));
        }
        SearchInfo searchInfo = null;
        if (searchProperty.equals(AssetSearchKey.ALL_DESCENDANT_FIELDS.toString()) || searchProperty.equals(AssetSearchKey.FIELDS.toString())) {
            searchInfo = TitleSearchCriteriaBuilder.getSearchInfo(searchFields, searchProperty);
        } else {
            title = TitleSearchCriteriaBuilder.addSearchFields(title, (SearchField)searchFields);
        }
        SortInfo sortInfo = null;
        if (sortProperty != null && (sortProperty.equals(AssetSearchKey.ALL_DESCENDANT_FIELDS.toString()) || sortProperty.equals(AssetSearchKey.FIELDS.toString()))) {
            sortInfo = TitleSearchCriteriaBuilder.getSortInfo(order, sortName, sortProperty);
        } else {
            title = TitleSearchCriteriaBuilder.addSortField(title, order, sortName);
        }
        boolean weAreAlreadySortingByTitleId = false;
        for (SearchParameter sp : title.getSubParameters()) {
            if (!(sp.getDecoratedParameter() instanceof SortParameter) || !sp.getFieldName().equals("id")) continue;
            weAreAlreadySortingByTitleId = true;
            break;
        }
        if (!weAreAlreadySortingByTitleId) {
            if (order != null) {
                title.addParameter((SearchParameterBase)new SortParameter("id", order));
            } else {
                title.addParameter((SearchParameterBase)new SortParameter("id", SortingOrder.DESCENDING));
            }
        }
        criteria.setStartingRecordNumber(startIndex);
        criteria.setRecordsCount(maxRecordCount);
        AssetSearchServiceImpl assetSearch = new AssetSearchServiceImpl();
        SearchCriteria assetCriteria = assetSearch.getCriteria(ROOT_ENTITY_ALIAS, searchInfo, sortInfo, LATEST_REVISION);
        Entity asset = (Entity)assetCriteria.getParameter(ROOT_ENTITY_ALIAS);
        Association a = new Association("titleAssetAssociation", title, "asset.id", asset, "id");
        criteria.addParameter((SearchParameterBase)a);
        criteria.addParameter((SearchParameterBase)asset);
        criteria.addParameter((SearchParameterBase)title);
        return criteria;
    }

    private static Entity addSortField(Entity title, SortingOrder order, String sortName) {
        if (sortName != null) {
            title.addParameter((SearchParameterBase)new SortParameter(sortName, order));
        }
        return title;
    }

    private static SortInfo getSortInfo(SortingOrder order, String sortName, String sortKeyProperty) {
        if (sortName == null) {
            return null;
        }
        SortInfo info = new SortInfo();
        info.setOrder(order);
        info.setSortItemName(sortName);
        if (sortKeyProperty != null) {
            info.setProperty(sortKeyProperty.toString());
        }
        return info;
    }

    private static SearchInfo getSearchInfo(SearchFieldNode searchFields, String fieldProperty) {
        if (searchFields == null || searchFields instanceof SearchFieldNodeList && ((SearchFieldNodeList)searchFields).getNodeList().isEmpty()) {
            return null;
        }
        SearchInfo info = new SearchInfo();
        info.setProperty(fieldProperty);
        FieldInfo fields = TitleSearchCriteriaBuilder.getFields(searchFields);
        info.setFields(fields);
        return info;
    }

    private static Entity addSearchFields(Entity title, SearchField field) {
        if (field.isListParameter()) {
            ListParameter listParam = new ListParameter(field.getName(), field.getSearchType(), field.getSearchOperator());
            listParam.setValues(field.getValues());
            title.addParameter((SearchParameterBase)listParam);
        } else if (field.isRangeParameter()) {
            RangeParameter rangeParam = new RangeParameter(field.getName(), field.getSearchType());
            rangeParam.setFrom(field.getValues().get(0));
            rangeParam.setTo(field.getValues().get(1));
            title.addParameter((SearchParameterBase)rangeParam);
        } else if (field.isValueParameter()) {
            title.addParameter((SearchParameterBase)new ValueParameter(field.getName(), field.getSearchType(), (Object)field.getValues().get(0), field.getSearchOperator()));
        }
        return title;
    }

    private static FieldInfo getFields(SearchFieldNode searchFields) {
        if (searchFields instanceof SearchField) {
            SearchField field = (SearchField)searchFields;
            FieldInfo finfo = TitleSearchCriteriaBuilder.getFieldInfo(field);
            if (field.getSectionName() != null) {
                finfo.setAssetType(field.getSectionName());
            }
            return finfo;
        }
        if (searchFields instanceof SearchFieldNodeList) {
            SearchFieldNodeList sfnl = (SearchFieldNodeList)searchFields;
            NodeFieldInfo finfo = new NodeFieldInfo(sfnl.getOperator() == SearchFieldNodeList.Operator.AND);
            for (SearchFieldNode sfn : sfnl.getNodeList()) {
                FieldInfo fi = TitleSearchCriteriaBuilder.getFields(sfn);
                finfo.addNode(fi);
            }
            return finfo;
        }
        return null;
    }

    private static FieldInfo getFieldInfo(SearchField field) {
        ListFieldInfo fi = null;
        if (field.isListParameter()) {
            fi = new ListFieldInfo(field.getName(), field.getValues(), field.getSearchOperator());
        } else if (field.isValueParameter()) {
            String value = "";
            if (field.getValues() != null) {
                value = field.getValues().get(0);
            }
            fi = new MetadataValueFieldInfo(field.getName(), field.getSearchOperator(), value);
        } else if (field.isRangeParameter()) {
            fi = new RangeFieldInfo(field.getName(), field.getValues().get(0), field.getValues().get(1));
        }
        fi.setIgnoreCase(field.getIgnoreCase());
        return fi;
    }

    private static String getTitleProviderId(String externalSourceId) {
        String providerId = null;
        if (externalSourceId != null) {
            String[] values = externalSourceId.split("-");
            providerId = values.length > 0 ? values[0] : "";
        }
        return providerId;
    }
}

