/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.conf;

import com.tandbergtv.watchpoint.pmm.title.conf.ComplexVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.Multiplicity;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.watchpoint.pmm.title.conf.Variable;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class TitleConf {
    private Specification specification;
    private String name;
    private String alias;
    private TitleConf parent;
    private List<TitleConf> children = new ArrayList<TitleConf>();
    private boolean hasAsset;
    private List<Variable> metadata = new ArrayList<Variable>();
    private int min;
    private int max;

    public TitleConf(Specification specification) {
        this.specification = specification;
    }

    public String getAlias() {
        if (this.alias == null || this.alias.length() == 0) {
            return this.name;
        }
        ResourceBundle bundle = this.specification.getBundle();
        if (bundle != null && bundle.containsKey(this.alias)) {
            return bundle.getString(this.alias);
        }
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public Specification getSpecification() {
        return this.specification;
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    public TitleConf getParent() {
        return this.parent;
    }

    void setParent(TitleConf parent) {
        this.parent = parent;
    }

    public String getParentName() {
        return this.parent != null ? this.parent.getName() : null;
    }

    public List<TitleConf> getChildren() {
        return this.children;
    }

    void setChildren(List<TitleConf> children) {
        if (children != null) {
            for (TitleConf child : children) {
                child.setParent(this);
            }
        }
        this.children = children != null ? children : new ArrayList();
    }

    public boolean isHasAsset() {
        return this.hasAsset;
    }

    void setHasAsset(boolean hasAsset) {
        this.hasAsset = hasAsset;
    }

    public Multiplicity getTitleMultiplicity() {
        return Multiplicity.getMultiplicity(this.min, this.max);
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public List<Variable> getMetadata() {
        return this.metadata;
    }

    void setMetadata(List<Variable> metadata) {
        this.metadata = metadata != null ? metadata : new ArrayList();
    }

    public Variable getMetadataVariableByXPath(String xpath) {
        return this.getMetadataVariableByXPath(this.metadata, xpath);
    }

    private Variable getMetadataVariableByXPath(List<Variable> variables, String xpath) {
        if (variables == null) {
            return null;
        }
        Variable match = null;
        for (Variable variable : variables) {
            if (xpath.equals(variable.getXPath())) {
                match = variable;
            } else if (variable instanceof ComplexVariable) {
                ComplexVariable complexVariable = (ComplexVariable)variable;
                match = this.getMetadataVariableByXPath(complexVariable.getChildren(), xpath);
            }
            if (match == null) continue;
            break;
        }
        return match;
    }

    public TitleConf getChild(String name) {
        if (this.children != null) {
            for (TitleConf child : this.children) {
                if (!child.getName().equals(name)) continue;
                return child;
            }
        }
        return null;
    }

    void addChild(TitleConf titleConf) {
        titleConf.setParent(this);
        this.children.add(titleConf);
    }

    void addMetadata(Variable v) {
        this.metadata.add(v);
    }

    public List<TitleConf> getAllDescendants() {
        ArrayList<TitleConf> allDecendants = new ArrayList<TitleConf>();
        for (TitleConf child : this.getChildren()) {
            allDecendants.add(child);
            allDecendants.addAll(child.getAllDescendants());
        }
        return allDecendants;
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : super.hashCode();
    }

    public boolean equals(Object o) {
        if (this.name != null) {
            return o instanceof TitleConf && this.name.equals(((TitleConf)o).name);
        }
        return super.equals(o);
    }

    public String toString() {
        String newLineString = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append("TitleConf:\n");
        sb.append("Name: " + this.name).append(" (").append(this.getAlias()).append(")").append(newLineString);
        sb.append("Parent Name: " + this.getParentName()).append(newLineString);
        sb.append("Min-max " + this.min + "," + this.max).append(newLineString);
        sb.append("Metadata: \n");
        for (Variable v : this.metadata) {
            sb.append(v).append(newLineString);
        }
        sb.append("Children: \n");
        for (TitleConf child : this.children) {
            sb.append(child).append(newLineString);
        }
        return sb.toString();
    }
}

