/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.communication.handlers;

import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.pmm.communication.MessageHandler;
import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.io.Serializable;

public class GetContextIdMessageHandler
implements MessageHandler {
    private static final String LOOKUP_KEY = "lookupKey";
    private static String CONTAINER_CACHE_SERVICE_NAME = "Container Cache";
    private static final String CONTEXT_ID = "contextId";

    @Override
    public WorkflowMessage handleMessage(WorkflowMessage message) throws Exception {
        Util.validateRequired(message, LOOKUP_KEY);
        String lookupKey = Util.getStringValueTrimmed(message, LOOKUP_KEY);
        String contextId = "";
        ICacheService containerCache = (ICacheService)ServiceRegistry.getDefault().lookup(CONTAINER_CACHE_SERVICE_NAME);
        for (Serializable key : containerCache.getKeys()) {
            IContainer container = (IContainer)containerCache.get(key);
            if (container.getContainerLookupKey() == null || !container.getContainerLookupKey().trim().equals(lookupKey)) continue;
            contextId = Long.toString(container.getContainerContextId());
            break;
        }
        WorkflowMessage response = new WorkflowMessage(message.getMessageUID(), message.getKey(), WorkflowMessage.MessageType.ack);
        response.putValue(CONTEXT_ID, contextId);
        return response;
    }
}

