/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.communication.handlers;

import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.pmm.communication.MessageHandler;
import com.tandbergtv.watchpoint.pmm.core.IPMMService;
import com.tandbergtv.watchpoint.pmm.core.MetadataMapInfo;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.WorkflowMessage;

public class MapMetadataMessageHandler
implements MessageHandler {
    private static final String DUPLICATE_ASSETS = "duplicateAssets";
    private static final String DUPLICATE_ASSET_IDS = "duplicateAssetIds";
    private static final String METADATA_PATH = "metadataPath";
    private static final String CREATE_IF_NOT_EXIST = "createIfNotExist";
    private static final String SOURCE_COMPONENT_NAME = "sourceComponentName";
    private static final String SOURCE_ENTITY_NAME = "sourceEntityName";
    private static final String SOURCEID = "sourceId";
    private static final String STATUS = "status";
    private static final String MAP_RESPONSE_STATUS_MAPPED = "Map Successful";
    private static final String MAP_RESPONSE_STATUS_NOTMAPPED = "Manual Mapping Required";
    private static final String MAP_RESPONSE_STATUS_DUPLICATE_ASSETS = "Manual Asset Mapping Required";
    private static final String MAPPED_TITLES = "mappedTitles";

    @Override
    public WorkflowMessage handleMessage(WorkflowMessage message) throws Exception {
        Util.validateRequired(message, METADATA_PATH, CREATE_IF_NOT_EXIST, SOURCE_COMPONENT_NAME, SOURCEID);
        String metadataFilePath = Util.getStringValueTrimmed(message, METADATA_PATH);
        boolean createIfNotExist = Util.getBooleanValue(message, CREATE_IF_NOT_EXIST);
        String componentName = Util.getStringValueTrimmed(message, SOURCE_COMPONENT_NAME);
        String entityName = Util.getStringValueTrimmed(message, SOURCE_ENTITY_NAME);
        String sourceId = Util.getStringValueTrimmed(message, SOURCEID);
        IPMMService pmmService = (IPMMService)ServiceRegistry.getDefault().lookup(IPMMService.class);
        MetadataMapInfo mapInfo = pmmService.metadataArrived(metadataFilePath, null, createIfNotExist, componentName, entityName, sourceId);
        WorkflowMessage response = new WorkflowMessage(message.getMessageUID(), message.getKey(), WorkflowMessage.MessageType.ack);
        if (mapInfo.getStatus() == MetadataMapInfo.Status.TITLES_NOT_FOUND) {
            response.putValue(STATUS, MAP_RESPONSE_STATUS_NOTMAPPED);
        } else if (mapInfo.getStatus() == MetadataMapInfo.Status.DUPLICATE_ASSETS_FOUND) {
            int lastBarIndex;
            response.putValue(STATUS, MAP_RESPONSE_STATUS_DUPLICATE_ASSETS);
            String duplicateAssets = mapInfo.getDuplicateAssets();
            int firstBarIndex = duplicateAssets.indexOf("|");
            if (firstBarIndex != -1 && (lastBarIndex = duplicateAssets.lastIndexOf("|")) != -1) {
                String assetIdsList = duplicateAssets.substring(firstBarIndex + 1, lastBarIndex);
                response.putValue(DUPLICATE_ASSET_IDS, assetIdsList);
                int bracketIndex = duplicateAssets.lastIndexOf("]");
                if (bracketIndex != -1) {
                    String assetNameList = duplicateAssets.substring(lastBarIndex + 1, bracketIndex);
                    response.putValue(DUPLICATE_ASSETS, assetNameList);
                }
            }
        } else {
            response.putValue(STATUS, MAP_RESPONSE_STATUS_MAPPED);
        }
        response.putValue(MAPPED_TITLES, mapInfo.getMappedTitles());
        return response;
    }
}

