/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.conf.specs;

import com.tandbergtv.watchpoint.pmm.title.conf.IRightsManager;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;

public class RightsManagerFactory {
    private static IRightsManager rightsManager;

    public static void createRightsManager(PluginManager pluginManager, ExtensionPoint point) {
        Extension extension = (Extension)point.getAvailableExtensions().iterator().next();
        RightsManagerFactory.createRightsManager(pluginManager, extension);
    }

    private static void createRightsManager(PluginManager pluginManager, Extension extension) {
        String className;
        Extension.Parameter classParameter = extension.getParameter("class");
        String string = className = classParameter != null ? classParameter.valueAsString() : null;
        if (className == null || className.trim().length() == 0) {
            throw new RuntimeException("Rights manager is not configured. Make sure to set the class for rights manager in the plugin 'com.tandbergtv.metadata.rightsmanager'");
        }
        PluginClassLoader loader = pluginManager.getPluginClassLoader(extension.getDeclaringPluginDescriptor());
        try {
            Class<?> clazz = loader.loadClass(className);
            rightsManager = (IRightsManager)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create instance of " + className, e);
        }
    }

    public static IRightsManager getRightsManager() {
        return rightsManager;
    }
}

