/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.provider.internal;

import com.tandbergtv.watchpoint.pmm.title.provider.ITitleProvider;
import com.tandbergtv.watchpoint.pmm.title.provider.ITitleProviderProperties;
import com.tandbergtv.watchpoint.pmm.title.provider.ITitleSearchStrategy;
import com.tandbergtv.watchpoint.pmm.title.provider.internal.TitleProviderProperties;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;

public class TitleProviderFactory {
    public static TitleProviderFactory newInstance() {
        return new TitleProviderFactory();
    }

    public ITitleProvider createProvider(PluginManager pluginManager, Extension extension) {
        String systemId = extension.getParameter("systemId").valueAsString();
        String name = extension.getParameter("name").valueAsString();
        Extension.Parameter classParameter = extension.getParameter("class");
        String className = classParameter != null ? classParameter.valueAsString() : null;
        String searchClassName = extension.getParameter("searchClass").valueAsString();
        Collection specParameters = extension.getParameters("specification");
        ArrayList<String> specNames = new ArrayList<String>();
        for (Extension.Parameter specParameter : specParameters) {
            specNames.add(specParameter.valueAsString());
        }
        PluginClassLoader loader = pluginManager.getPluginClassLoader(extension.getDeclaringPluginDescriptor());
        ITitleSearchStrategy strategy = this.createSearchStrategy((ClassLoader)loader, searchClassName);
        TitleProviderProperties properties = new TitleProviderProperties();
        properties.setSystemID(systemId);
        properties.setName(name);
        properties.setSupportedSpecifications(specNames);
        properties.setSearchStrategy(strategy);
        ITitleProvider provider = this.createTitleProvider((ClassLoader)loader, className, properties);
        strategy.setTitleProvider(provider);
        return provider;
    }

    private ITitleSearchStrategy createSearchStrategy(ClassLoader loader, String className) {
        ITitleSearchStrategy instance = null;
        try {
            Class<?> clazz = loader.loadClass(className);
            instance = (ITitleSearchStrategy)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create instance of " + className, e);
        }
        return instance;
    }

    private ITitleProvider createTitleProvider(ClassLoader loader, String className, ITitleProviderProperties properties) {
        ITitleProvider provider = null;
        try {
            Class<?> clazz = loader.loadClass(className);
            provider = this.getTitleProvider(clazz, properties, loader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to load " + className, e);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create provider of class " + className, e);
        }
        return provider;
    }

    private ITitleProvider getTitleProvider(Class<?> clazz, ITitleProviderProperties properties, ClassLoader loader) throws Exception {
        ITitleProvider provider = null;
        Constructor<?> constructor = null;
        try {
            constructor = clazz.getConstructor(ITitleProviderProperties.class, ClassLoader.class);
            provider = (ITitleProvider)constructor.newInstance(properties, loader);
        }
        catch (NoSuchMethodException e) {
            constructor = clazz.getConstructor(ITitleProviderProperties.class);
            provider = (ITitleProvider)constructor.newInstance(properties);
        }
        return provider;
    }
}

