/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.util;

import com.tandbergtv.cms.rules.service.category.IRuleExecutionHandler;
import com.tandbergtv.marvin.udt.ActionMessage;
import com.tandbergtv.marvin.udt.RuleResults;
import com.tandbergtv.marvin.udt.TreEvent;
import com.tandbergtv.marvin.udt.TreEventType;
import com.tandbergtv.marvin.udt.TrePackage;
import com.tandbergtv.marvin.udt.ValidationMessage;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.util.ArrayList;
import java.util.List;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class RulesEngineFacade {
    private static final Logger logger = Logger.getLogger(RulesEngineFacade.class);

    public static Title nationalize(Title title, String event) {
        return RulesEngineFacade.nationalize(title, TreEventType.lookup((String)event));
    }

    public static Title nationalize(Title title, TreEventType event) {
        TrePackage tp = new TrePackage();
        tp.setName("NORMALIZATION");
        TreEvent te = new TreEvent();
        te.setType(event);
        RuleResults ruleResults = RulesEngineFacade.getRuleExecutionHandler().runRuler(title, te, tp);
        if (ruleResults != null) {
            return ruleResults.getTitle();
        }
        return title;
    }

    public static List<ValidationMessage> validate(Title title) {
        ArrayList<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();
        IRuleExecutionHandler reh = RulesEngineFacade.getRuleExecutionHandler();
        ArrayList<Title> titles = new ArrayList<Title>();
        titles.add(title);
        RuleResults ruleResults = reh.runValidateRuler(title);
        if (ruleResults != null) {
            for (ActionMessage message : ruleResults.getMessages()) {
                validationMessages.add((ValidationMessage)message);
            }
        }
        return validationMessages;
    }

    public static void sendUICreatedEvent(Long titleId) {
        RulesEngineFacade.sendEvent(TreEventType.TITLEUICREATE, titleId);
    }

    public static void sendUIUpdatedEvent(Long titleId) {
        RulesEngineFacade.sendEvent(TreEventType.TITLEUIUPDATE, titleId);
    }

    public static void sendNationalizedEvent(Long titleId) {
        RulesEngineFacade.sendEvent(TreEventType.TITLENATIONALIZED, titleId);
    }

    public static void sendIngestedEvent(Long titleId) {
        RulesEngineFacade.sendEvent(TreEventType.INGEST, titleId);
    }

    private static IRuleExecutionHandler getRuleExecutionHandler() {
        IRuleExecutionHandler reh = null;
        try {
            reh = (IRuleExecutionHandler)new InitialContext().lookup("cms/EventHandler/local");
        }
        catch (NamingException e) {
            logger.error((Object)"Unable to obtain IRuleExecutionHandler implementation from context", (Throwable)e);
        }
        return reh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendEvent(TreEventType eventType, Long titleId) {
        InitialContext context = null;
        QueueConnection queueConnection = null;
        QueueSession queueSession = null;
        Queue queue = null;
        QueueSender queueSender = null;
        try {
            context = new InitialContext();
            QueueConnectionFactory queueFactory = (QueueConnectionFactory)context.lookup("java:/JmsXA");
            queueConnection = queueFactory.createQueueConnection();
            queueSession = queueConnection.createQueueSession(true, 0);
            queue = (Queue)context.lookup("queue/EventQueue");
            queueSender = queueSession.createSender(queue);
            ObjectMessage message = queueSession.createObjectMessage();
            message.setStringProperty("eventType", eventType.getKey());
            message.setLongProperty("titleId", titleId.longValue());
            queueSender.send(queue, (Message)message);
        }
        catch (Exception e) {
            logger.error((Object)"Exception while sending the event", (Throwable)e);
        }
        finally {
            try {
                if (queueSession != null) {
                    queueSession.close();
                }
                if (context != null) {
                    context.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Failed to close the JMS session and context", (Throwable)e);
            }
        }
    }
}

