/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.core;

import com.tandbergtv.watchpoint.pmm.core.TitleValidationMessage;
import java.util.List;

public class TitleValidationException
extends Exception {
    private static final long serialVersionUID = 6522855923899413857L;
    private List<TitleValidationMessage> messages;

    public TitleValidationException(List<TitleValidationMessage> messages) {
        this(null, messages);
    }

    protected TitleValidationException(String errorMessage, List<TitleValidationMessage> messages) {
        super(errorMessage);
        this.setMessages(messages);
    }

    public void addMessage(String message, TitleValidationMessage.Type type) {
        this.addMessage(new TitleValidationMessage(message, type));
    }

    public void addMessage(TitleValidationMessage message) {
        this.messages.add(message);
    }

    public List<TitleValidationMessage> getMessages() {
        return this.messages;
    }

    private void setMessages(List<TitleValidationMessage> messages) {
        if (messages == null) {
            throw new IllegalArgumentException("messages list cannot be null");
        }
        this.messages = messages;
    }

    @Override
    public String getMessage() {
        StringBuffer buf = new StringBuffer();
        String message = super.getMessage();
        if (message != null) {
            buf.append(message);
            buf.append(" The validation messages: ");
        } else {
            buf.append("The title failed validation with the following messages: ");
        }
        String lineSeparator = System.getProperty("line.separator");
        buf.append(lineSeparator);
        for (TitleValidationMessage validationMessage : this.messages) {
            buf.append(validationMessage).append(lineSeparator);
        }
        return buf.toString();
    }
}

