/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.el.impl;

import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.jpdl.el.ELException;
import org.jbpm.jpdl.el.VariableResolver;

public class JbpmVariableResolver
implements VariableResolver {
    public Object resolveVariable(String name) throws ELException {
        ExecutionContext executionContext = ExecutionContext.currentExecutionContext();
        Object value = null;
        if ("taskInstance".equals(name)) {
            value = executionContext.getTaskInstance();
        } else if ("processInstance".equals(name)) {
            value = executionContext.getProcessInstance();
        } else if ("processDefinition".equals(name)) {
            value = executionContext.getProcessDefinition();
        } else if ("token".equals(name)) {
            value = executionContext.getToken();
        } else if ("taskMgmtInstance".equals(name)) {
            value = executionContext.getTaskMgmtInstance();
        } else if ("contextInstance".equals(name)) {
            value = executionContext.getContextInstance();
        } else if (executionContext.getTaskInstance() != null && executionContext.getTaskInstance().hasVariableLocally(name)) {
            value = executionContext.getTaskInstance().getVariable(name);
        } else {
            ContextInstance contextInstance = executionContext.getContextInstance();
            Token token = executionContext.getToken();
            value = contextInstance.getVariable(name, token);
        }
        return value;
    }
}

