/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.search;

import com.tandbergtv.metadatamanager.search.AssetSearchKey;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TreExpList;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TreExpNode;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TreExpValue;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TrePredicate;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TrePredicateRightValue;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TreTitleFilter;
import com.tandbergtv.watchpoint.pmm.title.search.ISearchCriteriaBuilder;
import com.tandbergtv.watchpoint.pmm.title.search.ParamType;
import com.tandbergtv.watchpoint.pmm.title.search.SearchField;
import com.tandbergtv.watchpoint.pmm.title.search.SearchFieldNode;
import com.tandbergtv.watchpoint.pmm.title.search.SearchFieldNodeList;
import com.tandbergtv.watchpoint.pmm.title.search.TitleSearchCriteriaBuilder;
import com.tandbergtv.workflow.driver.search.SearchOperator;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;

public class SearchCriteriaBuilder
implements ISearchCriteriaBuilder {
    private static String TITLE_SEARCH_PROPERTIES = "Title";
    private static String TITLE_SORT_PROPERTIES = "Title";

    @Override
    public SearchCriteria buildCriteria(TreTitleFilter titleFilter) {
        String searchProperty = "";
        SearchFieldNode searchFields = new SearchFieldNodeList();
        searchProperty = titleFilter.getIsSearchFieldMetadata() != false ? titleFilter.getSearchProperty() : TITLE_SEARCH_PROPERTIES;
        searchProperty = AssetSearchKey.ALL_DESCENDANT_FIELDS.toString();
        if (titleFilter.hasCriteria()) {
            if (titleFilter.getRootNode() instanceof TreExpValue) {
                searchFields = this.convertNodeToSearchField((TreExpValue)titleFilter.getRootNode());
            } else {
                TreExpList listNode = (TreExpList)titleFilter.getRootNode();
                this.populateSearchFields((SearchFieldNodeList)searchFields, listNode);
            }
        }
        String sortProperty = null;
        sortProperty = titleFilter.getIsSortFieldMetadata() != false ? AssetSearchKey.FIELDS.toString() : TITLE_SORT_PROPERTIES;
        SortingOrder order = null;
        if (titleFilter.getSortOrder() != null) {
            order = SortingOrder.valueOf((String)titleFilter.getSortOrder());
        }
        SearchCriteria criteria = TitleSearchCriteriaBuilder.getCriteria(titleFilter.getIsInternalSearch(), titleFilter.getExternalInstanceId(), searchProperty, searchFields, titleFilter.getStartIndex(), titleFilter.getMaxCount(), sortProperty, order, titleFilter.getSortColumnName());
        return criteria;
    }

    private void populateSearchFields(SearchFieldNodeList searchFields, TreExpList listNode) {
        if (listNode.getNodes() != null) {
            if (listNode.getOperator().equals("AND")) {
                searchFields.setOperator(SearchFieldNodeList.Operator.AND);
            } else if (listNode.getOperator().equals("OR")) {
                searchFields.setOperator(SearchFieldNodeList.Operator.OR);
            }
            for (TreExpNode node : listNode.getNodes()) {
                SearchFieldNode sfn = new SearchFieldNodeList();
                if (node instanceof TreExpValue) {
                    sfn = this.convertNodeToSearchField((TreExpValue)node);
                } else if (node instanceof TreExpList) {
                    this.populateSearchFields((SearchFieldNodeList)sfn, (TreExpList)node);
                }
                searchFields.addNode(sfn);
            }
        }
    }

    private SearchField convertNodeToSearchField(TreExpValue node) {
        SearchField sf = new SearchField();
        TrePredicate predicate = node.getPredicate();
        sf.setName(predicate.getFieldLeft());
        sf.setSectionName(predicate.getFieldLeftSectionType());
        if (predicate instanceof TrePredicateRightValue) {
            sf.setValues(((TrePredicateRightValue)predicate).getValue());
        }
        SearchOperator so = SearchOperator.valueOf((String)predicate.getOperator().getName());
        sf.setSearchOperator(so);
        if (so.equals((Object)SearchOperator.IN) || so.equals((Object)SearchOperator.NOTIN)) {
            sf.setParamType(ParamType.LIST);
        } else {
            sf.setParamType(ParamType.VALUE);
        }
        sf.setSearchType(this.getSearchType(predicate.getDataType()));
        sf.setIgnoreCase(predicate.getIgnoreCase());
        return sf;
    }

    private SearchType getSearchType(String dataType) {
        if (dataType != null) {
            if (dataType.equalsIgnoreCase("INTEGER") || dataType.equalsIgnoreCase("FLOAT") || dataType.equalsIgnoreCase("BOOLEAN")) {
                return SearchType.NUMERIC;
            }
            if (dataType.equalsIgnoreCase("TIME")) {
                return SearchType.STRING;
            }
            if (dataType.equalsIgnoreCase("DATE")) {
                return SearchType.DATE;
            }
            return SearchType.STRING;
        }
        return SearchType.STRING;
    }
}

