/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.model;

import com.tandbergtv.metadatamanager.factoryImpl.IdentifierFactory;
import com.tandbergtv.metadatamanager.model.AssetState;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldRevision;
import com.tandbergtv.metadatamanager.model.FieldTree;
import com.tandbergtv.metadatamanager.model.FieldTreeNode;
import com.tandbergtv.metadatamanager.model.File;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.metadatamanager.model.IAssetVisitor;
import com.tandbergtv.metadatamanager.model.IField;
import com.tandbergtv.metadatamanager.model.Item;
import com.tandbergtv.metadatamanager.model.NextRevision;
import com.tandbergtv.metadatamanager.model.ParentChildRelation;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.metadatamanager.model.SearchCriteria;
import com.tandbergtv.metadatamanager.specimpl.ttv.TTVId;
import com.tandbergtv.metadatamanager.util.AssetUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.log4j.Logger;

public abstract class Asset {
    private static final Logger logger = Logger.getLogger(Asset.class);
    private static final String _CUSTOMFIELD = "CustomField";
    private static final String _XPATH_SPLIT = "/";
    private static final String _ATTRIBUTE = "@";
    private static final String _TNS = "tns:";
    private static final String _TNS_FIELDS = "tns:Fields";
    private long id;
    private List<Field> fields = new ArrayList<Field>();
    private List<FieldRevision> fieldRevisions;
    private List<Field> allDescendantAssetFields;
    private Asset root = null;
    private FieldTree fieldTree;
    private int latestRevisionNumber = 1;
    private boolean isRevisionNumberUpdated = false;
    private Map<String, FieldRevision> fieldRevisionsMap;
    private Map<String, Field> fieldsMap;
    private Map<String, Field> fieldsMapByPathValue;
    private List<Relation> relations = new ArrayList<Relation>();
    private AssetState state = AssetState.ACTIVE;
    private String externalRevision;
    public static String EXTERNAL_INTERNAL_REVISION_DELIMITER = ".";

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public void setFields(List<Field> fields) {
        this.fields.clear();
        for (Field f : fields) {
            this.addField(f);
        }
    }

    public void addField(Field field) {
        Asset root = this.getRoot();
        if (root == null) {
            root = this;
        }
        field.setParentAsset(this);
        field.setRoot(root);
        this.fields.add(field);
    }

    public void addFieldRevision(FieldRevision fieldRevision, NextRevision nextRevision) {
        Asset root = this.getRoot();
        if (root == null) {
            root = this;
        }
        fieldRevision.setParentAsset(this);
        fieldRevision.setRoot(root);
        if (this.fieldRevisions == null) {
            this.fieldRevisions = new ArrayList<FieldRevision>();
        }
        this.fieldRevisions.add(fieldRevision);
        this.setLatestRevisionNumber(nextRevision.getRevisionNumber());
    }

    public void addChild(Asset child) {
        logger.debug((Object)("added a new child to asset(" + this.getId() + ")"));
        this.relations.add(new ParentChildRelation(this, child));
        child.root = this.root == null ? this : this.root;
        child.reRootFields();
    }

    public void addChild(Asset child, NextRevision nextRevision, boolean isChildNew) {
        this.relations.add(new ParentChildRelation(this, child, nextRevision));
        child.root = this.root == null ? this : this.root;
        child.reRootFields();
        this.setLatestRevisionNumber(nextRevision.getRevisionNumber());
        if (isChildNew) {
            AssetUtil.copyFieldsToFieldRevisions(child, nextRevision);
        }
    }

    private void reRootFields() {
        for (Field field : this.fields) {
            field.setRoot(this.root);
        }
        for (Relation relation : this.relations) {
            if (!(relation instanceof ParentChildRelation) || !relation.getOwnerAsset().equals(this)) continue;
            Asset asset = relation.getTargetAsset();
            asset.root = this.root;
            asset.reRootFields();
        }
    }

    public AssetState getState() {
        return this.state;
    }

    public boolean isActive() {
        return this.state == AssetState.ACTIVE;
    }

    public void setState(AssetState state) {
        this.state = state;
    }

    public void setState(boolean state) {
        if (state) {
            this.setState(AssetState.ACTIVE);
        } else {
            this.setState(AssetState.INACTIVE);
        }
    }

    public List<Field> getAllDescendantAssetFields() {
        return this.allDescendantAssetFields;
    }

    public List<Relation> getRelations() {
        return this.relations;
    }

    public void setRelations(List<Relation> relations) {
        this.relations = relations;
    }

    public Asset getRoot() {
        return this.root;
    }

    public TTVId getTTVId() {
        TTVId ttvId = (TTVId)IdentifierFactory.getTTVIdentifier();
        ttvId.setId(this.id);
        return ttvId;
    }

    public void setTTVId(TTVId id) {
        this.id = id.getId();
    }

    public Asset getAssetsParent(Asset a) {
        for (Relation r : this.relations) {
            Asset targetAsset = r.getTargetAsset();
            if (targetAsset.getId() == a.getId()) {
                return this;
            }
            Asset asset = targetAsset.getAssetsParent(a);
            if (asset == null) continue;
            return asset;
        }
        return null;
    }

    public Field getFirstField(String xpath) {
        for (Field f : this.fields) {
            if (!f.getTtvXPath().equals(xpath)) continue;
            return f;
        }
        return null;
    }

    public List<Field> getAllFieldsForXpath(String assetType, String xpath) {
        ArrayList<Field> list = new ArrayList<Field>();
        List<Asset> assets = this.getAllAssetsOfType(assetType);
        for (Asset child : assets) {
            list = child.getFieldsForXpath(xpath);
        }
        return list;
    }

    public List<Asset> getAllAssetsOfType(String assetType) {
        Item item;
        String type;
        List<Asset> assets = this.getTargetAssets(assetType);
        Asset a = new AssetUtil().unWrap(this);
        if (a instanceof Group) {
            Group group = (Group)a;
            String type2 = group.getType().toString();
            if (type2.toLowerCase().equals(assetType.toLowerCase())) {
                assets.add(a);
            }
        } else if (a instanceof Item && (type = (item = (Item)a).getType().toString()).toLowerCase().equals(assetType.toLowerCase())) {
            assets.add(a);
        }
        return assets;
    }

    private ArrayList<Field> getFieldsForXpath(String xpath) {
        ArrayList<Field> list = new ArrayList<Field>();
        for (Field f : this.getFields()) {
            if (!f.getTtvXPath().startsWith(xpath)) continue;
            list.add(f);
        }
        return list;
    }

    public List<FieldTree> getFieldTreeForXpath(String assetType, String xpath) {
        ArrayList<FieldTree> fieldTreeList = new ArrayList<FieldTree>();
        List<Asset> assets = this.getAllAssetsOfType(assetType);
        ArrayList<Object> fieldList = new ArrayList();
        for (Asset a : assets) {
            fieldList = a.getFieldsForXpath(xpath);
            if (fieldList == null || fieldList.size() <= 0) continue;
            FieldTree tree = new FieldTree(xpath, 1);
            this.populateFieldTree(tree, fieldList);
            fieldTreeList.add(tree);
        }
        return fieldTreeList;
    }

    public Asset getAsset(long id) {
        for (Relation relation : this.getRelations()) {
            Asset a = relation.getTargetAsset();
            if (a.getId() != id) continue;
            return a;
        }
        return null;
    }

    public Asset getAsset(SearchCriteria searchCriteria) {
        Asset returnAsset = null;
        for (Relation relation : this.getRelations()) {
            Asset targetAsset = relation.getTargetAsset();
            if (!targetAsset.meetCriteria(searchCriteria)) continue;
            returnAsset = targetAsset;
            break;
        }
        return returnAsset;
    }

    protected boolean meetCriteria(SearchCriteria searchCriteria) {
        boolean result = true;
        for (Map.Entry criteriaEntry : searchCriteria.entrySet()) {
            if (this.getFieldsMapByPathValue().containsKey((String)criteriaEntry.getKey() + (String)criteriaEntry.getValue())) continue;
            result = false;
            break;
        }
        return result;
    }

    public List<Asset> getTargetAssets(String targetAssetType) {
        ArrayList<Asset> targetAssetList = new ArrayList<Asset>();
        Asset ta = null;
        for (Relation relation : this.getRelations()) {
            Group group;
            String type;
            ta = new AssetUtil().unWrap(relation.getTargetAsset());
            if (ta instanceof Item) {
                Item item = (Item)ta;
                type = item.getType().toString();
                if (!type.toLowerCase().equals(targetAssetType.toLowerCase())) continue;
                targetAssetList.add(ta);
                continue;
            }
            if (!(ta instanceof Group) || !(type = (group = (Group)ta).getType().toString()).toLowerCase().equals(targetAssetType.toLowerCase())) continue;
            targetAssetList.add(ta);
        }
        return targetAssetList;
    }

    public <T extends Asset> List<T> getChildrenOfType(Class<T> clazz) {
        Asset ta = null;
        ArrayList<T> list = new ArrayList<T>();
        for (Relation relation : this.getRelations()) {
            ta = new AssetUtil().unWrap(relation.getTargetAsset());
            if (!clazz.isAssignableFrom(ta.getClass())) continue;
            list.add(clazz.cast(ta));
        }
        return list;
    }

    public List<Asset> getAllDescendantItems(boolean includeFiles) {
        ArrayList<Asset> list = new ArrayList<Asset>();
        this.walkAssetTree(this, list, includeFiles);
        return list;
    }

    private void walkAssetTree(Asset asset, List<Asset> list, boolean includeFiles) {
        if ((asset = new AssetUtil().unWrap(asset)) instanceof Item) {
            if (asset instanceof File) {
                if (includeFiles) {
                    list.add(asset);
                }
            } else {
                list.add(asset);
            }
        }
        for (Relation r : asset.getRelations()) {
            this.walkAssetTree(r.getTargetAsset(), list, includeFiles);
        }
    }

    public List<File> getDirectDescendantFiles() {
        ArrayList<File> list = new ArrayList<File>();
        this.getAllFilesRecursively(this, list, true);
        return list;
    }

    public List<File> getAllDescendantFiles() {
        ArrayList<File> list = new ArrayList<File>();
        this.getAllFilesRecursively(this, list, false);
        return list;
    }

    private void getAllFilesRecursively(Asset asset, List<File> list, boolean onlyFilesInThisAsset) {
        if ((asset = new AssetUtil().unWrap(asset)) instanceof File) {
            list.add((File)asset);
        }
        if (asset.getRelations() != null) {
            for (Relation r : asset.getRelations()) {
                Asset targetAsset = r.getTargetAsset();
                if (onlyFilesInThisAsset && !(targetAsset instanceof File)) continue;
                this.getAllFilesRecursively(targetAsset, list, onlyFilesInThisAsset);
            }
        }
    }

    public String toString() {
        String EOL = System.getProperty("line.separator");
        StringBuilder builder = new StringBuilder();
        builder.append("[" + this.id + "]");
        if (this.relations != null) {
            builder.append(", ").append(this.relations.size()).append(" relation(s)");
        }
        builder.append(EOL);
        for (Field field : this.fields) {
            builder.append("\t").append(field).append(EOL);
        }
        return builder.toString();
    }

    public void accept(IAssetVisitor visitor) {
        visitor.unWrap(this);
    }

    public boolean isInstance(Class clazz) {
        return this.getClass().isAssignableFrom(clazz);
    }

    public FieldTree getFieldTree() {
        this.fieldTree = new FieldTree();
        this.populateFieldTree(this.fieldTree, this.fields);
        return this.fieldTree;
    }

    public void setFieldTree(FieldTree fieldTree) {
        this.fieldTree = fieldTree;
        List<Field> fields = this.buildFieldListFromTree(fieldTree);
        this.setFields(fields);
    }

    private void populateFieldTree(FieldTree fieldTree, List<Field> fields) {
        for (Field f : fields) {
            FieldTreeNode rootNode;
            String xpath = f.getTtvXPath();
            String[] xpathParts = xpath.split(_XPATH_SPLIT);
            FieldTreeNode node = null;
            FieldTreeNode parentNode = null;
            parentNode = rootNode = fieldTree.getRootElement();
            for (int i = 0; i < xpathParts.length; ++i) {
                String xpathPart = xpathParts[i];
                if (xpathPart.equals("") || xpathPart.equals(_TNS_FIELDS)) continue;
                xpathPart = xpathPart.replace(_TNS, "");
                boolean isAttribute = false;
                if (!xpathPart.contains(_CUSTOMFIELD) && xpathPart.contains(_ATTRIBUTE)) {
                    isAttribute = true;
                    xpathPart = xpathPart.replace(_ATTRIBUTE, "");
                }
                Integer curIndex = 0;
                curIndex = isAttribute ? Integer.valueOf(1) : f.getIndices().get(i - 1);
                node = parentNode.getNode(xpathPart, curIndex);
                if (node == null) {
                    node = new FieldTreeNode();
                    node.setName(xpathPart);
                    node.setCurrentIndex(curIndex);
                    parentNode.addChild(node);
                }
                if (i == xpathParts.length - 1) {
                    node.setField(f);
                    node.setAttribute(isAttribute);
                }
                parentNode = node;
            }
        }
        this.sortTreeNodes(fieldTree.getRootElement(), new FieldTreeNodeComparator());
    }

    private void sortTreeNodes(FieldTreeNode fieldTreeNode, Comparator<FieldTreeNode> comparator) {
        Collections.sort(fieldTreeNode.getChildren(), comparator);
        for (FieldTreeNode child : fieldTreeNode.getChildren()) {
            this.sortTreeNodes(child, comparator);
        }
    }

    private List<Field> buildFieldListFromTree(FieldTree fieldTree) {
        ConcurrentLinkedQueue<FieldTreeNode> queue = new ConcurrentLinkedQueue<FieldTreeNode>();
        fieldTree.breadthFirstTraversal(queue);
        List<Field> fields = fieldTree.depthFirstTraversal();
        return fields;
    }

    public int getLatestRevisionNumber() {
        return this.latestRevisionNumber;
    }

    public void setLatestRevisionNumber(int latestRevisionNumber) {
        if (!this.isRevisionNumberUpdated) {
            this.setRevisionNumberUpdated(true);
        }
        this.latestRevisionNumber = latestRevisionNumber;
    }

    public boolean isRevisionNumberUpdated() {
        return this.isRevisionNumberUpdated;
    }

    public void setRevisionNumberUpdated(boolean isRevisionNumberUpdated) {
        this.isRevisionNumberUpdated = isRevisionNumberUpdated;
    }

    public List<FieldRevision> getFieldRevisions() {
        return this.fieldRevisions;
    }

    public void setFieldRevisions(List<FieldRevision> fieldRevisions) {
        this.fieldRevisions = fieldRevisions;
    }

    public String getAssetType() {
        String assetType = "";
        if (this instanceof Group) {
            Group g = (Group)this;
            assetType = g.getType();
        } else {
            Item i = (Item)this;
            assetType = i.getType();
        }
        return assetType;
    }

    public String getExternalRevision() {
        return this.externalRevision;
    }

    public void setExternalRevision(String externalRevision) {
        this.externalRevision = externalRevision;
    }

    public String getVersion() {
        String extRevision = "";
        if (this.getExternalRevision() != null) {
            extRevision = this.getExternalRevision().trim();
        }
        return extRevision + EXTERNAL_INTERNAL_REVISION_DELIMITER + this.getLatestRevisionNumber();
    }

    public List<Asset> getImmediateChildren() {
        ArrayList<Asset> immediateChildren = new ArrayList<Asset>();
        for (Relation r : this.relations) {
            immediateChildren.add(r.getTargetAsset());
        }
        return immediateChildren;
    }

    public Map<String, FieldRevision> getFieldRevisionsMap() {
        if (this.fieldRevisionsMap == null) {
            this.fieldRevisionsMap = new HashMap<String, FieldRevision>();
            this.constructIFieldMap(this.getFieldRevisions(), this.fieldRevisionsMap);
        }
        return this.fieldRevisionsMap;
    }

    public void setFieldRevisionsMap(Map<String, FieldRevision> fieldRevisionsMap) {
        this.fieldRevisionsMap = fieldRevisionsMap;
    }

    public Map<String, Field> getFieldsMap() {
        this.initFieldsMap();
        return this.fieldsMap;
    }

    public Map<String, Field> getFieldsMapByPathValue() {
        this.initFieldsMap();
        return this.fieldsMapByPathValue;
    }

    private void initFieldsMap() {
        if (this.fieldsMap == null && this.fieldsMapByPathValue == null) {
            this.fieldsMap = new HashMap<String, Field>();
            this.fieldsMapByPathValue = new HashMap<String, Field>();
            this.constructFieldMap(this.getFields(), this.fieldsMap, this.fieldsMapByPathValue);
        }
    }

    public void setFieldsMap(Map<String, Field> fieldsMap) {
        this.fieldsMap = fieldsMap;
    }

    protected <N extends IField> void constructIFieldMap(List<N> iFields, Map<String, N> iFieldsMap) {
        if (iFields == null) {
            return;
        }
        for (IField iField : iFields) {
            iFieldsMap.put(iField.getTtvXPath() + iField.getIndices(), iField);
        }
    }

    protected <N extends IField> void constructFieldMap(List<N> iFields, Map<String, N> iFieldsMap, Map<String, N> iFieldsMapByTTVXpath) {
        for (IField iField : iFields) {
            iFieldsMap.put(iField.getTtvXPath() + iField.getIndices(), iField);
            iFieldsMapByTTVXpath.put(iField.getTtvXPath() + iField.getValue(), iField);
        }
    }

    public void loadCompleteTree() {
        if (this.getFields() != null) {
            this.getFields().size();
        }
        if (this.getAllDescendantAssetFields() != null) {
            this.getAllDescendantAssetFields().size();
        }
        if (this.getFieldRevisions() != null) {
            this.getFieldRevisions().size();
        }
        for (Relation r : this.getRelations()) {
            r.getTargetAsset().loadCompleteTree();
        }
    }

    private static final class FieldTreeNodeComparator
    implements Comparator<FieldTreeNode> {
        private FieldTreeNodeComparator() {
        }

        @Override
        public int compare(FieldTreeNode o1, FieldTreeNode o2) {
            int compare = o1.getName().compareTo(o2.getName());
            if (compare == 0) {
                compare = o1.getCurrentIndex().compareTo(o2.getCurrentIndex());
            }
            return compare;
        }
    }
}

