/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.core;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.marvin.udt.TreEventType;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldName;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.metadatamanager.model.Item;
import com.tandbergtv.watchpoint.pmm.core.AssetsManager;
import com.tandbergtv.watchpoint.pmm.core.FatalTitleValidationException;
import com.tandbergtv.watchpoint.pmm.core.IPMMUIService;
import com.tandbergtv.watchpoint.pmm.core.ITitleStatusService;
import com.tandbergtv.watchpoint.pmm.core.PMMUtil;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.core.WorkflowNotifier;
import com.tandbergtv.watchpoint.pmm.entities.SaveResult;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitleService;
import com.tandbergtv.watchpoint.pmm.title.TitleStatusService;
import com.tandbergtv.watchpoint.pmm.util.ProgressStatusHelper;
import com.tandbergtv.watchpoint.pmm.util.RulesEngineFacade;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;

public class PMMUIService
implements IPMMUIService {
    private static final String UNMAPPED_ASSETS = "unmappedAssets";
    private static final Logger logger = Logger.getLogger(PMMUIService.class);
    private ITitleService titleService;
    private ITitleStatusService statusService;
    private static final String ACTION_MAP_ASSET = "?action=MAP_ASSET";

    public String getServiceName() {
        return "PMM UI Service";
    }

    public void start() {
        this.titleService = (ITitleService)ServiceRegistry.getDefault().lookup(ITitleService.class);
        this.statusService = new TitleStatusService();
    }

    public void stop() {
    }

    @Transactional
    public SaveResult createTitle(Title title, String sourceComponentName, String sourceEntityName, String sourceId) throws TitleValidationException {
        Title title2 = title;
        String string = sourceComponentName;
        String string2 = sourceEntityName;
        String string3 = sourceId;
        return (SaveResult)PMMUIService.createTitle_aroundBody1$advice(this, title2, string, string2, string3, TransactionEnforcer.aspectOf(), PMMUIService.class.getDeclaredMethod("createTitle", Title.class, String.class, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public SaveResult updateTitleMetadata(Title title, Long requestKey, String action, String listOfAssetIds, String sourceComponentName, String sourceEntityName, String sourceId) throws TitleValidationException {
        Title title2 = title;
        Long l = requestKey;
        String string = action;
        String string2 = listOfAssetIds;
        String string3 = sourceComponentName;
        String string4 = sourceEntityName;
        String string5 = sourceId;
        return (SaveResult)PMMUIService.updateTitleMetadata_aroundBody3$advice(this, title2, l, string, string2, string3, string4, string5, TransactionEnforcer.aspectOf(), PMMUIService.class.getDeclaredMethod("updateTitleMetadata", Title.class, Long.class, String.class, String.class, String.class, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    private Asset getAssetWithId(Title title, long id) {
        if (title.getAsset().getId() == id) {
            return title.getAsset();
        }
        for (Asset asset : title.getAsset().getAllDescendantItems(false)) {
            if (asset.getId() != id) continue;
            return asset;
        }
        return null;
    }

    private boolean hasOriginalFile(Asset asset) {
        for (com.tandbergtv.metadatamanager.model.File file : asset.getDirectDescendantFiles()) {
            if (!file.isOriginal()) continue;
            return true;
        }
        return false;
    }

    @Transactional
    public Title createTitleAsDraft(Title title, String sourceComponentName, String sourceEntityName, String sourceId) throws TitleValidationException {
        Title title2 = title;
        String string = sourceComponentName;
        String string2 = sourceEntityName;
        String string3 = sourceId;
        return (Title)PMMUIService.createTitleAsDraft_aroundBody5$advice(this, title2, string, string2, string3, TransactionEnforcer.aspectOf(), PMMUIService.class.getDeclaredMethod("createTitleAsDraft", Title.class, String.class, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public Title updateTitleMetadataAsDraft(Title title, String sourceComponentName, String sourceEntityName, String sourceId) throws TitleValidationException {
        Title title2 = title;
        String string = sourceComponentName;
        String string2 = sourceEntityName;
        String string3 = sourceId;
        return (Title)PMMUIService.updateTitleMetadataAsDraft_aroundBody7$advice(this, title2, string, string2, string3, TransactionEnforcer.aspectOf(), PMMUIService.class.getDeclaredMethod("updateTitleMetadataAsDraft", Title.class, String.class, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    private List<com.tandbergtv.metadatamanager.model.File> getDifferenceInFiles(Asset firstAsset, Asset secondAsset) {
        ArrayList<com.tandbergtv.metadatamanager.model.File> resultFiles = new ArrayList<com.tandbergtv.metadatamanager.model.File>();
        resultFiles.addAll(this.getDifferenceInChildFiles(firstAsset, secondAsset));
        List firstDescendantAssets = firstAsset.getAllDescendantItems(false);
        List secondDescendantAssets = secondAsset.getAllDescendantItems(false);
        if (firstDescendantAssets != null) {
            block0: for (Asset firstDescendantAsset : firstDescendantAssets) {
                if (secondDescendantAssets == null) continue;
                for (Asset secondDescendantAsset : secondDescendantAssets) {
                    if (firstDescendantAsset.getId() != secondDescendantAsset.getId()) continue;
                    resultFiles.addAll(this.getDifferenceInChildFiles(firstDescendantAsset, secondDescendantAsset));
                    continue block0;
                }
            }
        }
        return resultFiles;
    }

    private List<com.tandbergtv.metadatamanager.model.File> getDifferenceInChildFiles(Asset firstAsset, Asset secondAsset) {
        ArrayList<com.tandbergtv.metadatamanager.model.File> resultFiles = new ArrayList<com.tandbergtv.metadatamanager.model.File>();
        List firstAssetFiles = firstAsset.getChildrenOfType(com.tandbergtv.metadatamanager.model.File.class);
        List secondAssetFiles = secondAsset != null ? secondAsset.getChildrenOfType(com.tandbergtv.metadatamanager.model.File.class) : null;
        for (com.tandbergtv.metadatamanager.model.File firstAssetFile : firstAssetFiles) {
            if (secondAssetFiles != null) {
                boolean matchFound = false;
                for (com.tandbergtv.metadatamanager.model.File secondAssetFile : secondAssetFiles) {
                    if (firstAssetFile.getId() != secondAssetFile.getId() || firstAssetFile.getURL() == null || secondAssetFile.getURL() == null || !firstAssetFile.getURL().equals(secondAssetFile.getURL())) continue;
                    matchFound = true;
                    break;
                }
                if (matchFound) continue;
                resultFiles.add(firstAssetFile);
                continue;
            }
            resultFiles.add(firstAssetFile);
        }
        return resultFiles;
    }

    private void moveToUnmappedFilesDir(List<com.tandbergtv.metadatamanager.model.File> files, String dirName) {
        for (com.tandbergtv.metadatamanager.model.File file : files) {
            AssetsManager assetsManager;
            File javaFile;
            String url;
            Field urlField = file.getFirstField(FieldName.FILE_URL.toString());
            if (urlField == null || (url = urlField.getValue()) == null || !(javaFile = new File(url)).exists() || !url.startsWith((assetsManager = AssetsManager.getThreadLocalInstance()).getMappedFilesDirectory().getAbsolutePath())) continue;
            logger.debug((Object)("Attempting to move file [" + url + "] to unmapped files dircetory."));
            File movedFile = null;
            try {
                movedFile = AssetsManager.getThreadLocalInstance().moveToUnmappedFilesDirectory(javaFile, dirName);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to move file [" + url + "] from mapped files directory to unmapped files directory [" + assetsManager.getUnmappedFilesDirectory() + "]. ", e);
            }
            logger.debug((Object)("Moved file [" + url + "] to [" + movedFile.getAbsolutePath() + "]"));
        }
    }

    private void moveFilesToMappedFilesDir(Asset asset) throws RuntimeException {
        AssetsManager assetsManager = AssetsManager.getThreadLocalInstance();
        List files = asset.getAllDescendantFiles();
        if (files != null) {
            for (com.tandbergtv.metadatamanager.model.File file : files) {
                String url;
                logger.debug((Object)("File: " + file));
                Field urlField = file.getFirstField(FieldName.FILE_URL.toString());
                if (urlField == null || (url = urlField.getValue()) == null || !url.startsWith(assetsManager.getUnmappedFilesDirectory().getAbsolutePath())) continue;
                File movedFile = null;
                try {
                    logger.debug((Object)("Attempting to move file [" + url + "] to mapped files dircetory."));
                    movedFile = AssetsManager.getThreadLocalInstance().moveToMappedFilesDirectory(new File(url));
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to move file [" + url + "] from unmapped files directory to mapped files directory [" + assetsManager.getMappedFilesDirectory() + "]. ", e);
                }
                if (movedFile == null) continue;
                logger.debug((Object)("Moved file [" + url + "] to [" + movedFile.getAbsolutePath() + "]"));
                urlField.setValue(movedFile.getAbsolutePath());
            }
        }
    }

    private void sendProgressStatusForManuallyMappedFiles(Map<com.tandbergtv.metadatamanager.model.File, Asset> fileToAssetMap, Title title, String sourceComponentName, String sourceEntityName, String sourceId) {
        for (com.tandbergtv.metadatamanager.model.File file : fileToAssetMap.keySet()) {
            Asset asset = fileToAssetMap.get(file);
            if (asset instanceof Group) {
                this.statusService.sendMetadataReceivedStatus(title, sourceComponentName, sourceEntityName, sourceId);
                continue;
            }
            String titleName = ((Item)asset).getType();
            this.statusService.sendAssetReceivedStatus(title, titleName, sourceComponentName, sourceEntityName, sourceId);
        }
    }

    private Map<com.tandbergtv.metadatamanager.model.File, Asset> getNewlyAddedFiles(Asset incomingAsset, Asset existingAsset) {
        List existingDescendantAssets;
        HashMap<com.tandbergtv.metadatamanager.model.File, Asset> fileToAssetMap = new HashMap<com.tandbergtv.metadatamanager.model.File, Asset>();
        List<com.tandbergtv.metadatamanager.model.File> resultFiles = this.getDifferenceInChildFiles(incomingAsset, existingAsset);
        if (resultFiles.size() > 0) {
            for (com.tandbergtv.metadatamanager.model.File file : resultFiles) {
                fileToAssetMap.put(file, incomingAsset);
            }
        }
        List incomingDescendantAssets = incomingAsset.getAllDescendantItems(false);
        List list = existingDescendantAssets = existingAsset != null ? existingAsset.getAllDescendantItems(false) : null;
        if (incomingDescendantAssets != null) {
            block1: for (Asset incomingDescendantAsset : incomingDescendantAssets) {
                if (existingDescendantAssets != null) {
                    for (Asset existingDescendantAsset : existingDescendantAssets) {
                        if (incomingDescendantAsset.getId() != existingDescendantAsset.getId()) continue;
                        resultFiles = this.getDifferenceInChildFiles(incomingDescendantAsset, existingDescendantAsset);
                        if (resultFiles.size() <= 0) continue block1;
                        for (com.tandbergtv.metadatamanager.model.File file : resultFiles) {
                            fileToAssetMap.put(file, incomingDescendantAsset);
                        }
                        continue block1;
                    }
                    continue;
                }
                resultFiles = this.getDifferenceInChildFiles(incomingDescendantAsset, null);
                if (resultFiles.size() <= 0) continue;
                for (com.tandbergtv.metadatamanager.model.File file : resultFiles) {
                    fileToAssetMap.put(file, incomingDescendantAsset);
                }
            }
            if (existingDescendantAssets != null && incomingDescendantAssets.size() > existingDescendantAssets.size()) {
                HashSet<Long> existingAssetIds = new HashSet<Long>();
                for (Asset existingDescendantAsset : existingDescendantAssets) {
                    existingAssetIds.add(existingDescendantAsset.getId());
                }
                for (Asset incomingDescendantAsset : incomingDescendantAssets) {
                    if (existingAssetIds.contains(incomingDescendantAsset.getId()) || (resultFiles = this.getDifferenceInChildFiles(incomingDescendantAsset, null)).size() <= 0) continue;
                    for (com.tandbergtv.metadatamanager.model.File file : resultFiles) {
                        fileToAssetMap.put(file, incomingDescendantAsset);
                    }
                }
            }
        }
        return fileToAssetMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final /* synthetic */ SaveResult createTitle_aroundBody0(PMMUIService this_, Title title, String sourceComponentName, String sourceEntityName, String sourceId) {
        boolean success = false;
        try {
            this_.titleService.validate(title, false);
            Title nationalizedTitle = RulesEngineFacade.nationalize(title, TreEventType.TITLEUICREATE);
            List validationMessages = null;
            try {
                validationMessages = this_.titleService.validate(nationalizedTitle, false);
            }
            catch (TitleValidationException e) {
                String code = "PMMUI-001";
                String message = "Title made invalid after applying nationalization rules.";
                throw new FatalTitleValidationException(code, message, e.getMessages());
            }
            this_.moveFilesToMappedFilesDir(nationalizedTitle.getAsset());
            Map<com.tandbergtv.metadatamanager.model.File, Asset> fileToAssetMap = this_.getNewlyAddedFiles(nationalizedTitle.getAsset(), null);
            this_.titleService.save(nationalizedTitle);
            this_.statusService.sendStatus(nationalizedTitle, ProgressStatusHelper.NATIONALIZED, null, true, sourceComponentName, sourceEntityName, sourceId);
            this_.statusService.sendStatus(nationalizedTitle, ProgressStatusHelper.VALIDATION_SUCCESS, null, true, sourceComponentName, sourceEntityName, sourceId);
            this_.statusService.sendStatus(nationalizedTitle, ProgressStatusHelper.CREATED, null, true, sourceComponentName, sourceEntityName, sourceId);
            this_.sendProgressStatusForManuallyMappedFiles(fileToAssetMap, title, sourceComponentName, sourceEntityName, sourceId);
            RulesEngineFacade.sendUICreatedEvent(nationalizedTitle.getId());
            success = true;
            SaveResult saveResult = new SaveResult(nationalizedTitle, validationMessages);
            return saveResult;
        }
        finally {
            if (success) {
                AssetsManager.getThreadLocalInstance().commitTransaction();
            } else {
                AssetsManager.getThreadLocalInstance().rollbackTransaction();
            }
        }
    }

    private static final /* synthetic */ Object createTitle_aroundBody1$advice(PMMUIService this_, Title title, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc_aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional2 = transactional;
            return PMMUIService.createTitle_aroundBody0(this_, title, sourceComponentName, sourceEntityName, sourceId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional3 = transactional;
            SaveResult object = PMMUIService.createTitle_aroundBody0(this_, title, sourceComponentName, sourceEntityName, sourceId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final /* synthetic */ SaveResult updateTitleMetadata_aroundBody2(PMMUIService this_, Title title, Long requestKey, String action, String listOfAssetIds, String sourceComponentName, String sourceEntityName, String sourceId) {
        Title existingTitle = this_.titleService.getTitle(title.getId());
        Asset existingAsset = existingTitle.getAsset();
        boolean success = false;
        try {
            existingTitle.setAsset(title.getAsset());
            this_.titleService.validate(existingTitle, false);
            Title nationalizedTitle = RulesEngineFacade.nationalize(existingTitle, TreEventType.TITLEUIUPDATE);
            List validationMessages = null;
            try {
                validationMessages = this_.titleService.validate(nationalizedTitle, false);
            }
            catch (TitleValidationException e) {
                String code = "PMMUI-001";
                String message = "Title made invalid after applying nationalization rules.";
                throw new FatalTitleValidationException(code, message, e.getMessages());
            }
            List<com.tandbergtv.metadatamanager.model.File> deletedFiles = this_.getDifferenceInFiles(existingAsset, nationalizedTitle.getAsset());
            String dirName = PMMUtil.getPathFilterFieldValue(title.getAsset());
            this_.moveToUnmappedFilesDir(deletedFiles, dirName);
            this_.moveFilesToMappedFilesDir(title.getAsset());
            Map<com.tandbergtv.metadatamanager.model.File, Asset> fileToAssetMap = this_.getNewlyAddedFiles(nationalizedTitle.getAsset(), existingAsset);
            this_.titleService.save(nationalizedTitle);
            this_.statusService.sendStatus(nationalizedTitle, ProgressStatusHelper.NATIONALIZED, null, true, sourceComponentName, sourceEntityName, sourceId);
            this_.statusService.sendStatus(nationalizedTitle, ProgressStatusHelper.VALIDATION_SUCCESS, null, true, sourceComponentName, sourceEntityName, sourceId);
            this_.statusService.sendStatus(nationalizedTitle, ProgressStatusHelper.UPDATED, null, true, sourceComponentName, sourceEntityName, sourceId);
            this_.sendProgressStatusForManuallyMappedFiles(fileToAssetMap, nationalizedTitle, sourceComponentName, sourceEntityName, sourceId);
            RulesEngineFacade.sendUIUpdatedEvent(nationalizedTitle.getId());
            if (requestKey != null && action.equals(ACTION_MAP_ASSET)) {
                ArrayList<Long> requestedAssetIds = new ArrayList<Long>();
                for (String assetIdStr : listOfAssetIds.split(",")) {
                    requestedAssetIds.add(Long.valueOf(assetIdStr.trim()));
                }
                ArrayList<Asset> requestedAssetsWithOriginalFile = new ArrayList<Asset>();
                ArrayList<Asset> requestedAssetsWithoutOriginalFile = new ArrayList<Asset>();
                for (Long requestedAssetId : requestedAssetIds) {
                    Asset requestedAsset = this_.getAssetWithId(title, requestedAssetId);
                    if (this_.hasOriginalFile(requestedAsset)) {
                        requestedAssetsWithOriginalFile.add(requestedAsset);
                        continue;
                    }
                    requestedAssetsWithoutOriginalFile.add(requestedAsset);
                }
                if (requestedAssetsWithOriginalFile.size() == requestedAssetIds.size()) {
                    WorkflowNotifier wnThread = new WorkflowNotifier(requestKey);
                    wnThread.start();
                } else {
                    StringBuffer assetTypesSB = new StringBuffer();
                    boolean firstTime = true;
                    for (Asset asset : requestedAssetsWithoutOriginalFile) {
                        if (firstTime) {
                            firstTime = false;
                        } else {
                            assetTypesSB.append(", ");
                        }
                        assetTypesSB.append(asset.getAssetType());
                    }
                    HashMap<String, String> actionResponseMap = new HashMap<String, String>();
                    actionResponseMap.put(UNMAPPED_ASSETS, assetTypesSB.toString());
                    success = true;
                    SaveResult saveResult = new SaveResult(nationalizedTitle, validationMessages, actionResponseMap);
                    return saveResult;
                }
            }
            success = true;
            SaveResult saveResult = new SaveResult(nationalizedTitle, validationMessages);
            return saveResult;
        }
        finally {
            if (success) {
                AssetsManager.getThreadLocalInstance().commitTransaction();
            } else {
                AssetsManager.getThreadLocalInstance().rollbackTransaction();
            }
        }
    }

    private static final /* synthetic */ Object updateTitleMetadata_aroundBody3$advice(PMMUIService this_, Title title, Long requestKey, String action, String listOfAssetIds, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc_aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional2 = transactional;
            return PMMUIService.updateTitleMetadata_aroundBody2(this_, title, requestKey, action, listOfAssetIds, sourceComponentName, sourceEntityName, sourceId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional3 = transactional;
            SaveResult object = PMMUIService.updateTitleMetadata_aroundBody2(this_, title, requestKey, action, listOfAssetIds, sourceComponentName, sourceEntityName, sourceId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final /* synthetic */ Title createTitleAsDraft_aroundBody4(PMMUIService this_, Title title, String sourceComponentName, String sourceEntityName, String sourceId) {
        boolean success = false;
        try {
            this_.titleService.validate(title, true);
            this_.moveFilesToMappedFilesDir(title.getAsset());
            Map<com.tandbergtv.metadatamanager.model.File, Asset> fileToAssetMap = this_.getNewlyAddedFiles(title.getAsset(), null);
            this_.titleService.saveAsDraft(title);
            this_.sendProgressStatusForManuallyMappedFiles(fileToAssetMap, title, sourceComponentName, sourceEntityName, sourceId);
            success = true;
        }
        finally {
            if (success) {
                AssetsManager.getThreadLocalInstance().commitTransaction();
            } else {
                AssetsManager.getThreadLocalInstance().rollbackTransaction();
            }
        }
        return title;
    }

    private static final /* synthetic */ Object createTitleAsDraft_aroundBody5$advice(PMMUIService this_, Title title, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc_aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional2 = transactional;
            return PMMUIService.createTitleAsDraft_aroundBody4(this_, title, sourceComponentName, sourceEntityName, sourceId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional3 = transactional;
            Title object = PMMUIService.createTitleAsDraft_aroundBody4(this_, title, sourceComponentName, sourceEntityName, sourceId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final /* synthetic */ Title updateTitleMetadataAsDraft_aroundBody6(PMMUIService this_, Title title, String sourceComponentName, String sourceEntityName, String sourceId) {
        Title existingTitle = this_.titleService.getTitle(title.getId());
        Asset existingAsset = existingTitle.getAsset();
        boolean success = false;
        try {
            existingTitle.setAsset(title.getAsset());
            this_.titleService.validate(existingTitle, true);
            List<com.tandbergtv.metadatamanager.model.File> deletedFiles = this_.getDifferenceInFiles(existingAsset, title.getAsset());
            String dirName = PMMUtil.getPathFilterFieldValue(title.getAsset());
            this_.moveToUnmappedFilesDir(deletedFiles, dirName);
            this_.moveFilesToMappedFilesDir(existingTitle.getAsset());
            Map<com.tandbergtv.metadatamanager.model.File, Asset> fileToAssetMap = this_.getNewlyAddedFiles(existingTitle.getAsset(), existingAsset);
            this_.titleService.saveAsDraft(existingTitle);
            this_.sendProgressStatusForManuallyMappedFiles(fileToAssetMap, existingTitle, sourceComponentName, sourceEntityName, sourceId);
            success = true;
        }
        finally {
            if (success) {
                AssetsManager.getThreadLocalInstance().commitTransaction();
            } else {
                AssetsManager.getThreadLocalInstance().rollbackTransaction();
            }
        }
        return existingTitle;
    }

    private static final /* synthetic */ Object updateTitleMetadataAsDraft_aroundBody7$advice(PMMUIService this_, Title title, String sourceComponentName, String sourceEntityName, String sourceId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc_aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional2 = transactional;
            return PMMUIService.updateTitleMetadataAsDraft_aroundBody6(this_, title, sourceComponentName, sourceEntityName, sourceId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional3 = transactional;
            Title object = PMMUIService.updateTitleMetadataAsDraft_aroundBody6(this_, title, sourceComponentName, sourceEntityName, sourceId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }
}

