/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.job.referenceEvaluator;

import com.tandbergtv.watchpoint.pmm.entities.ContainerType;
import com.tandbergtv.watchpoint.pmm.entities.Context;
import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import com.tandbergtv.watchpoint.pmm.entities.JobParameter;
import com.tandbergtv.watchpoint.pmm.entities.Service;
import com.tandbergtv.watchpoint.pmm.job.callback.CallbackHelper;
import com.tandbergtv.watchpoint.pmm.job.referenceEvaluator.ParameterReferencePath;
import com.tandbergtv.watchpoint.pmm.job.referenceEvaluator.ReferenceEvaluator;
import com.tandbergtv.watchpoint.pmm.job.util.JobScheduleInfoConstants;
import com.tandbergtv.watchpoint.pmm.job.util.ParameterReferenceHelper;
import com.tandbergtv.watchpoint.pmm.util.ContextManager;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ServiceReferenceEvaluator
extends ReferenceEvaluator {
    private Logger logger = Logger.getLogger(ServiceReferenceEvaluator.class);
    private static String SERVICE_PARAMETER_REFERENCE_GROUP = "Service";
    private static String CONTAINER_CACHE_SERVICE_NAME = "Container Cache";

    @Override
    public void evaluate(Object entity, Map<String, Object> info) {
        this.logger.debug((Object)"Evaluating Service parameter references");
        List jobParameters = (List)info.get(JobScheduleInfoConstants.JOB_PARAMETERS);
        if (this.parametersHaveServiceReference(jobParameters)) {
            Context ctxt;
            Long contextId = (Long)info.get(JobScheduleInfoConstants.CONTEXTID);
            ICacheService containerCache = (ICacheService)ServiceRegistry.getDefault().lookup(CONTAINER_CACHE_SERVICE_NAME);
            IContainer container = (IContainer)containerCache.get((Serializable)contextId);
            if (container == null && (ctxt = ContextManager.getInstance().getContext(contextId.longValue())) != null) {
                container = ctxt.getContainer();
            }
            if (container == null) {
                this.logger.warn((Object)("No container found for contextId: " + contextId));
            } else if (container.getContainerType().equals((Object)ContainerType.SERVICE)) {
                this.substituteValues(info, jobParameters, (Service)container);
            } else {
                this.logger.error((Object)("Context: " + contextId + " points to a partner and parameter(s) have a reference to a service parameter reference."));
            }
        }
        if (this.successor != null) {
            this.successor.evaluate(entity, info);
        }
    }

    private boolean parametersHaveServiceReference(List<JobParameter> jobParameters) {
        for (JobParameter parameter : jobParameters) {
            String groupName;
            String propertyValue = parameter.getValue();
            if (!ParameterReferenceHelper.isParameterReference(propertyValue) || !(groupName = ParameterReferenceHelper.getGroupName(propertyValue)).equalsIgnoreCase(SERVICE_PARAMETER_REFERENCE_GROUP)) continue;
            return true;
        }
        return false;
    }

    private void substituteValues(Map<String, Object> info, List<JobParameter> jobParameters, Service service) {
        for (JobParameter parameter : jobParameters) {
            try {
                String groupName;
                String parameterReference = parameter.getValue();
                if (!ParameterReferenceHelper.isParameterReference(parameterReference) || !(groupName = ParameterReferenceHelper.getGroupName(parameterReference)).equalsIgnoreCase(SERVICE_PARAMETER_REFERENCE_GROUP)) continue;
                String property = ParameterReferenceHelper.getPropertyName(parameterReference);
                parameter.setValue(service.getValue(property));
            }
            catch (RuntimeException e) {
                IContainer container = CallbackHelper.getContainer(info);
                String errorMsg = "Error while subsituting value for: " + parameter.getValue() + " for job: " + info.get(JobScheduleInfoConstants.JOB_NAME) + " [" + container.getContainerType() + ":" + container.getContainerName() + "]";
                this.logger.warn((Object)errorMsg, (Throwable)e);
            }
        }
    }

    @Override
    public ParameterReferencePath getPath(String property) {
        if (this.successor != null) {
            return this.successor.getPath(property);
        }
        return null;
    }
}

