/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.job.timers;

import com.tandbergtv.watchpoint.pmm.entities.RuleParameter;
import com.tandbergtv.watchpoint.pmm.entities.RuleParameterDataType;
import com.tandbergtv.watchpoint.pmm.entities.RuleTypeParameter;
import com.tandbergtv.watchpoint.pmm.job.timers.ITimeRepresentation;
import com.tandbergtv.watchpoint.pmm.job.timers.TimerHelper;
import com.tandbergtv.watchpoint.pmm.job.timers.TimerResult;
import com.tandbergtv.watchpoint.pmm.job.ui.JobUIConstants;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class OnDate
implements ITimeRepresentation {
    private static final Logger logger = Logger.getLogger(OnDate.class);

    public Object getTime(List<RuleTypeParameter> ruleTypeParams, List<RuleParameter> params, Date startDate) {
        String jobDate = TimerHelper.getParameter(ruleTypeParams, params, RuleParameterDataType.DATE);
        String jobTime = TimerHelper.getParameter(ruleTypeParams, params, RuleParameterDataType.TIME);
        if (jobDate == null) {
            logger.error((Object)"Job date not specified.");
            return null;
        }
        try {
            SimpleDateFormat sf = new SimpleDateFormat(JobUIConstants.JOB_RULE_DATE_FORMAT);
            sf.setLenient(false);
            Date jDate = sf.parse(jobDate);
            Date jobStartDate = TimerHelper.getStartDateTime(jDate, jobTime);
            TimerResult result = new TimerResult(false, 0L, jobStartDate);
            return result;
        }
        catch (ParseException e) {
            logger.error((Object)("Error while getting time: " + e.toString()));
            return null;
        }
    }
}

