/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.conf;

import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import com.tandbergtv.watchpoint.pmm.title.conf.ComplexVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.SimpleVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.watchpoint.pmm.title.conf.SpecificationReader;
import com.tandbergtv.watchpoint.pmm.title.conf.SpecificationValidationException;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConf;
import com.tandbergtv.watchpoint.pmm.title.conf.Variable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginRegistry;

public class SpecificationBuilder {
    private static final Logger logger = Logger.getLogger(SpecificationBuilder.class);
    private static final String PLUGIN_ID = "com.tandbergtv.metadata";
    private static final String EXTENSION_POINT_ID = "provider";
    private static final String DEFINITION_PATH_PARAMETER = "definitionResource";
    private static final String TABLE_CONFIG_PARAMETER = "tableConfigurationResource";
    private static final String PREVIEW_STYLESHEET = "previewStylesheet";
    private static final String SPEC_ALIAS = "alias";
    private static final String BUNDLE_NAME = "resourcebundle";
    private static final String COMPLEX_DATATYPE_NAME = "complex";
    private static final String OPTIONAL_XPATH = "^((/tns:Fields/tns:CustomFields)|(/tns:Fields/tns:CustomFields-CL1_1))((/.*)?)$";
    private PluginManager pluginManager = null;
    private Map<String, ISpecHandler> spechandlers;

    private SpecificationBuilder(PluginManager pluginManager, Map<String, ISpecHandler> spechandlers) {
        this.pluginManager = pluginManager;
        this.spechandlers = spechandlers;
    }

    public static SpecificationBuilder createInstance(PluginManager pluginManager, Map<String, ISpecHandler> spechandlers) {
        return new SpecificationBuilder(pluginManager, spechandlers);
    }

    public Collection<Specification> buildSpecifications() {
        ArrayList<Specification> specifications = new ArrayList<Specification>();
        PluginRegistry pluginRegistry = this.pluginManager.getRegistry();
        ExtensionPoint point = pluginRegistry.getExtensionPoint(PLUGIN_ID, EXTENSION_POINT_ID);
        Collection extensions = point.getAvailableExtensions();
        for (Extension extension : extensions) {
            PluginDescriptor descriptor = extension.getDeclaringPluginDescriptor();
            try {
                if (!this.pluginManager.isPluginActivated(descriptor)) {
                    this.pluginManager.activatePlugin(descriptor.getId());
                }
                this.validateExtension(extension);
                Specification specification = this.buildSpecification(extension);
                this.validateSpecification(specification);
                specifications.add(specification);
                logger.debug((Object)("Added support for " + specification.getName()));
            }
            catch (Exception e) {
                String key = descriptor.getId() + ":" + extension.getId();
                logger.error((Object)("Failed to load title specification extension: " + key), (Throwable)e);
            }
        }
        this.removeDuplicates(specifications);
        return specifications;
    }

    private Specification buildSpecification(Extension extension) throws SpecificationValidationException {
        PluginDescriptor descriptor = extension.getDeclaringPluginDescriptor();
        PluginClassLoader classloader = this.pluginManager.getPluginClassLoader(descriptor);
        String definitionPath = extension.getParameter(DEFINITION_PATH_PARAMETER).valueAsString();
        InputStream stream = classloader.getResourceAsStream(definitionPath);
        Extension.Parameter bundleparameter = extension.getParameter(BUNDLE_NAME);
        ResourceBundle bundle = null;
        if (bundleparameter != null) {
            logger.debug((Object)("Bundle name " + bundleparameter.valueAsString()));
            bundle = ResourceBundle.getBundle(bundleparameter.valueAsString(), Locale.getDefault(), (ClassLoader)classloader);
        }
        SpecificationReader reader = new SpecificationReader();
        Specification specification = reader.unmarshal(stream, (ClassLoader)classloader, bundle);
        String tableConfigPath = extension.getParameter(TABLE_CONFIG_PARAMETER).valueAsString();
        specification.setDefinitionPath(definitionPath);
        specification.setTableConfigurationPath(tableConfigPath);
        this.setSpecHandler(specification, extension);
        String previewStylesheetPath = extension.getParameter(PREVIEW_STYLESHEET).valueAsString();
        specification.setPreviewStylesheetPath(previewStylesheetPath);
        String alias = extension.getParameter(SPEC_ALIAS).valueAsString();
        specification.setAlias(alias);
        return specification;
    }

    private void setSpecHandler(Specification specification, Extension extension) {
        Extension.Parameter alias = extension.getParameter(SPEC_ALIAS);
        if (alias == null) {
            logger.warn((Object)("No alias found, specification " + specification.getName() + " won't have an ISpecHandler"));
            return;
        }
        ISpecHandler sh = this.spechandlers.get(alias.valueAsString());
        if (sh != null) {
            logger.debug((Object)("Found " + sh.getClass().getName() + " for " + specification.getName()));
        }
        specification.setSpecHandler(sh);
    }

    private void validateExtension(Extension extension) throws SpecificationValidationException {
    }

    private void validateSpecification(Specification specification) throws SpecificationValidationException {
        ArrayList<String> errors = new ArrayList<String>();
        for (TitleConf titleConf : specification.getAllTitleConf()) {
            for (Variable variable : titleConf.getMetadata()) {
                this.validateVariable(specification, titleConf, variable, errors);
            }
        }
        if (errors.size() > 0) {
            StringBuilder errorBuf = new StringBuilder();
            String newLine = System.getProperty("line.separator");
            boolean first = true;
            for (String error : errors) {
                if (!first) {
                    errorBuf.append(newLine);
                } else {
                    first = false;
                }
                errorBuf.append(error);
            }
            throw new SpecificationValidationException(errorBuf.toString());
        }
    }

    private void validateVariable(Specification specification, TitleConf titleConf, Variable variable, ArrayList<String> errors) throws SpecificationValidationException {
        String msg;
        DataTypeMappingReader reader = DataTypeMappingReader.getInstance();
        String dataType = this.getVariableDataType(variable);
        String ttvDataType = reader.determineDataType(variable.getXPath());
        boolean hasChildren = reader.hasChildren(variable.getXPath());
        if (this.isBlank(ttvDataType) && hasChildren) {
            ttvDataType = COMPLEX_DATATYPE_NAME;
        }
        if (this.isBlank(ttvDataType) && this.dataTypeDefinitionRequired(variable)) {
            msg = "Specification: " + specification.getName() + ", Title: " + titleConf.getName() + " has " + dataType + " variable: " + variable.getName() + " [xpath=" + variable.getXPath() + "], but TTV Specification does not define a data type for this variable.";
            errors.add(msg);
        }
        if (!this.isBlank(ttvDataType) && !ttvDataType.equals(dataType)) {
            msg = "Specification: " + specification.getName() + ", Title: " + titleConf.getName() + " has " + dataType + " variable: " + variable.getName() + " [xpath=" + variable.getXPath() + "], but TTV Specification expects " + ttvDataType + " variable.";
            errors.add(msg);
        }
        if (variable instanceof ComplexVariable) {
            ComplexVariable complexVariable = (ComplexVariable)variable;
            for (Variable childVariable : complexVariable.getChildren()) {
                this.validateVariable(specification, titleConf, childVariable, errors);
            }
        }
    }

    private String getVariableDataType(Variable variable) {
        String dataType = null;
        if (variable instanceof ComplexVariable) {
            dataType = COMPLEX_DATATYPE_NAME;
        } else if (variable instanceof SimpleVariable) {
            dataType = ((SimpleVariable)variable).getDataType();
        }
        return dataType;
    }

    private boolean dataTypeDefinitionRequired(Variable variable) {
        boolean required = true;
        String xpath = variable.getXPath();
        if (xpath != null) {
            required = !Pattern.matches(OPTIONAL_XPATH, xpath);
        }
        return required;
    }

    private boolean isBlank(String value) {
        return value == null || value.trim().length() == 0;
    }

    private void removeDuplicates(Collection<Specification> allSpecifications) {
        HashMap<String, ArrayList<Specification>> specificationNameMap = new HashMap<String, ArrayList<Specification>>();
        for (Specification specification : allSpecifications) {
            String name = specification.getName();
            ArrayList<Specification> specifications = (ArrayList<Specification>)specificationNameMap.get(name);
            if (specifications == null) {
                specifications = new ArrayList<Specification>();
                specificationNameMap.put(name, specifications);
            }
            specifications.add(specification);
        }
        for (String name : specificationNameMap.keySet()) {
            List specifications = (List)specificationNameMap.get(name);
            if (specifications.size() <= 1) continue;
            allSpecifications.removeAll(specifications);
            logger.warn((Object)("Detected duplicate specifications(" + specifications.size() + ") with same name: " + name + ", ignoring all specifications with this name."));
        }
    }
}

