/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.util;

import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.Service;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerManagement;
import com.tandbergtv.watchpoint.pmm.partner.PartnerManager;
import com.tandbergtv.watchpoint.pmm.service.IServiceManagement;
import com.tandbergtv.watchpoint.pmm.service.ServiceManager;
import com.tandbergtv.workflow.core.service.cache.CacheService;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class ContainerCache
extends CacheService<IContainer> {
    private static String SERVICE_NAME = "Container Cache";
    private static int THREAD_FACTORY_THREAD_COUNT = 2;
    public static int MAX_CONTAINER_COUNT = 250;
    private Logger logger = Logger.getLogger(ContainerCache.class);
    private static ICacheService<IContainer> instance;
    private ScheduledThreadPoolExecutor executor;

    public ContainerCache() {
        super(SERVICE_NAME, MAX_CONTAINER_COUNT);
    }

    public static synchronized ICacheService<IContainer> getInstance() {
        if (instance == null) {
            instance = new ContainerCache();
        }
        return instance;
    }

    public void start() {
        this.logger.debug((Object)"Starting Container Cache service.");
        super.start();
        this.logger.debug((Object)"Loading partners and services in the background now.");
        this.executor = new ScheduledThreadPoolExecutor(THREAD_FACTORY_THREAD_COUNT);
        this.populatePartners();
        this.populateServices();
        this.logger.debug((Object)"Done starting the cache.");
    }

    public void stop() {
        this.executor.shutdown();
    }

    private List<Partner> populatePartners() {
        Callable<List<Partner>> starterThread = new Callable<List<Partner>>(){

            @Override
            public List<Partner> call() throws Exception {
                IPartnerManagement partnerMgr = PartnerManager.getInstance();
                List partners = partnerMgr.getAllActivePartners();
                ContainerCache.this.logger.debug((Object)("Got " + partners.size() + " partners from db."));
                for (Partner p : partners) {
                    ContainerCache.this.add(Long.valueOf(p.getContainerContextId()), p);
                }
                ContainerCache.this.logger.debug((Object)("Cache has " + ContainerCache.this.count() + " containers."));
                return partners;
            }
        };
        this.executor.schedule(starterThread, 0L, TimeUnit.MILLISECONDS);
        return null;
    }

    private List<Service> populateServices() {
        Callable<List<Service>> starterThread = new Callable<List<Service>>(){

            @Override
            public List<Service> call() throws Exception {
                IServiceManagement serviceMgr = ServiceManager.getInstance();
                List services = serviceMgr.getAllActiveServices();
                ContainerCache.this.logger.debug((Object)("Got " + services.size() + " services from db."));
                for (Service s : services) {
                    ContainerCache.this.add(Long.valueOf(s.getContainerContextId()), s);
                }
                ContainerCache.this.logger.debug((Object)("Cache has " + ContainerCache.this.count() + " containers."));
                return services;
            }
        };
        this.executor.schedule(starterThread, 0L, TimeUnit.MILLISECONDS);
        return null;
    }
}

