/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template;

import com.tandbergtv.workflow.core.Selector;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.IMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceEvent;
import com.tandbergtv.workflow.core.service.ServiceEvents;
import com.tandbergtv.workflow.core.service.cache.CacheService;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.driver.DriverException;
import com.tandbergtv.workflow.driver.DriverRuntimeException;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import com.tandbergtv.workflow.driver.template.ArchivalService;
import com.tandbergtv.workflow.driver.template.IArchivalService;
import com.tandbergtv.workflow.driver.template.SelectorExistsException;
import com.tandbergtv.workflow.driver.template.event.TemplateEvent;
import com.tandbergtv.workflow.driver.template.event.TemplateEvents;
import java.io.File;
import java.io.Serializable;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;

public class TemplateLoaderService
implements ITemplateLoaderService,
IColleague {
    private static final String SERVICE_NAME = "Template Loader Service";
    private ICacheService<WorkflowTemplate> cache;
    private IArchivalService archiver;
    private ISchedulerService<Void> scheduler;
    private int max;
    private SessionFactory factory;
    private static final String REJECTED = "rejected";
    private static final String IMPORTED = "imported";
    private static final Logger logger = Logger.getLogger(TemplateLoaderService.class);

    public TemplateLoaderService(Properties properties, SessionFactory factory) {
        this.max = Integer.parseInt(properties.getProperty("template.max.count"));
        this.factory = factory;
        ResourceBundle bundle = ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".service");
        int size = Integer.parseInt(bundle.getString("template.cache.size"));
        String name = bundle.getString("template.cache.name");
        this.cache = new CacheService(name, size);
        this.scheduler = new Scheduler("template", 1, 1);
        this.archiver = new ArchivalService(this.scheduler);
    }

    @Override
    public List<String> getAllTemplateNames() {
        List<WorkflowTemplate> templates = this.getAllTemplates();
        Collections.sort(templates, new TemplateComparator());
        ArrayList<String> names = new ArrayList<String>();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (WorkflowTemplate template : templates) {
            String name = template.getName();
            if (map.containsKey(name)) continue;
            map.put(name, template.getVersion());
            names.add(template.getFullName());
        }
        return names;
    }

    @Override
    public List<WorkflowTemplate> getAllTemplates() {
        ArrayList<WorkflowTemplate> templates = new ArrayList<WorkflowTemplate>();
        for (Serializable key : this.getCache().getKeys()) {
            templates.add((WorkflowTemplate)this.getCache().get(key));
        }
        return templates;
    }

    @Override
    public WorkflowTemplate getTemplate(Serializable id) {
        return (WorkflowTemplate)this.getCache().get(id);
    }

    @Override
    public WorkflowTemplate getTemplateByFullName(String name) {
        List<WorkflowTemplate> templates = this.getAllTemplates();
        Collections.sort(templates, new TemplateComparator());
        for (WorkflowTemplate template : templates) {
            if (!name.equals(template.getFullName())) continue;
            return template;
        }
        return null;
    }

    @Override
    public WorkflowTemplate getTemplateByName(String name) {
        List<WorkflowTemplate> templates = this.getAllTemplates();
        Collections.sort(templates, new TemplateComparator());
        for (WorkflowTemplate template : templates) {
            if (!name.equals(template.getName())) continue;
            return template;
        }
        return null;
    }

    @Override
    public List<WorkflowTemplate> getLatestTemplates() {
        List<WorkflowTemplate> templates = this.getAllTemplates();
        Collections.sort(templates, new TemplateComparator());
        ArrayList<WorkflowTemplate> list = new ArrayList<WorkflowTemplate>();
        HashSet<String> names = new HashSet<String>();
        for (WorkflowTemplate template : templates) {
            String name = template.getName();
            if (names.contains(name)) continue;
            names.add(name);
            list.add(template);
        }
        return list;
    }

    @Override
    public List<WorkflowTemplate> getPreviousVersions(WorkflowTemplate template) {
        LinkedList<WorkflowTemplate> templates = new LinkedList<WorkflowTemplate>();
        int version = template.getVersion();
        for (WorkflowTemplate t : this.getAllTemplates()) {
            if (!t.getName().equals(template.getName()) || t.getVersion() >= version) continue;
            templates.add(t);
        }
        return templates;
    }

    @Override
    public WorkflowTemplate getTemplateBySelectorKey(String selectorKey) {
        for (WorkflowTemplate template : this.getLatestTemplates()) {
            for (Selector selector : template.getSelectorKeys()) {
                if (!selector.getSelectionKey().equals(selectorKey)) continue;
                return template;
            }
        }
        throw new DriverRuntimeException("Failed to find template for selector key " + selectorKey);
    }

    @Override
    public void save(WorkflowTemplate template) throws DriverException {
        this.checkVersion(template);
        this.checkLicense(template);
        WorkflowTemplate previous = this.getLatestTemplate(template.getName());
        Session session = null;
        Transaction t = null;
        try {
            session = this.getSession();
            t = session.beginTransaction();
            if (previous != null) {
                for (Selector selector : previous.getSelectorKeys()) {
                    template.addSelectorKey(new Selector(selector.getSelectionKey(), template));
                }
                previous.removeSelectorKeys();
                session.saveOrUpdate((Object)previous);
                session.flush();
            }
            session.saveOrUpdate((Object)template);
            t.commit();
            logger.info((Object)("Saved template " + template));
            this.fireEvent(template, TemplateEvents.CREATED);
            this.cache(template);
            this.archiver.run(template);
        }
        catch (Exception e) {
            if (t != null) {
                t.rollback();
            }
            throw new DriverException("Failed to create template " + template, e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public void update(WorkflowTemplate template) throws DriverException {
        Session session = null;
        Transaction t = null;
        try {
            session = this.getSession();
            t = session.beginTransaction();
            session.saveOrUpdate((Object)template);
            t.commit();
            logger.debug((Object)("Updated template " + template));
            this.fireEvent(template, TemplateEvents.UPDATED);
        }
        catch (Exception e) {
            if (t != null) {
                t.rollback();
            }
            throw new DriverException("Failed to update template " + template, e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public void delete(WorkflowTemplate template) throws DriverException {
        logger.info((Object)("Deleting template " + template));
        Session session = null;
        Transaction t = null;
        try {
            session = this.getSession();
            t = session.beginTransaction();
            Statement statement = session.connection().createStatement();
            statement.executeUpdate("update JBPM_PROCESSDEFINITION set PROCESSDEFINITIONTYPEID = 1 where ID_ = " + template.getId());
            t.commit();
            this.remove(template);
            this.fireEvent(template, TemplateEvents.DELETED);
        }
        catch (Exception e) {
            if (t != null) {
                t.rollback();
            }
            throw new DriverException("Failed to delete template " + template, e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public void addSelector(Serializable id, Selector selector) throws DriverException {
        for (WorkflowTemplate t : this.getAllTemplates()) {
            for (Selector s : t.getSelectorKeys()) {
                if (!s.getSelectionKey().equals(selector.getSelectionKey())) continue;
                throw new SelectorExistsException("Key " + selector.getSelectionKey() + " is mapped to template " + t.getFullName());
            }
        }
        WorkflowTemplate template = this.getTemplate(id);
        if (template == null) {
            throw new DriverException("Failed to find template [" + id + "]");
        }
        template.addSelectorKey(selector);
        this.update(template);
    }

    @Override
    public void removeSelector(Serializable id, Selector selector) throws DriverException {
        WorkflowTemplate template = this.getTemplate(id);
        selector.setTemplate(template);
        template.removeSelectorKey(selector);
        this.update(template);
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void start() {
        this.cache.start();
        DefaultMediator.getInstance().register((IColleague)this);
        this.scheduler.schedule((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    logger.debug((Object)"Loading cache...");
                    Collection templates = TemplateLoaderService.this.getAll();
                    for (WorkflowTemplate template : templates) {
                        TemplateLoaderService.this.cache(template);
                    }
                    logger.info((Object)("Loaded " + TemplateLoaderService.this.cache.count() + " templates"));
                    DefaultMediator.getInstance().sendAsync((WorkflowEvent)new ServiceEvent((Service)TemplateLoaderService.this, ServiceEvents.STARTED));
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to load templates", (Throwable)e);
                }
                TemplateLoaderService.this.archiver.start();
                return null;
            }
        });
    }

    public void stop() {
        this.cache.stop();
        this.archiver.stop();
        this.scheduler.stop();
        IMediator mediator = DefaultMediator.getInstance();
        mediator.unregister((IColleague)this);
        mediator.sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STOPPED));
    }

    public String getColleagueName() {
        return this.getServiceName();
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.LOW;
    }

    public void receive(WorkflowEvent event) {
        if (!(event instanceof TemplateEvent)) {
            return;
        }
        TemplateEvent e = (TemplateEvent)((Object)TemplateEvent.class.cast(event));
        logger.debug((Object)(e.getTemplate() + ", " + (Object)((Object)e.getType())));
        switch (e.getType()) {
            case COMPILED: {
                this.ingest((File)e.getSource(), e.getTemplate());
                break;
            }
            case COMPILE_ERROR: {
                File file = (File)e.getSource();
                String dir = file.getParentFile().getParentFile() + File.separator + REJECTED;
                this.move(dir, file);
                break;
            }
        }
    }

    private void cache(WorkflowTemplate template) {
        logger.debug((Object)("Adding to cache " + template));
        this.getCache().add((Serializable)Long.valueOf(template.getId()), (Object)template);
        this.fireEvent(template, TemplateEvents.CACHED);
    }

    private void remove(WorkflowTemplate template) {
        logger.debug((Object)("Removing from cache " + template));
        this.getCache().remove((Serializable)Long.valueOf(template.getId()));
    }

    private ICacheService<WorkflowTemplate> getCache() {
        return this.cache;
    }

    private void checkVersion(WorkflowTemplate template) throws DriverException {
        WorkflowTemplate latest = this.getLatestTemplate(template.getName());
        if (latest != null && latest.getVersion() >= template.getVersion()) {
            throw new DriverException("Template " + template + " - version must exceed " + latest.getVersion());
        }
    }

    private void checkLicense(WorkflowTemplate template) throws DriverException {
        int count = this.getLicenseCount();
        for (WorkflowTemplate t : this.getLatestTemplates()) {
            if (!t.getName().equals(template.getName())) continue;
            return;
        }
        if (this.getLatestTemplates().size() >= count) {
            throw new DriverException("License unavailable for template " + template.getFullName() + ", limit = " + count);
        }
    }

    private WorkflowTemplate getLatestTemplate(String name) {
        List<WorkflowTemplate> templates = this.getAllTemplates();
        Collections.sort(templates, new TemplateComparator());
        for (WorkflowTemplate template : templates) {
            if (!name.equals(template.getName())) continue;
            return template;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<WorkflowTemplate> getAll() {
        List list = new ArrayList();
        Session session = null;
        try {
            session = this.getSession();
            list = session.createCriteria(WorkflowTemplate.class).list();
        }
        finally {
            this.closeSession(session);
        }
        TreeSet<WorkflowTemplate> templates = new TreeSet<WorkflowTemplate>(new Comparator<WorkflowTemplate>(){

            @Override
            public int compare(WorkflowTemplate o1, WorkflowTemplate o2) {
                return o1.getCreateDate().compareTo(o2.getCreateDate());
            }
        });
        templates.addAll(list);
        return templates;
    }

    private void ingest(final File file, final WorkflowTemplate template) {
        this.scheduler.schedule((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                block3: {
                    String path = file.getAbsolutePath();
                    try {
                        TemplateLoaderService.this.save(template);
                        String dir = file.getParentFile().getParentFile() + File.separator + TemplateLoaderService.IMPORTED;
                        if (!TemplateLoaderService.this.move(dir, file)) {
                            logger.warn((Object)("Failed to move file " + file.getAbsolutePath() + " to " + dir));
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)("Failed to ingest template " + path), (Throwable)e);
                        String dir = file.getParentFile().getParentFile() + File.separator + TemplateLoaderService.REJECTED;
                        if (TemplateLoaderService.this.move(dir, file)) break block3;
                        logger.warn((Object)("Failed to move file " + path + " to " + dir));
                    }
                }
                return null;
            }
        });
    }

    private boolean move(String dir, File file) {
        String time = new SimpleDateFormat("yyyy-MM-dd-HHmmSS").format(new Date());
        return file.renameTo(new File(dir + File.separator + file.getName().replace(".", "-") + "-" + time + ".xml"));
    }

    private void fireEvent(WorkflowTemplate template, TemplateEvents e) {
        DefaultMediator.getInstance().sendAsync((WorkflowEvent)new TemplateEvent(this, template, e));
    }

    private int getLicenseCount() {
        return this.max;
    }

    private Session getSession() {
        return this.factory.openSession();
    }

    private void closeSession(Session session) {
        if (session != null) {
            session.close();
        }
    }

    class TemplateComparator
    implements Comparator<WorkflowTemplate> {
        TemplateComparator() {
        }

        @Override
        public int compare(WorkflowTemplate t1, WorkflowTemplate t2) {
            if (t1.getName().equals(t2.getName())) {
                return t2.getVersion() - t1.getVersion();
            }
            return t1.getName().compareTo(t2.getName());
        }
    }
}

