/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.expr.BreakInstr;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.Block;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.UserFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.EmptySequence;

public final class IterateInstr
extends Instruction {
    private Expression select;
    private Expression action;
    private Expression finallyExp;

    public IterateInstr(Expression select, Expression action, Expression finallyExp) {
        this.select = select;
        this.action = action;
        this.finallyExp = finallyExp == null ? new Literal(EmptySequence.getInstance()) : finallyExp;
        this.adoptChildExpression(select);
        this.adoptChildExpression(action);
        this.adoptChildExpression(finallyExp);
    }

    public Expression getActionExpression() {
        return this.action;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.select = visitor.simplify(this.select);
        this.action = visitor.simplify(this.action);
        this.finallyExp = visitor.simplify(this.finallyExp);
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        this.select = visitor.typeCheck(this.select, contextItemType);
        this.adoptChildExpression(this.select);
        this.action = visitor.typeCheck(this.action, this.select.getItemType(th));
        this.adoptChildExpression(this.action);
        this.finallyExp = visitor.typeCheck(this.finallyExp, null);
        this.adoptChildExpression(this.finallyExp);
        if (Literal.isEmptySequence(this.select)) {
            return this.select;
        }
        if (Literal.isEmptySequence(this.action)) {
            return this.action;
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        this.select = visitor.optimize(this.select, contextItemType);
        this.adoptChildExpression(this.select);
        this.action = this.action.optimize(visitor, this.select.getItemType(th));
        this.adoptChildExpression(this.action);
        this.finallyExp = this.finallyExp.optimize(visitor, this.select.getItemType(th));
        this.adoptChildExpression(this.finallyExp);
        if (Literal.isEmptySequence(this.select)) {
            return this.select;
        }
        if (Literal.isEmptySequence(this.action)) {
            return this.action;
        }
        return this;
    }

    public final ItemType getItemType(TypeHierarchy th) {
        if (Literal.isEmptySequence(this.finallyExp)) {
            return this.action.getItemType(th);
        }
        return Type.getCommonSuperType(this.action.getItemType(th), this.finallyExp.getItemType(th), th);
    }

    public final boolean createsNewNodes() {
        return (this.action.getSpecialProperties() & this.finallyExp.getSpecialProperties() & 0x400000) == 0;
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet target = this.select.addToPathMap(pathMap, pathMapNodeSet);
        return this.action.addToPathMap(pathMap, target);
    }

    public int computeDependencies() {
        int dependencies = 0;
        dependencies |= this.select.getDependencies();
        dependencies |= this.action.getDependencies() & 0xFFFFFFE1;
        return dependencies |= this.finallyExp.getDependencies() & 0xFFFFFFE1;
    }

    protected void promoteInst(PromotionOffer offer) throws XPathException {
        this.select = this.doPromotion(this.select, offer);
        this.action = this.doPromotion(this.action, offer);
        this.finallyExp = this.doPromotion(this.finallyExp, offer);
    }

    public Iterator iterateSubExpressions() {
        ArrayList<Expression> sub = new ArrayList<Expression>(8);
        sub.add(this.select);
        sub.add(this.action);
        sub.add(this.finallyExp);
        return sub.iterator();
    }

    public boolean hasLoopingSubexpression(Expression child) {
        return child == this.action;
    }

    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.select == original) {
            this.select = replacement;
            found = true;
        }
        if (this.action == original) {
            this.action = replacement;
            found = true;
        }
        if (this.finallyExp == original) {
            this.finallyExp = replacement;
            found = true;
        }
        return found;
    }

    public int getImplementationMethod() {
        return 4;
    }

    public void checkPermittedContents(SchemaType parentType, StaticContext env, boolean whole) throws XPathException {
        this.action.checkPermittedContents(parentType, env, false);
    }

    public Expression copy() {
        throw new UnsupportedOperationException("copy");
    }

    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        block3: {
            UserFunction fn;
            SequenceIterator iter = this.select.iterate(context);
            XPathContextMajor c2 = context.newContext();
            c2.setOrigin(this);
            c2.setCurrentIterator(iter);
            c2.setCurrentTemplateRule(null);
            do {
                Item item;
                if ((item = iter.next()) == null) {
                    if (this.action instanceof Block) {
                        c2.setCurrentIterator(null);
                        ((Block)this.action).processLocalParams(c2);
                    }
                    break block3;
                }
                this.action.process(c2);
            } while ((fn = c2.getTailCallFunction()) == null || !fn.getFunctionName().equals(BreakInstr.SAXON_BREAK));
            iter.close();
            return null;
        }
        this.finallyExp.process(context);
        return null;
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("saxonIterate");
        this.select.explain(out);
        out.startSubsidiaryElement("return");
        this.action.explain(out);
        out.endSubsidiaryElement();
        if (!Literal.isEmptySequence(this.finallyExp)) {
            out.startSubsidiaryElement("saxonFinally");
            this.finallyExp.explain(out);
            out.endSubsidiaryElement();
        }
        out.endElement();
    }
}

