/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import java.util.Collection;
import java.util.Map;
import org.jboss.aop.Advised;
import org.jboss.web.tomcat.service.session.ClusteredManager;
import org.jboss.web.tomcat.service.session.ClusteredSession;
import org.jboss.web.tomcat.service.session.Util;

class FieldBasedClusteredSession
extends ClusteredSession {
    private static final long serialVersionUID = 8347544395334247623L;
    protected static final String info = "FieldBasedClusteredSession/1.0";
    protected transient boolean needRegion_ = true;

    public FieldBasedClusteredSession(ClusteredManager manager) {
        super(manager);
    }

    public String getInfo() {
        return info;
    }

    public void recycle() {
        super.recycle();
        this.needRegion_ = true;
    }

    public boolean needRegionForSession() {
        return this.needRegion_;
    }

    public boolean hasRegionForSession() {
        return !this.needRegion_;
    }

    public void createdRegionForSession() {
        this.needRegion_ = false;
    }

    protected boolean isMutable(Object attribute) {
        boolean pojo = attribute instanceof Advised;
        boolean mutable = !pojo && super.isMutable(attribute);
        return mutable;
    }

    protected Object removeAttributeInternal(String name, boolean localCall, boolean localOnly) {
        if (localCall && !replicationExcludes.contains(name)) {
            if (localOnly) {
                this.getDistributedCacheManager().removeAttributeLocal(this.getRealId(), name);
            } else {
                this.getDistributedCacheManager().removeAttribute(this.getRealId(), name);
            }
            this.sessionAttributesDirty();
        }
        return this.getAttributesInternal().remove(name);
    }

    protected boolean canAttributeBeReplicated(Object attribute) {
        return attribute == null || Util.checkPojoType(attribute);
    }

    protected Object setAttributeInternal(String key, Object value) {
        if (!replicationExcludes.contains(key)) {
            String myRealId = this.getRealId();
            this.getDistributedCacheManager().putAttribute(myRealId, key, value);
            if (value instanceof Map || value instanceof Collection) {
                value = this.getDistributedCacheManager().getAttribute(myRealId, key);
            }
            this.sessionAttributesDirty();
        }
        return this.getAttributesInternal().put(key, value);
    }
}

