package com.tandbergtv.cms.portal.ui.widget.client;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class Table extends Composite implements View {
	private IDataProvider dataProvider;
	private int[] pageSizes = new int[] { 10, 25, 50, 100 };;
	private boolean checkBoxEnabled = true;
	
	private SimplePanel tablePanel;
	private HorizontalPanel buttonsPanel;
	private Label numRecordsLabel;
	private Label prevLink, nextLink, firstLink, lastLink;
	private List<Label> pageSizeLinks = new ArrayList<Label>();
	private Label pageCountLabel;
	private ClickListener pageSizeClickListener;
	private CheckBox headerRowCheckBox;
	private List<CheckBox> dataRowsCheckBoxes = new ArrayList<CheckBox>();
	
	private static final String IMGURL_UP_ARROW = "icon_arrow_up.png";
	private static final String IMGURL_DOWN_ARROW = "icon_arrow_down.png";
	private static final String IMGURL_DELETE_BUTTON = "btn_delete.gif";
	
	private static final String STYLE_HEADER_ROW = "table-header-row";
	private static final String STYLE_HEADER_SORTABLE_COL_TEXT = "table-header-sortable-text";
	private static final String STYLE_HEADER_NONSORTABLE_COL_TEXT = "table-header-nonSortable-text";
	private static final String STYLE_DATA_EVEN_ROW = "table-data-even-row";
	private static final String STYLE_DATA_ODD_ROW = "table-data-odd-row";
	private static final String STYLE_DATA_TEXT = "table-data-text";
	private static final String STYLE_DATA_LINK = "table-data-link";
	private static final String STYLE_GENERAL_TEXT = "table-general-text";
	private static final String STYLE_BUTTON = "table-button";
	private static final String STYLE_PAGE_SIZE = "table-nav-pageSize";
	private static final String STYLE_CURRENT_PAGE_SIZE = "table-nav-currentPageSize";
	private static final String STYLE_UNAVAILABLE_PAGE_SIZE = "table-nav-unavailablePageSize";
	private static final String STYLE_TABLE_NAV_LINK = "table-nav-link";
	
	public Table(IDataProvider dataProvider) {
		this.dataProvider = dataProvider;
		dataProvider.setPageSize(pageSizes[0]);
		dataProvider.registerView(this);
		
		pageSizeClickListener = new ClickListener() {
			public void onClick(Widget sender) {
				setPageSize(Integer.parseInt(((Label) sender).getText()));
			}
		};
		
		init();
	}

	
	/**
	 * @return the checkBoxEnabled
	 */
	public boolean isCheckBoxEnabled() {
		return checkBoxEnabled;
	}

	/**
	 * @param checkBoxEnabled the checkBoxEnabled to set
	 */
	public void setCheckBoxEnabled(boolean checkBoxEnabled) {
		this.checkBoxEnabled = checkBoxEnabled;
	}

	//must return a non-empty array
	protected int[] getPageSizes() {
		return pageSizes;
	}
	
	protected HorizontalPanel getButtonsPanel() {
		return buttonsPanel;
	}
	
	private Panel createPageSizePanel() {
		HorizontalPanel panel = new HorizontalPanel();
		boolean first = true;
		for (int pageSize : getPageSizes()) {
			if(first)
				first = false;
			else {
				Label pipeLabel = new Label(" | ");
				pipeLabel.setStyleName(STYLE_GENERAL_TEXT);
				panel.add(pipeLabel);
			}
			Label pageSizeLink = new Label();
			pageSizeLink.setText(String.valueOf(pageSize));
			panel.add(pageSizeLink);
			pageSizeLinks.add(pageSizeLink);
		}
		Label suffixLabel = new Label(" per page");
		suffixLabel.setStyleName(STYLE_GENERAL_TEXT);
		panel.add(suffixLabel);
		return panel;
	}

	private Panel createNavPanel() {
		//previous link
		prevLink = new Label();
		prevLink.setText("<prev");
		prevLink.setStyleName(STYLE_TABLE_NAV_LINK);
		prevLink.addClickListener(new ClickListener() {
			public void onClick(Widget sender) {
				prev();
			}
		});

		//next link
		nextLink = new Label();
		nextLink.setText("next>");
		nextLink.setStyleName(STYLE_TABLE_NAV_LINK);
		nextLink.addClickListener(new ClickListener() {
			public void onClick(Widget sender) {
				next();
			}
		});

		//first link
		firstLink = new Label();
		firstLink.setText("<<first");
		firstLink.setStyleName(STYLE_TABLE_NAV_LINK);
		firstLink.addClickListener(new ClickListener() {
			public void onClick(Widget sender) {
				first();
			}
		});

		//last link
		lastLink = new Label();
		lastLink.setText("last>>");
		lastLink.setStyleName(STYLE_TABLE_NAV_LINK);
		lastLink.addClickListener(new ClickListener() {
			public void onClick(Widget sender) {
				last();
			}
		});
		
		//navigation panel that holds prev & next
		HorizontalPanel navPanel = new HorizontalPanel();
		navPanel.setSpacing(3);
		navPanel.setHorizontalAlignment(HorizontalPanel.ALIGN_LEFT);
		navPanel.add(firstLink);
		navPanel.add(prevLink);
		navPanel.add(nextLink);
		navPanel.add(lastLink);
		
		return navPanel;
	}
	
	private void init() {
		//table panel
		tablePanel = new SimplePanel();
		
		//num records panel
		SimplePanel numRecordsPanel = new SimplePanel();
		numRecordsLabel = new Label();
		numRecordsLabel.setStyleName(STYLE_GENERAL_TEXT);
		numRecordsPanel.setWidget(numRecordsLabel);
		
		//buttons panel
		buttonsPanel = new HorizontalPanel();
		buttonsPanel.setSpacing(5);

		Image deleteImage = new Image(IMGURL_DELETE_BUTTON);
		deleteImage.addClickListener(new ClickListener(){
			public void onClick(Widget sender) {
				delete();
			}});
		deleteImage.setStyleName(STYLE_BUTTON);
		buttonsPanel.add(deleteImage);

		
		//page size panel
		Panel pageSizePanel = createPageSizePanel();
		
		//navigation panel
		Panel navPanel = createNavPanel();
		
		//pagination panel that holds page size panel & navigation panel
		HorizontalPanel paginationPanel = new HorizontalPanel();
		paginationPanel.setWidth("100%");
		paginationPanel.setSpacing(15);
		paginationPanel.setHorizontalAlignment(HorizontalPanel.ALIGN_CENTER);
		paginationPanel.add(pageSizePanel);
		pageCountLabel = new Label();
		pageCountLabel.setStyleName(STYLE_GENERAL_TEXT);
		paginationPanel.add(pageCountLabel);
		paginationPanel.add(navPanel);

		//all put together
		VerticalPanel vp = new VerticalPanel();
		vp.setSpacing(3);
		vp.setHorizontalAlignment(VerticalPanel.ALIGN_CENTER);
		vp.add(tablePanel);
		vp.add(numRecordsPanel);
		vp.setHorizontalAlignment(VerticalPanel.ALIGN_LEFT);
		vp.add(buttonsPanel);
		vp.setHorizontalAlignment(VerticalPanel.ALIGN_CENTER);
		vp.add(paginationPanel);

		//init table
		first();
		
		initWidget(vp);
	}
	
	public void update() {
		//create table
		FlexTable table = new FlexTable();
		tablePanel.setWidget(table);

		//create header row
		table.getRowFormatter().setStyleName(0, STYLE_HEADER_ROW);
		int colIndex = 0;
		if(isCheckBoxEnabled()) {
			headerRowCheckBox = new CheckBox();
			//selecting all datarow checkboxes when header row checkbox is selected
			headerRowCheckBox.addClickListener(new ClickListener(){
				public void onClick(Widget sender) {
					CheckBox cb = (CheckBox) sender;
					for(CheckBox dataRowCB : dataRowsCheckBoxes) {
						dataRowCB.setChecked(cb.isChecked());
					}
				}});
			table.setWidget(0, colIndex++, headerRowCheckBox);
		}
		for(ColumnHeader col : dataProvider.getHeader().getColumns()) {
			HorizontalPanel headerColPanel = new HorizontalPanel();
			headerColPanel.setSpacing(3);
			headerColPanel.setVerticalAlignment(HorizontalPanel.ALIGN_MIDDLE);
			Label headerLabel = new Label(col.getName());
			headerColPanel.add(headerLabel);
			if(col.isSortable()) {
				if(dataProvider.getSortColumn().equals(col.getName())) {
					Image img = new Image((dataProvider.getSortOrder() == SortOrder.ASCENDING) ? IMGURL_UP_ARROW : IMGURL_DOWN_ARROW);
					headerColPanel.add(img);
				}
				headerLabel.setStyleName(STYLE_HEADER_SORTABLE_COL_TEXT);
				headerLabel.addClickListener(new ClickListener() {
					public void onClick(Widget sender) {
						sort(((Label)sender).getText());
					}
				});
			} else {
				headerLabel.setStyleName(STYLE_HEADER_NONSORTABLE_COL_TEXT);
			}
			table.setWidget(0, colIndex++, headerColPanel);
		}
		

		//create data rows
		dataRowsCheckBoxes.clear();
		int rowIndex = 1;
		for(Row<ColumnData> row : dataProvider.getCurrentPage()) {
			String styleName = (rowIndex % 2 == 0) ? STYLE_DATA_EVEN_ROW : STYLE_DATA_ODD_ROW;
			table.getRowFormatter().setStyleName(rowIndex, styleName);
			colIndex=0;
			if(isCheckBoxEnabled()) {
				CheckBox dataRowCheckBox = new CheckBox();
				dataRowCheckBox.setName(row.getRowId());
				//unselecting the header row checkbox when any datarow checkbox is unselected
				dataRowCheckBox.addClickListener(new ClickListener(){
					public void onClick(Widget sender) {
						if(headerRowCheckBox.isChecked()) {
							CheckBox cb = (CheckBox) sender;
							if(!cb.isChecked())
								headerRowCheckBox.setChecked(false);
						}
					}});
				dataRowsCheckBoxes.add(dataRowCheckBox);
				table.setWidget(rowIndex, colIndex++, dataRowCheckBox);
			}
			for(ColumnData col : row.getColumns()) {
				Widget cellWidget = getWidget(col, row.getRowId());
				table.setWidget(rowIndex, colIndex, cellWidget);
				colIndex++;
			}
			rowIndex++;
		}
		
		//update controls
		
		//num records panel
		numRecordsLabel.setText(dataProvider.getTotalCount() + " record(s) found");
		
		//page count label
		pageCountLabel.setText("Page " + dataProvider.getCurrentPageNumber() + " of " + dataProvider.getNumPages());
		
		//page size links
		int currentPageSize = dataProvider.getPageSize();
		for(Label pageSizeLink : pageSizeLinks) {
			//ensuring that there is only one listener for a page-size-link
			pageSizeLink.removeClickListener(pageSizeClickListener);
			pageSizeLink.addClickListener(pageSizeClickListener);
			int pageSizeLinkValue = Integer.parseInt(pageSizeLink.getText());
			if(pageSizeLinkValue == currentPageSize)
				pageSizeLink.setStyleName(STYLE_CURRENT_PAGE_SIZE);
			else if(pageSizeLinkValue <= dataProvider.getTotalCount())
				pageSizeLink.setStyleName(STYLE_PAGE_SIZE);
			else {
				pageSizeLink.setStyleName(STYLE_UNAVAILABLE_PAGE_SIZE);
				pageSizeLink.removeClickListener(pageSizeClickListener);
			}
		}

		//nav links
		prevLink.setVisible(dataProvider.hasPrevPage());
		nextLink.setVisible(dataProvider.hasNextPage());
		firstLink.setVisible(dataProvider.hasPrevPage());
		lastLink.setVisible(dataProvider.hasNextPage());
	}

	private Widget getWidget(ColumnData col, final String rowId) {
		if(col instanceof Hyperlink) {
			Hyperlink hyperlink = (Hyperlink) col;
			HTML html = new HTML("<a href=\"" + hyperlink.getUrl() + "\">" + hyperlink.getDisplayText() + "</a>");
			html.setStyleName(STYLE_DATA_LINK);
			return html;
		} else if(col instanceof com.tandbergtv.cms.portal.ui.widget.client.Image) {
			com.tandbergtv.cms.portal.ui.widget.client.Image img = (com.tandbergtv.cms.portal.ui.widget.client.Image) col;
			Image imgWidget = new Image(img.getUrl());
			imgWidget.setTitle(img.getAltText());
			return imgWidget;
		} else if(col instanceof Text) {
			Text text = (Text) col;
			Label label = new Label(text.getText());
			if(text.isDetailsLink()) {
				label.setStyleName(STYLE_DATA_LINK);
				label.addClickListener(new ClickListener(){
					public void onClick(Widget sender) {
						viewDetails(rowId);
					}});
			} else {
				label.setStyleName(STYLE_DATA_TEXT);
			}
			return label;
		}
		
		return new Label(col.getName());
	}
	
	private void viewDetails(String rowId) {
		//TODO
		Window.alert("viewDetails called for: " + rowId);
	}
	
	private void prev() {
		dataProvider.gotoPrevPage();
	}

	private void next() {
		dataProvider.gotoNextPage();
	}
	
	private void first() {
		dataProvider.gotoFirstPage();
	}
	
	private void last() {
		dataProvider.gotoLastPage();
	}
	
	private void delete() {
		List<String> selectedRowIds = getSelectedRowIds();
		if(selectedRowIds.isEmpty()) {
			Window.alert("Please select atleast one record");
			return;
		}
		dataProvider.delete(selectedRowIds);
	}

	private void setPageSize(int pageSize) {
		if(pageSize == dataProvider.getPageSize())
			return;
		
		dataProvider.setPageSize(pageSize);
	}

	private void sort(String columnName) {
		dataProvider.sort(columnName);
	}

	public List<String> getSelectedRowIds() {
		List<String> selectedRowIds = new ArrayList<String>();
		for(CheckBox cb : dataRowsCheckBoxes) {
			if(cb.isChecked())
				selectedRowIds.add(cb.getName());
		}
		return selectedRowIds;
	}
}
