/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.web.actions.job;

import com.tandbergtv.watchpoint.pmm.entities.EntityType;
import com.tandbergtv.watchpoint.pmm.job.IJobManager;
import com.tandbergtv.watchpoint.pmm.job.JobManager;
import com.tandbergtv.watchpoint.pmm.job.ui.JobUIConstants;
import com.tandbergtv.watchpoint.pmm.web.formbeans.job.JobListForm;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.actions.DispatchAction;

public class JobListManagementAction
extends DispatchAction {
    private static String PARTNER_JOB_LIST = "partnerJobList";
    private static String SERVICE_JOB_LIST = "serviceJobList";
    private Logger logger = Logger.getLogger(JobListManagementAction.class);

    public ActionForward deleteJobs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JobListForm jobListform = (JobListForm)form;
        IJobManager jobMgr = JobManager.getInstance();
        String[] jobIdsForDeletion = jobListform.getJobIds();
        ActionMessages messages = new ActionMessages();
        for (int i = 0; i < jobIdsForDeletion.length; ++i) {
            long jobIdToDelete = Long.parseLong(jobIdsForDeletion[i]);
            boolean deleted = jobMgr.deleteJob(jobIdToDelete);
            if (deleted) {
                this.logger.debug((Object)("Job [" + jobIdToDelete + "] is deleted -->" + deleted));
                messages.add("infoMessages", new ActionMessage(JobUIConstants.DISPLAY_MESSAGE, (Object)("Job [" + jobIdToDelete + "] deleted successfully.")));
                continue;
            }
            messages.add("errorMessages", new ActionMessage(JobUIConstants.DISPLAY_ERRORS, (Object)("Job [" + jobIdToDelete + "] could not be deleted.")));
        }
        this.saveErrors(request, messages);
        this.saveMessages(request, messages);
        if (jobListform.getEntityType().equalsIgnoreCase(EntityType.SERVICE.toString())) {
            return mapping.findForward(SERVICE_JOB_LIST);
        }
        return mapping.findForward(PARTNER_JOB_LIST);
    }
}

