/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.web.actions.partner;

import com.tandbergtv.watchpoint.pmm.entities.ContainerType;
import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import com.tandbergtv.watchpoint.pmm.entities.Job;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.PartnerContact;
import com.tandbergtv.watchpoint.pmm.entities.PartnerType;
import com.tandbergtv.watchpoint.pmm.entities.PitchFrequency;
import com.tandbergtv.watchpoint.pmm.entities.Schedule;
import com.tandbergtv.watchpoint.pmm.entities.Service;
import com.tandbergtv.watchpoint.pmm.job.IJobManager;
import com.tandbergtv.watchpoint.pmm.job.JobManager;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerManagement;
import com.tandbergtv.watchpoint.pmm.partner.PartnerManager;
import com.tandbergtv.watchpoint.pmm.service.IServiceManagement;
import com.tandbergtv.watchpoint.pmm.service.ServiceManager;
import com.tandbergtv.watchpoint.pmm.util.ContextManager;
import com.tandbergtv.watchpoint.pmm.util.IContextManager;
import com.tandbergtv.watchpoint.pmm.web.formbeans.job.JobForm;
import com.tandbergtv.watchpoint.pmm.web.formbeans.job.JobListForm;
import com.tandbergtv.watchpoint.pmm.web.formbeans.partner.PartnerForm;
import com.tandbergtv.watchpoint.pmm.web.formbeans.partner.PartnerListForm;
import com.tandbergtv.watchpoint.pmm.web.formbeans.service.ServiceForm;
import com.tandbergtv.watchpoint.pmm.web.formbeans.service.ServiceListForm;
import com.tandbergtv.watchpoint.pmm.web.schedule.ScheduleForm;
import com.tandbergtv.watchpoint.pmm.web.schedule.ScheduleListForm;
import com.tandbergtv.watchpoint.pmm.web.util.CommonUtils;
import com.tandbergtv.watchpoint.pmm.web.util.GUISearchHelper;
import com.tandbergtv.watchpoint.pmm.web.util.PMMTableConfigHelper;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.web.formbeans.BaseForm;
import com.tandbergtv.workflow.web.util.ExportUtility;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.actions.DispatchAction;

public class PartnerDispatchAction
extends DispatchAction {
    private static final String PARTNERS = "partners";
    private static final Logger logger = Logger.getLogger(PartnerDispatchAction.class);
    private static final String FORWARD_POST_CREATE_PARTNER = "postCreatePartner";
    private static final String FORWARD_PARTNER_DETAILS = "partnerDetails";
    private static final String JOBS = "jobs";
    private static final String SCHEDULES = "schedules";
    private static String CONTAINER_CACHE_SERVICE_NAME = "Container Cache";
    private static final String DISPLAY_MESSAGE = "partner.update.messages";
    private static final String DISPLAY_ERRORS = "partner.update.errors";
    private static final String PMM_MESSAGE_RESOURCES_FILE_NAME = "WorkFlowMessageResources";
    private IPartnerManagement partnerManager = PartnerManager.getInstance();

    public ActionForward createPartnerSetup(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return actionMapping.findForward("createPartner");
    }

    public ActionForward createPartner(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PartnerForm partnerForm = (PartnerForm)actionForm;
        Partner partner = new Partner();
        partner = this.preparePartner(partnerForm, partner);
        partner = this.partnerManager.createPartner(partner);
        logger.debug((Object)("new partner id=" + partner.getId()));
        partnerForm.setId(String.valueOf(partner.getId()));
        partnerForm.setContextId(partner.getContainerContextId());
        request.setAttribute("partnerCreated", (Object)"partnerCreated");
        request.setAttribute("OUTPUT", (Object)partnerForm);
        return actionMapping.findForward(FORWARD_POST_CREATE_PARTNER);
    }

    private Partner preparePartner(PartnerForm partnerForm, Partner partner) throws Exception {
        logger.debug((Object)((Object)((Object)this) + "preparePartner()---->Starting"));
        partner.setName(partnerForm.getName());
        partner.setType(PartnerType.getById((Long)Long.parseLong(partnerForm.getTypeId())));
        partner.setProviderId(partnerForm.getProviderId());
        PartnerContact contact = this.createPartnerContact(partnerForm, partner);
        partner.setContact(contact);
        if (partner.getType().equals((Object)PartnerType.DISTRIBUTION)) {
            logger.debug((Object)("partnerForm.getDefaultPitchFreqWeeks()=" + partnerForm.getDefaultPitchFreqWeeks() + "."));
            if (partnerForm.getDefaultPitchFreqWeeks() != null && !partnerForm.getDefaultPitchFreqWeeks().trim().equals("")) {
                PitchFrequency defaultPitchFreq = this.createDefaultPitchFrequency(partnerForm, partner);
                partner.setDefaultPitchFrequency(defaultPitchFreq);
            }
        }
        partner.setNotes(partnerForm.getNotes());
        partner.setLookupKey(partnerForm.getLookupKey());
        IContextManager ctxMgr = ContextManager.getInstance();
        partner.setContext(ctxMgr.getContext(partnerForm.getContextId()));
        return partner;
    }

    private PitchFrequency createDefaultPitchFrequency(PartnerForm partnerForm, Partner partner) {
        PitchFrequency defaultPitchFreq = new PitchFrequency();
        defaultPitchFreq.setId(partnerForm.getDefPitchFreqId());
        defaultPitchFreq.setDistributionPartner(partner);
        defaultPitchFreq.setPitchDay(Integer.parseInt(partnerForm.getDefaultPitchFreqDayId()));
        defaultPitchFreq.setWeeksBetweenPitch(Integer.parseInt(partnerForm.getDefaultPitchFreqWeeks()));
        return defaultPitchFreq;
    }

    private PartnerContact createPartnerContact(PartnerForm partnerForm, Partner partner) {
        PartnerContact contact = new PartnerContact();
        contact.setId(partnerForm.getContactId());
        contact.setEmail(partnerForm.getEmail());
        contact.setFirstName(partnerForm.getFirstName());
        contact.setLastName(partnerForm.getLastName());
        contact.setPartner(partner);
        return contact;
    }

    public ActionForward getPartnersView(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean exportFlag = false;
        exportFlag = request.getParameter("exportData") != null && request.getParameter("exportData").toString().equals("export");
        PartnerListForm partnerListForm = (PartnerListForm)actionForm;
        SearchCriteria searchCriteria = partnerListForm.getSearchCriteria();
        logger.debug((Object)("The Search Criteria--->" + searchCriteria));
        ArrayList<PartnerForm> partners = new ArrayList<PartnerForm>();
        if (exportFlag) {
            searchCriteria.setStartingRecordNumber(0);
            searchCriteria.setRecordsCount(Integer.MAX_VALUE);
        }
        List lsPartners = this.partnerManager.getPartnersBySearchCriteria(searchCriteria);
        PartnerForm partnerForm = null;
        for (Partner partner : lsPartners) {
            logger.debug((Object)("Partner Name is---->" + partner.getName()));
            partnerForm = new PartnerForm();
            partnerForm = this.preparePartnerForm(partner, partnerForm);
            partners.add(partnerForm);
        }
        int iTotalRecords = this.partnerManager.getTotalActivePartnerCount();
        logger.debug((Object)("Total number of records -->" + iTotalRecords));
        partnerListForm.setTotalRecords(iTotalRecords);
        partnerListForm.setPartnerList(partners);
        if (exportFlag) {
            ExportUtility exportUtility = new ExportUtility();
            exportUtility.exportDataToExcel(request, response, (BaseForm)partnerListForm, partners, PMMTableConfigHelper.getTableConfigFile(), PMM_MESSAGE_RESOURCES_FILE_NAME);
            return null;
        }
        PartnerListForm paginationAndSortingForm = partnerListForm;
        request.setAttribute("Search_Criteria", (Object)paginationAndSortingForm);
        return actionMapping.findForward(PARTNERS);
    }

    private PartnerForm preparePartnerForm(Partner partner, PartnerForm partnerForm) {
        partnerForm.setId(String.valueOf(partner.getId()));
        partnerForm.setName(partner.getName());
        PartnerType partnerType = partner.getType();
        partnerForm.setTypeName(partnerType.name());
        partnerForm.setTypeId(String.valueOf(partnerType.getTypeId()));
        partnerForm.setProviderId(partner.getProviderId());
        PartnerContact contact = partner.getContact();
        partnerForm.setEmail(contact.getEmail());
        partnerForm.setFirstName(contact.getFirstName());
        partnerForm.setLastName(contact.getLastName());
        partnerForm.setContactId(contact.getId());
        partnerForm.setNotes(partner.getNotes());
        partnerForm.setLookupKey(partner.getLookupKey());
        partnerForm.setContextId(partner.getContext().getId());
        PitchFrequency defaultPitchFrequency = partner.getDefaultPitchFrequency();
        if (defaultPitchFrequency != null) {
            partnerForm.setDefPitchFreqId(defaultPitchFrequency.getId());
            if (partner.getType().equals((Object)PartnerType.DISTRIBUTION)) {
                partnerForm.setDefaultPitchFreqWeeks(Integer.toString(defaultPitchFrequency.getWeeksBetweenPitch()));
                partnerForm.setDefaultPitchFreqDayId(Integer.toString(defaultPitchFrequency.getPitchDay()));
            }
            logger.debug((Object)("defaultPitchFrequency.getId()=" + defaultPitchFrequency.getId()));
        }
        logger.debug((Object)("partner: " + partner.getId() + ", partnerType: " + partnerType.name() + ", " + partnerType.getTypeId()));
        return partnerForm;
    }

    public ActionForward deletePartners(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PartnerForm partnerForm = (PartnerForm)actionForm;
        String[] strPartnerIds = partnerForm.getSelectedPartners();
        ActionMessages messages = new ActionMessages();
        for (int i = 0; i < strPartnerIds.length; ++i) {
            try {
                boolean isDeleted = this.partnerManager.deletePartner(Long.parseLong(strPartnerIds[i]));
                if (isDeleted) {
                    messages.add("infoMessages", new ActionMessage(DISPLAY_MESSAGE, (Object)("Partner [" + strPartnerIds[i] + "] deleted successfully.")));
                    continue;
                }
                messages.add("errorMessages", new ActionMessage(DISPLAY_ERRORS, (Object)("Partner [" + strPartnerIds[i] + "] cannot be deleted.")));
                continue;
            }
            catch (Exception exception) {
                messages.add("errorMessages", new ActionMessage(DISPLAY_ERRORS, (Object)exception.getMessage()));
            }
        }
        this.saveErrors(request, messages);
        this.saveMessages(request, messages);
        return actionMapping.findForward(PARTNERS);
    }

    public ActionForward getPartnerDetails(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        logger.debug((Object)"Starting---->");
        Long contextId = null;
        PartnerForm partnerForm = (PartnerForm)actionForm;
        contextId = partnerForm.getContextId();
        logger.debug((Object)("Partner contextId------->" + contextId));
        Long partnerId = null;
        if (contextId != null && contextId != 0L) {
            ICacheService containerCache = (ICacheService)ServiceRegistry.getDefault().lookup(CONTAINER_CACHE_SERVICE_NAME);
            IContainer container = (IContainer)containerCache.get((Serializable)contextId);
            partnerId = ((Partner)container).getId();
        } else if (partnerForm.getId() != null) {
            partnerId = Long.valueOf(partnerForm.getId());
        }
        logger.debug((Object)("Partner Id------->" + partnerId));
        Partner partner = this.partnerManager.getPartner(partnerId.longValue());
        partnerForm = this.preparePartnerForm(partner, partnerForm);
        request.setAttribute("TabbedPMMPartnersModify", (Object)"TabbedPMMPartnersModify");
        request.setAttribute("OUTPUT", (Object)partnerForm);
        logger.debug((Object)"Ending---->");
        return actionMapping.findForward(FORWARD_PARTNER_DETAILS);
    }

    public ActionForward updatePartner(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            PartnerForm partnerForm = (PartnerForm)actionForm;
            Partner partner = this.partnerManager.getPartner(Long.parseLong(partnerForm.getId()));
            this.preparePartner(partnerForm, partner);
            partner = this.partnerManager.updatePartner(partner);
            partnerForm.setId(String.valueOf(partner.getId()));
            request.setAttribute("partnerUpdated", (Object)"partnerUpdated");
            request.setAttribute("OUTPUT", (Object)partnerForm);
        }
        catch (Exception validationException) {
            // empty catch block
        }
        return actionMapping.findForward(FORWARD_POST_CREATE_PARTNER);
    }

    public ActionForward getJobsForPartner(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JobListForm jobListForm = (JobListForm)actionForm;
        String contextId = jobListForm.getContextId();
        logger.debug((Object)("Partner Context id --->" + contextId));
        ArrayList<JobForm> jobForms = new ArrayList<JobForm>();
        IJobManager jobManager = JobManager.getInstance();
        List lsJobs = jobManager.getAllJobs(Long.parseLong(contextId));
        JobForm jobForm = null;
        for (Job job : lsJobs) {
            logger.debug((Object)("Job Name is---->" + job.getName()));
            jobForm = new JobForm();
            jobForm = this.prepareJobForm(job, jobForm);
            jobForms.add(jobForm);
        }
        int iTotalRecords = lsJobs != null ? lsJobs.size() : 0;
        logger.debug((Object)("Total number of records -->" + iTotalRecords));
        jobListForm.setTotalRecords(iTotalRecords);
        ICacheService containerCache = (ICacheService)ServiceRegistry.getDefault().lookup(CONTAINER_CACHE_SERVICE_NAME);
        IContainer container = (IContainer)containerCache.get((Serializable)new Long(contextId));
        ContainerType containerType = container.getContainerType();
        if (containerType == ContainerType.PARTNER) {
            String partnerName = ((Partner)container).getName();
            jobListForm.setName(partnerName);
            PartnerType partnerType = ((Partner)container).getType();
            if (partnerType == PartnerType.SELF) {
                jobListForm.setEntityType(partnerType.toString());
            } else {
                jobListForm.setEntityType(container.getContainerType().toString());
            }
        } else {
            jobListForm.setEntityType(container.getContainerType().toString());
        }
        jobListForm.setJobList(jobForms);
        request.setAttribute("Search_Criteria", (Object)jobListForm);
        request.setAttribute("TabbedPMMPartnersModify", (Object)"TabbedPMMPartnersModify");
        return actionMapping.findForward(JOBS);
    }

    private JobForm prepareJobForm(Job job, JobForm jobForm) {
        jobForm.setId(job.getId());
        jobForm.setName(job.getName());
        jobForm.setSelectedTemplate(job.getTemplateName());
        jobForm.setSelectedPriority(job.getPriority().name());
        jobForm.setScheduleRule(job.getScheduleRuleString());
        if (job.isTitleAssociated()) {
            jobForm.setIsAssociatedWithTitles("YES");
        } else {
            jobForm.setIsAssociatedWithTitles("NO");
        }
        return jobForm;
    }

    public ActionForward getCurrentSchedulesForPartner(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int iTotalRecords;
        ContainerType containerType;
        ScheduleListForm scheduleListForm = (ScheduleListForm)actionForm;
        String contextId = scheduleListForm.getContextId();
        logger.debug((Object)("Partner Context id --->" + contextId));
        ArrayList<ScheduleForm> scheduleForms = new ArrayList<ScheduleForm>();
        Collection<Schedule> lsSchedules = null;
        ICacheService containerCache = (ICacheService)ServiceRegistry.getDefault().lookup(CONTAINER_CACHE_SERVICE_NAME);
        IContainer container = (IContainer)containerCache.get((Serializable)new Long(contextId));
        if (container == null) {
            logger.debug((Object)("container is null for contextId=" + contextId));
        }
        if ((containerType = container.getContainerType()) == ContainerType.PARTNER) {
            Partner partner = (Partner)container;
            String partnerName = partner.getName();
            scheduleListForm.setName(partnerName);
            Long partnerId = partner.getId();
            scheduleListForm.setId(partnerId.toString());
            PartnerType partnerType = ((Partner)container).getType();
            if (partnerType == PartnerType.SOURCE) {
                lsSchedules = GUISearchHelper.getCurrentPlanners(partnerId);
                scheduleListForm.setTypeName("SOURCE");
            } else if (partnerType == PartnerType.DISTRIBUTION) {
                lsSchedules = GUISearchHelper.getCurrentPitchSchedules(new Long(contextId));
                scheduleListForm.setTypeName("DISTRIBUTION");
            } else {
                scheduleListForm.setTypeName("SELF");
            }
        }
        ScheduleForm scheduleForm = null;
        if (lsSchedules != null) {
            for (Schedule schedule : lsSchedules) {
                logger.debug((Object)("Schedule id is---->" + schedule.getId()));
                scheduleForm = new ScheduleForm();
                scheduleForm = this.prepareScheduleForm(schedule, scheduleForm);
                scheduleForms.add(scheduleForm);
            }
            iTotalRecords = lsSchedules.size();
        } else {
            iTotalRecords = 0;
        }
        logger.debug((Object)("Total number of records -->" + iTotalRecords));
        scheduleListForm.setTotalRecords(iTotalRecords);
        scheduleListForm.setScheduleList(scheduleForms);
        request.setAttribute("Search_Criteria", (Object)scheduleListForm);
        request.setAttribute("TabbedPMMPartnersModify", (Object)"TabbedPMMPartnersModify");
        return actionMapping.findForward(SCHEDULES);
    }

    private ScheduleForm prepareScheduleForm(Schedule schedule, ScheduleForm scheduleForm) {
        scheduleForm.setScheduleId(Long.toString(schedule.getId()));
        scheduleForm.setStatus(schedule.getStatus().name());
        scheduleForm.setDate(CommonUtils.formatDate(schedule.getDate()));
        return scheduleForm;
    }

    public ActionForward getServicesForPartner(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServiceListForm serviceListForm = (ServiceListForm)actionForm;
        String contextId = serviceListForm.getContextId();
        ArrayList<ServiceForm> serviceForms = new ArrayList<ServiceForm>();
        IServiceManagement serviceManager = ServiceManager.getInstance();
        Set lsServices = serviceManager.getAllServicesAssociatedWithPartner(Long.parseLong(contextId));
        ServiceForm serviceForm = null;
        for (Service service : lsServices) {
            serviceForm = new ServiceForm();
            serviceForm = this.prepareServiceForm(service, serviceForm);
            serviceForms.add(serviceForm);
        }
        int iTotalRecords = lsServices != null ? lsServices.size() : 0;
        logger.debug((Object)("Total number of records -->" + iTotalRecords));
        serviceListForm.setTotalRecords(iTotalRecords);
        ICacheService containerCache = (ICacheService)ServiceRegistry.getDefault().lookup(CONTAINER_CACHE_SERVICE_NAME);
        IContainer container = (IContainer)containerCache.get((Serializable)new Long(contextId));
        ContainerType containerType = container.getContainerType();
        if (containerType == ContainerType.PARTNER) {
            String partnerName = ((Partner)container).getName();
            serviceListForm.setName(partnerName);
            PartnerType partnerType = ((Partner)container).getType();
            if (partnerType == PartnerType.SOURCE) {
                serviceListForm.setTypeName("SOURCE");
            } else if (partnerType == PartnerType.DISTRIBUTION) {
                serviceListForm.setTypeName("DISTRIBUTION");
            } else {
                serviceListForm.setTypeName("SELF");
            }
        }
        serviceListForm.setServiceList(serviceForms);
        request.setAttribute("Search_Criteria", (Object)serviceListForm);
        request.setAttribute("TabbedPMMPartnersModify", (Object)"TabbedPMMPartnersModify");
        return actionMapping.findForward("services");
    }

    private ServiceForm prepareServiceForm(Service service, ServiceForm serviceForm) {
        serviceForm.setId(Long.toString(service.getId()));
        serviceForm.setName(service.getName());
        serviceForm.setDescription(service.getDescription());
        return serviceForm;
    }
}

