/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.web.actions.title;

import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.util.validation.ValidationException;
import com.tandbergtv.watchpoint.pmm.util.validation.ValidationMessage;
import com.tandbergtv.watchpoint.pmm.web.actions.title.TitleAction;
import com.tandbergtv.watchpoint.pmm.web.formbeans.title.TitleForm;
import com.tandbergtv.watchpoint.pmm.web.util.HTMLOption;
import com.tandbergtv.watchpoint.pmm.web.util.TitleFacade;
import com.tandbergtv.watchpoint.pmm.web.util.TitleHelper;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

public class CreateTitleAction
extends TitleAction {
    private static final Logger logger = Logger.getLogger(CreateTitleAction.class);
    private static final String ERROR_UNMAPPEDFILES_LISTFAILURE = "error.title.unmappedFiles.listFailure";
    private static final String FORWARD_CREATE_FORM = "create";
    private static final String FORWARD_SAVE_SUCCESS = "success";

    public ActionForward create(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TitleForm form = (TitleForm)actionForm;
        this.initializeListOptions(form, request);
        if (form.getTypes() != null && !form.getTypes().isEmpty()) {
            if (form.getType() == null) {
                form.setType(form.getTypes().get(0).getValue());
            }
            form.setTitlesData(TitleHelper.getTitlesDataForSpec(form.getType()));
        }
        return actionMapping.findForward(FORWARD_CREATE_FORM);
    }

    public ActionForward save(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TitleForm form = (TitleForm)actionForm;
        try {
            Title newEmptyTitle = TitleFacade.createTitlesForSpecification(form.getType());
            this.save(form, newEmptyTitle);
        }
        catch (ValidationException ve) {
            List validationMessages = ve.getValidationMessages();
            ActionMessages actionMessages = new ActionMessages();
            for (ValidationMessage message : validationMessages) {
                String key = message.getCode();
                Object[] values = message.getProperties().toArray();
                ActionMessage actionMessage = new ActionMessage(key, values);
                actionMessages.add("Title Validation", actionMessage);
            }
            this.saveMessages(request, actionMessages);
            this.initializeListOptions(form, request);
            return actionMapping.findForward(FORWARD_CREATE_FORM);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to save the title", (Throwable)e);
            ActionMessages errors = new ActionMessages();
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(e.getMessage(), false));
            this.addErrors(request, errors);
            this.initializeListOptions(form, request);
            return actionMapping.findForward(FORWARD_CREATE_FORM);
        }
        return actionMapping.findForward(FORWARD_SAVE_SUCCESS);
    }

    private void initializeListOptions(TitleForm form, HttpServletRequest request) {
        form.setTypes(TitleFacade.getSpecifications());
        ArrayList<HTMLOption> unmappedFiles = new ArrayList(0);
        try {
            unmappedFiles = TitleFacade.getUnmappedFiles();
        }
        catch (Exception e) {
            logger.error((Object)"Exception while getting list of unmapped assets", (Throwable)e);
            ActionMessages actionMessages = new ActionMessages();
            ActionMessage actionMessage = new ActionMessage(ERROR_UNMAPPEDFILES_LISTFAILURE);
            actionMessages.add("org.apache.struts.action.GLOBAL_MESSAGE", actionMessage);
            this.addErrors(request, actionMessages);
        }
        form.setUnmappedFiles(unmappedFiles);
    }
}

