/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.web.actions.title;

import com.tandbergtv.watchpoint.pmm.entities.AssetList;
import com.tandbergtv.watchpoint.pmm.entities.ContainerType;
import com.tandbergtv.watchpoint.pmm.entities.IAssetList;
import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import com.tandbergtv.watchpoint.pmm.entities.ProgressItem;
import com.tandbergtv.watchpoint.pmm.entities.Schedule;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleListType;
import com.tandbergtv.watchpoint.pmm.web.actions.title.TitleAction;
import com.tandbergtv.watchpoint.pmm.web.formbeans.title.TitleActivity;
import com.tandbergtv.watchpoint.pmm.web.formbeans.title.TitleForm;
import com.tandbergtv.watchpoint.pmm.web.formbeans.title.TitleSchedule;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ViewTitleActivityAction
extends TitleAction {
    public ActionForward viewActivity(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TitleForm form = (TitleForm)actionForm;
        this.populateForm(form, false);
        TitleActivity titleActivity = this.buildTitleActivity(form.getTitle());
        form.setTitleActivity(titleActivity);
        this.sortTitleActivity(titleActivity);
        return actionMapping.findForward("view");
    }

    private TitleActivity buildTitleActivity(Title title) {
        TitleActivity titleActivity = new TitleActivity();
        this.buildTitleSchedules(title, titleActivity);
        Map<Long, List<ProgressItem>> progressItemMap = this.buildProgressItemMap(title);
        for (Long key : progressItemMap.keySet()) {
            AssetList assetList = this.getAssetList(title, key);
            if (assetList != null && assetList.getType() == TitleListType.PITCH) {
                Schedule schedule = (Schedule)assetList;
                long contextId = schedule.getContextID();
                TitleSchedule scheduleActivity = new TitleSchedule();
                scheduleActivity.setSchedule(schedule);
                scheduleActivity.setProgressHistory(progressItemMap.get(key));
                scheduleActivity.setContainerContextId(contextId);
                scheduleActivity.setContainer(this.getContainer(contextId));
                titleActivity.getOutgoingActivity().add(scheduleActivity);
                continue;
            }
            TitleSchedule scheduleActivity = titleActivity.getIncomingActivity();
            if (scheduleActivity == null) {
                scheduleActivity = new TitleSchedule();
                titleActivity.setIncomingActivity(scheduleActivity);
            }
            scheduleActivity.getProgressHistory().addAll((Collection<ProgressItem>)progressItemMap.get(key));
        }
        return titleActivity;
    }

    private void buildTitleSchedules(Title title, TitleActivity titleActivity) {
        List<TitleSchedule> titleSchedules = titleActivity.getTitleSchedules();
        if (title.getTitlelists() == null) {
            return;
        }
        for (IAssetList assetList : title.getTitlelists()) {
            Schedule schedule;
            TitleSchedule titleSchedule;
            TitleListType type = assetList.getType();
            if (type == TitleListType.PITCH) {
                titleSchedule = new TitleSchedule();
                schedule = (Schedule)assetList;
                titleSchedule.setSchedule(schedule);
                titleSchedule.setContainerContextId(schedule.getContextID());
                titleSchedule.setContainer(this.getContainer(schedule.getContextID()));
                titleSchedules.add(titleSchedule);
                continue;
            }
            if (type != TitleListType.PLANNER) continue;
            titleSchedule = new TitleSchedule();
            schedule = (Schedule)assetList;
            titleSchedule.setSchedule(schedule);
            Long contextId = this.getPartnerContextId(schedule.getSourcePartnerID());
            titleSchedule.setContainerContextId(contextId);
            titleSchedule.setContainer(this.getContainer(contextId));
            titleSchedules.add(titleSchedule);
        }
    }

    private Map<Long, List<ProgressItem>> buildProgressItemMap(Title title) {
        HashMap<Long, List<ProgressItem>> progressItemMap = new HashMap<Long, List<ProgressItem>>();
        if (title.getProgressItems() == null) {
            return progressItemMap;
        }
        for (ProgressItem progressItem : title.getProgressItems()) {
            Long key = progressItem.getAssetListId();
            ArrayList<ProgressItem> value = (ArrayList<ProgressItem>)progressItemMap.get(key);
            if (value == null) {
                value = new ArrayList<ProgressItem>();
                progressItemMap.put(key, value);
            }
            value.add(progressItem);
        }
        return progressItemMap;
    }

    private AssetList getAssetList(Title title, Long assetListId) {
        if (assetListId == null || title.getTitlelists() == null) {
            return null;
        }
        AssetList match = null;
        for (IAssetList assetList : title.getTitlelists()) {
            if (!assetList.getId().equals(assetListId)) continue;
            match = (AssetList)AssetList.class.cast(assetList);
            break;
        }
        return match;
    }

    private IContainer getContainer(long contextId) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        ICacheService cache = (ICacheService)registry.lookup("Container Cache");
        return (IContainer)cache.get((Serializable)Long.valueOf(contextId));
    }

    private Long getPartnerContextId(long partnerId) {
        Long partnerContextId = null;
        ServiceRegistry registry = ServiceRegistry.getDefault();
        ICacheService cache = (ICacheService)registry.lookup("Container Cache");
        for (Serializable key : cache.getKeys()) {
            IContainer container = (IContainer)cache.get(key);
            long containerId = container.getContainerId();
            if (container.getContainerType() != ContainerType.PARTNER || containerId != partnerId) continue;
            partnerContextId = (Long)key;
            break;
        }
        return partnerContextId;
    }

    private void sortTitleActivity(TitleActivity titleActivity) {
        List<TitleSchedule> titleSchedules = titleActivity.getTitleSchedules();
        if (titleSchedules != null) {
            Collections.sort(titleSchedules, new TitleScheduleComparator());
        }
        this.sortProgressHistory(titleActivity.getIncomingActivity());
        List<TitleSchedule> outgoingActivity = titleActivity.getOutgoingActivity();
        if (outgoingActivity != null) {
            for (TitleSchedule activity : outgoingActivity) {
                this.sortProgressHistory(activity);
            }
            Collections.sort(outgoingActivity, new TitleScheduleComparator());
        }
    }

    private void sortProgressHistory(TitleSchedule activity) {
        if (activity != null && activity.getProgressHistory() != null) {
            Collections.sort(activity.getProgressHistory(), new ProgressItemComparator());
        }
    }

    private class ProgressItemComparator
    implements Comparator<ProgressItem> {
        private ProgressItemComparator() {
        }

        @Override
        public int compare(ProgressItem o1, ProgressItem o2) {
            Date d1 = o1.getTimestamp();
            Date d2 = o2.getTimestamp();
            return d2.compareTo(d1);
        }
    }

    private class TitleScheduleComparator
    implements Comparator<TitleSchedule> {
        private TitleScheduleComparator() {
        }

        @Override
        public int compare(TitleSchedule o1, TitleSchedule o2) {
            Date d1 = o1.getSchedule().getDate();
            Date d2 = o2.getSchedule().getDate();
            return d2.compareTo(d1);
        }
    }
}

